/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.timer;

import com.github.castorm.kafka.connect.timer.AdaptableIntervalTimerConfig;
import com.github.castorm.kafka.connect.timer.FixedIntervalTimer;
import com.github.castorm.kafka.connect.timer.spi.Timer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.function.Function;

public class AdaptableIntervalTimer
implements Timer {
    private final Function<Map<String, ?>, AdaptableIntervalTimerConfig> configFactory;
    private FixedIntervalTimer tailTimer;
    private FixedIntervalTimer catchupTimer;
    private Long intervalMillis;
    private Instant previousLatest = Instant.EPOCH;
    private Instant currentLatest = Instant.EPOCH.plus(1L, ChronoUnit.MILLIS);

    public AdaptableIntervalTimer() {
        this(AdaptableIntervalTimerConfig::new);
    }

    public AdaptableIntervalTimer(Function<Map<String, ?>, AdaptableIntervalTimerConfig> configFactory) {
        this.configFactory = configFactory;
    }

    @Override
    public void configure(Map<String, ?> settings) {
        AdaptableIntervalTimerConfig config = this.configFactory.apply(settings);
        this.tailTimer = config.getTailTimer();
        this.catchupTimer = config.getCatchupTimer();
        this.intervalMillis = config.getTailTimer().getIntervalMillis();
    }

    @Override
    public void reset(Instant lastZero) {
        this.tailTimer.reset(lastZero);
        this.catchupTimer.reset(lastZero);
        this.previousLatest = this.currentLatest;
        this.currentLatest = lastZero;
    }

    @Override
    public Long getRemainingMillis() {
        return this.resolveTimer().getRemainingMillis();
    }

    private Timer resolveTimer() {
        return this.isCatchingUp() ? this.catchupTimer : this.tailTimer;
    }

    private boolean isCatchingUp() {
        boolean thereWereNewItems = !this.previousLatest.equals(this.currentLatest);
        boolean longAgoSinceLastItem = this.currentLatest.isBefore(Instant.now().minus(this.intervalMillis, ChronoUnit.MILLIS));
        return thereWereNewItems && longAgoSinceLastItem;
    }
}

