/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.timer;

import com.github.castorm.kafka.connect.timer.FixedIntervalTimer;
import com.github.castorm.kafka.connect.timer.FixedIntervalTimerConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class AdaptableIntervalTimerConfig
extends AbstractConfig {
    @Deprecated
    private static final String DEPRECATED_TAIL_INTERVAL_MILLIS = "http.throttler.interval.millis";
    @Deprecated
    private static final String DEPRECATED_CATCHUP_INTERVAL_MILLIS = "http.throttler.catchup.interval.millis";
    private static final String TAIL_INTERVAL_MILLIS = "http.timer.interval.millis";
    private static final String CATCHUP_INTERVAL_MILLIS = "http.timer.catchup.interval.millis";
    private static final long DEFAULT_TAIL_INTERVAL_MILLIS = 60000L;
    private static final long DEFAULT_CATCHUP_INTERVAL_MILLIS = 30000L;
    private final FixedIntervalTimer tailTimer;
    private final FixedIntervalTimer catchupTimer;

    public AdaptableIntervalTimerConfig(Map<String, ?> originals) {
        super(AdaptableIntervalTimerConfig.config(), originals);
        Long tailIntervalMillis = this.getFromPropertyOrDeprecatedProperty(TAIL_INTERVAL_MILLIS, DEPRECATED_TAIL_INTERVAL_MILLIS, 60000L);
        Long catchupIntervalMillis = this.getFromPropertyOrDeprecatedProperty(CATCHUP_INTERVAL_MILLIS, DEPRECATED_CATCHUP_INTERVAL_MILLIS, 30000L);
        this.tailTimer = new FixedIntervalTimer(__ -> new FixedIntervalTimerConfig(AdaptableIntervalTimerConfig.mapOf(TAIL_INTERVAL_MILLIS, tailIntervalMillis)));
        this.tailTimer.configure(Collections.emptyMap());
        this.catchupTimer = new FixedIntervalTimer(__ -> new FixedIntervalTimerConfig(AdaptableIntervalTimerConfig.mapOf(TAIL_INTERVAL_MILLIS, catchupIntervalMillis)));
        this.catchupTimer.configure(Collections.emptyMap());
    }

    private Long getFromPropertyOrDeprecatedProperty(String property, String deprecatedProperty, Long defaultValue) {
        Long value = this.getLong(property);
        if (!value.equals(defaultValue)) {
            return value;
        }
        return this.getLong(deprecatedProperty);
    }

    private static Map<String, ?> mapOf(final String key, final Long value) {
        return new HashMap<String, String>(){
            {
                this.put(key, String.valueOf(value));
            }
        };
    }

    public static ConfigDef config() {
        return new ConfigDef().define(DEPRECATED_TAIL_INTERVAL_MILLIS, ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.HIGH, "(Deprecated) Throttle Tail Interval Millis").define(TAIL_INTERVAL_MILLIS, ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.HIGH, "Timer Tail Interval Millis").define(DEPRECATED_CATCHUP_INTERVAL_MILLIS, ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Importance.HIGH, "(Deprecated) Throttle Catchup Interval Millis").define(CATCHUP_INTERVAL_MILLIS, ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Importance.HIGH, "Timer Catchup Interval Millis");
    }

    public FixedIntervalTimer getTailTimer() {
        return this.tailTimer;
    }

    public FixedIntervalTimer getCatchupTimer() {
        return this.catchupTimer;
    }
}

