/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.timer;

import com.github.castorm.kafka.connect.timer.FixedIntervalTimerConfig;
import com.github.castorm.kafka.connect.timer.spi.Timer;
import java.time.Instant;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedIntervalTimer
implements Timer {
    private static final Logger log = LoggerFactory.getLogger(FixedIntervalTimer.class);
    private final Function<Map<String, ?>, FixedIntervalTimerConfig> configFactory;
    private Long intervalMillis;
    private Long lastPollMillis;

    public FixedIntervalTimer() {
        this(FixedIntervalTimerConfig::new);
    }

    FixedIntervalTimer(Function<Map<String, ?>, FixedIntervalTimerConfig> configFactory) {
        this(configFactory, System::currentTimeMillis);
    }

    FixedIntervalTimer(Function<Map<String, ?>, FixedIntervalTimerConfig> configFactory, Supplier<Long> lastPollMillisInitializer) {
        this.configFactory = configFactory;
        this.lastPollMillis = lastPollMillisInitializer.get();
    }

    @Override
    public void configure(Map<String, ?> settings) {
        FixedIntervalTimerConfig config = this.configFactory.apply(settings);
        this.intervalMillis = config.getPollIntervalMillis();
    }

    @Override
    public Long getRemainingMillis() {
        long now = System.currentTimeMillis();
        long sinceLastMillis = now - this.lastPollMillis;
        return Math.max(this.intervalMillis - sinceLastMillis, 0L);
    }

    @Override
    public void reset(Instant lastZero) {
        this.lastPollMillis = System.currentTimeMillis();
    }

    public Long getIntervalMillis() {
        return this.intervalMillis;
    }
}

