/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.timer;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class FixedIntervalTimerConfig
extends AbstractConfig {
    @Deprecated
    private static final String DEPRECATED_INTERVAL_MILLIS = "http.throttler.interval.millis";
    static final String TIMER_INTERVAL_MILLIS = "http.timer.interval.millis";
    private static final long DEFAULT_TAIL_INTERVAL_MILLIS = 60000L;
    private final Long pollIntervalMillis = this.resolvePollIntervalMillis();

    public FixedIntervalTimerConfig(Map<String, ?> originals) {
        super(FixedIntervalTimerConfig.config(), originals);
    }

    private Long resolvePollIntervalMillis() {
        Long value = this.getLong(TIMER_INTERVAL_MILLIS);
        if (!value.equals(60000L)) {
            return value;
        }
        return this.getLong(DEPRECATED_INTERVAL_MILLIS);
    }

    public static ConfigDef config() {
        return new ConfigDef().define(TIMER_INTERVAL_MILLIS, ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.HIGH, "Timer Interval Millis").define(DEPRECATED_INTERVAL_MILLIS, ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.HIGH, "(Deprecated) Timer Interval Millis");
    }

    public Long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }
}

