/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.timer;

import com.github.castorm.kafka.connect.timer.spi.Sleeper;
import com.github.castorm.kafka.connect.timer.spi.Throttler;
import com.github.castorm.kafka.connect.timer.spi.Timer;
import java.time.Instant;

public class TimerThrottler
implements Throttler {
    private final Timer timer;
    private final Sleeper sleeper;

    public TimerThrottler(Timer timer) {
        this(timer, Thread::sleep);
    }

    @Override
    public void throttle() throws InterruptedException {
        Long remainingMillis = this.timer.getRemainingMillis();
        if (remainingMillis > 0L) {
            this.sleeper.sleep(remainingMillis);
        }
    }

    public void throttle(Instant lastZero) throws InterruptedException {
        this.timer.reset(lastZero);
        this.throttle();
    }

    public TimerThrottler(Timer timer, Sleeper sleeper) {
        this.timer = timer;
        this.sleeper = sleeper;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

