/*
 * Decompiled with CFR 0.152.
 */
package scalacache.memcached;

import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y2q!\u0001\u0002\u0011\u0002\u0007\u0005qAA\u000bNK6\u001c\u0017m\u00195fIR#FjQ8om\u0016\u0014H/\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\u0005)\u0011AC:dC2\f7-Y2iK\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A%\u001b8ji\u0012\"\u0012!\u0005\t\u0003\u0013II!a\u0005\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b+\u0001\u0011\r\u0011\"\u0004\u0017\u0003\u0019awnZ4feV\tq\u0003\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005)1\u000f\u001c45U*\tA$A\u0002pe\u001eL!AH\r\u0003\r1{wmZ3s\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003E!x.T3nG\u0006\u001c\u0007.\u001a3FqBL'/\u001f\u000b\u0003E\u0015\u0002\"!C\u0012\n\u0005\u0011R!aA%oi\")ae\ba\u0001O\u0005\u0019A\u000f\u001e7\u0011\u0007%A#&\u0003\u0002*\u0015\t1q\n\u001d;j_:\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u0011\u0011,(/\u0019;j_:T!a\f\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00022Y\tAA)\u001e:bi&|g\u000eC\u00034\u0001\u0011%A'\u0001\tekJ\fG/[8o)>,\u0005\u0010]5ssR\u0011!%\u000e\u0005\u0006[I\u0002\rA\u000b")
public interface MemcachedTTLConverter {
    public void scalacache$memcached$MemcachedTTLConverter$_setter_$scalacache$memcached$MemcachedTTLConverter$$logger_$eq(Logger var1);

    public Logger scalacache$memcached$MemcachedTTLConverter$$logger();

    public static /* synthetic */ int toMemcachedExpiry$(MemcachedTTLConverter $this, Option ttl) {
        return $this.toMemcachedExpiry((Option<Duration>)ttl);
    }

    default public int toMemcachedExpiry(Option<Duration> ttl) {
        return BoxesRunTime.unboxToInt((Object)ttl.map((Function1 & java.io.Serializable & Serializable)duration -> BoxesRunTime.boxToInteger((int)this.durationToExpiry(duration))).getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
    }

    private int durationToExpiry(Duration duration) {
        int n;
        Duration duration2 = duration;
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        Duration duration3 = duration2;
        if (!(finiteDuration != null ? !finiteDuration.equals(duration3) : duration3 != null)) {
            n = 0;
        } else if (duration2.$less((Object)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())) {
            if (this.scalacache$memcached$MemcachedTTLConverter$$logger().isWarnEnabled()) {
                this.scalacache$memcached$MemcachedTTLConverter$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Because Memcached does not support sub-second expiry, TTL of ", " will be rounded up to 1 second"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duration2})));
            }
            n = 1;
        } else if (duration2.$less$eq((Object)new package.DurationInt(package$.MODULE$.DurationInt(30)).days())) {
            n = (int)duration2.toSeconds();
        } else {
            DateTime expiryTime = DateTime.now().plusSeconds((int)duration2.toSeconds());
            n = (int)(expiryTime.getMillis() / 1000L);
        }
        return n;
    }

    public static void $init$(MemcachedTTLConverter $this) {
        $this.scalacache$memcached$MemcachedTTLConverter$_setter_$scalacache$memcached$MemcachedTTLConverter$$logger_$eq(LoggerFactory.getLogger((String)$this.getClass().getName()));
    }
}

