/*
 * Decompiled with CFR 0.152.
 */
package scalacache.memcached;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005E3qAB\u0004\u0011\u0002\u0007\u0005A\u0002C\u0003\u0014\u0001\u0011\u0005A\u0003C\u0004\u0019\u0001\t\u0007IQB\r\t\u000b\t\u0002A\u0011A\u0012\t\u000f}\u0002\u0011\u0013!C\u0001\u0001\")A\n\u0001C\u0005\u001b\n)R*Z7dC\u000eDW\r\u001a+U\u0019\u000e{gN^3si\u0016\u0014(B\u0001\u0005\n\u0003%iW-\\2bG\",GMC\u0001\u000b\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003U\u0001\"A\u0004\f\n\u0005]y!\u0001B+oSR\fa\u0001\\8hO\u0016\u0014X#\u0001\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!B:mMRR'\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t1Aj\\4hKJ\f\u0011\u0003^8NK6\u001c\u0017m\u00195fI\u0016C\b/\u001b:z)\t!#\u0007\u0006\u0002&QA\u0011aBJ\u0005\u0003O=\u00111!\u00138u\u0011\u001dI3\u0001%AA\u0004)\nQa\u00197pG.\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\tQLW.\u001a\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDFA\u0003DY>\u001c7\u000eC\u00034\u0007\u0001\u0007A'A\u0002ui2\u00042AD\u001b8\u0013\t1tB\u0001\u0004PaRLwN\u001c\t\u0003quj\u0011!\u000f\u0006\u0003um\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0003y=\t!bY8oGV\u0014(/\u001a8u\u0013\tq\u0014H\u0001\u0005EkJ\fG/[8o\u0003m!x.T3nG\u0006\u001c\u0007.\u001a3FqBL'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eQ\u0011\u0011i\u0013\u0016\u0003U\t[\u0013a\u0011\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!{\u0011AC1o]>$\u0018\r^5p]&\u0011!*\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"B\u001a\u0005\u0001\u0004!\u0014\u0001\u00053ve\u0006$\u0018n\u001c8U_\u0016C\b/\u001b:z)\tq\u0005\u000b\u0006\u0002&\u001f\")\u0011&\u0002a\u0002U!)!(\u0002a\u0001o\u0001")
public interface MemcachedTTLConverter {
    public void scalacache$memcached$MemcachedTTLConverter$_setter_$scalacache$memcached$MemcachedTTLConverter$$logger_$eq(Logger var1);

    public Logger scalacache$memcached$MemcachedTTLConverter$$logger();

    public static /* synthetic */ int toMemcachedExpiry$(MemcachedTTLConverter $this, Option ttl, Clock clock) {
        return $this.toMemcachedExpiry((Option<Duration>)ttl, clock);
    }

    default public int toMemcachedExpiry(Option<Duration> ttl, Clock clock) {
        return BoxesRunTime.unboxToInt((Object)ttl.map((Function1 & Serializable)duration -> BoxesRunTime.boxToInteger((int)this.durationToExpiry(duration, clock))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static /* synthetic */ Clock toMemcachedExpiry$default$2$(MemcachedTTLConverter $this, Option ttl) {
        return $this.toMemcachedExpiry$default$2((Option<Duration>)ttl);
    }

    default public Clock toMemcachedExpiry$default$2(Option<Duration> ttl) {
        return Clock.systemUTC();
    }

    private int durationToExpiry(Duration duration, Clock clock) {
        int n;
        Duration duration2 = duration;
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        Duration duration3 = duration2;
        if (!(finiteDuration != null ? !finiteDuration.equals(duration3) : duration3 != null)) {
            n = 0;
        } else if (duration2.$less((Object)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())) {
            if (this.scalacache$memcached$MemcachedTTLConverter$$logger().isWarnEnabled()) {
                this.scalacache$memcached$MemcachedTTLConverter$$logger().warn(new StringBuilder(92).append("Because Memcached does not support sub-second expiry, TTL of ").append(duration2).append(" will be rounded up to 1 second").toString());
            }
            n = 1;
        } else if (duration2.$less$eq((Object)new package.DurationInt(package$.MODULE$.DurationInt(30)).days())) {
            n = (int)duration2.toSeconds();
        } else {
            Instant expiryTime = Instant.now(clock).plusSeconds((int)duration2.toSeconds());
            n = (int)(expiryTime.toEpochMilli() / 1000L);
        }
        return n;
    }

    public static void $init$(MemcachedTTLConverter $this) {
        $this.scalacache$memcached$MemcachedTTLConverter$_setter_$scalacache$memcached$MemcachedTTLConverter$$logger_$eq(LoggerFactory.getLogger((String)$this.getClass().getName()));
    }
}

