/*
 * Decompiled with CFR 0.152.
 */
package scalacache.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalacache.redis.RedisSerialization;

public abstract class RedisSerialization$class {
    public static byte[] withObjectOutputStream(RedisSerialization $this, byte typeId, Function1 f) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(typeId);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        f.apply((Object)oos);
        oos.flush();
        return baos.toByteArray();
    }

    public static byte[] serialize(RedisSerialization $this, Object value) {
        byte[] byArray;
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            byArray = $this.withObjectOutputStream($this.MagicNumbers().STRING(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, string){
                private final String x2$1;

                public final void apply(ObjectOutputStream x$1) {
                    x$1.writeUTF(this.x2$1);
                }
                {
                    this.x2$1 = x2$1;
                }
            });
        } else if (object instanceof byte[]) {
            byte[] byArray2 = (byte[])object;
            byArray = $this.withObjectOutputStream($this.MagicNumbers().BYTE_ARRAY(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, byArray2){
                private final byte[] x3$1;

                public final void apply(ObjectOutputStream oos) {
                    oos.writeInt(this.x3$1.length);
                    oos.write(this.x3$1);
                }
                {
                    this.x3$1 = x3$1;
                }
            });
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            byArray = $this.withObjectOutputStream($this.MagicNumbers().INT(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, n){
                private final int x4$1;

                public final void apply(ObjectOutputStream x$2) {
                    x$2.writeInt(this.x4$1);
                }
                {
                    this.x4$1 = x4$1;
                }
            });
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            byArray = $this.withObjectOutputStream($this.MagicNumbers().DOUBLE(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, d){
                private final double x5$1;

                public final void apply(ObjectOutputStream x$3) {
                    x$3.writeDouble(this.x5$1);
                }
                {
                    this.x5$1 = x5$1;
                }
            });
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            byArray = $this.withObjectOutputStream($this.MagicNumbers().LONG(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, l){
                private final long x6$1;

                public final void apply(ObjectOutputStream x$4) {
                    x$4.writeLong(this.x6$1);
                }
                {
                    this.x6$1 = x6$1;
                }
            });
        } else {
            byArray = $this.withObjectOutputStream($this.MagicNumbers().OBJECT(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, object){
                private final Object x1$1;

                public final void apply(ObjectOutputStream x$5) {
                    x$5.writeObject(this.x1$1);
                }
                {
                    this.x1$1 = x1$1;
                }
            });
        }
        return byArray;
    }

    public static Object deserialize(RedisSerialization $this, byte[] bytes) {
        byte by;
        block8: {
            Object object;
            block3: {
                ObjectInputStream ois;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                                    byte typeId = (byte)bais.read();
                                    ois = new ObjectInputStream(bais);
                                    by = typeId;
                                    if ($this.MagicNumbers().STRING() != by) break block2;
                                    object = ois.readUTF();
                                    break block3;
                                }
                                if ($this.MagicNumbers().BYTE_ARRAY() != by) break block4;
                                int len = ois.readInt();
                                byte[] bs = new byte[len];
                                ois.read(bs);
                                object = bs;
                                break block3;
                            }
                            if ($this.MagicNumbers().INT() != by) break block5;
                            object = BoxesRunTime.boxToInteger((int)ois.readInt());
                            break block3;
                        }
                        if ($this.MagicNumbers().DOUBLE() != by) break block6;
                        object = BoxesRunTime.boxToDouble((double)ois.readDouble());
                        break block3;
                    }
                    if ($this.MagicNumbers().LONG() != by) break block7;
                    object = BoxesRunTime.boxToLong((long)ois.readLong());
                    break block3;
                }
                if ($this.MagicNumbers().OBJECT() != by) break block8;
                object = ois.readObject();
            }
            String result = object;
            return result;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public static void $init$(RedisSerialization $this) {
    }
}

