/*
 * Decompiled with CFR 0.152.
 */
package scalacache.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalacache.redis.ClassLoaderOIS;
import scalacache.redis.RedisSerialization;

public abstract class RedisSerialization$class {
    public static Option customClassloader(RedisSerialization $this) {
        return None$.MODULE$;
    }

    public static byte[] withObjectOutputStream(RedisSerialization $this, byte typeId, Function1 f) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(typeId);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        f.apply((Object)oos);
        oos.flush();
        return baos.toByteArray();
    }

    public static byte[] serialize(RedisSerialization $this, Object value) {
        byte[] byArray;
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            byArray = $this.withObjectOutputStream($this.MagicNumbers().STRING(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, string){
                public static final long serialVersionUID = 0L;
                private final String x2$1;

                public final void apply(ObjectOutputStream x$1) {
                    x$1.writeUTF(this.x2$1);
                }
                {
                    this.x2$1 = x2$1;
                }
            });
        } else if (object instanceof byte[]) {
            byte[] byArray2 = (byte[])object;
            byArray = $this.withObjectOutputStream($this.MagicNumbers().BYTE_ARRAY(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, byArray2){
                public static final long serialVersionUID = 0L;
                private final byte[] x3$1;

                public final void apply(ObjectOutputStream oos) {
                    oos.writeInt(this.x3$1.length);
                    oos.write(this.x3$1);
                }
                {
                    this.x3$1 = x3$1;
                }
            });
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            byArray = $this.withObjectOutputStream($this.MagicNumbers().INT(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, n){
                public static final long serialVersionUID = 0L;
                private final int x4$1;

                public final void apply(ObjectOutputStream x$2) {
                    x$2.writeInt(this.x4$1);
                }
                {
                    this.x4$1 = x4$1;
                }
            });
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            byArray = $this.withObjectOutputStream($this.MagicNumbers().DOUBLE(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, d){
                public static final long serialVersionUID = 0L;
                private final double x5$1;

                public final void apply(ObjectOutputStream x$3) {
                    x$3.writeDouble(this.x5$1);
                }
                {
                    this.x5$1 = x5$1;
                }
            });
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            byArray = $this.withObjectOutputStream($this.MagicNumbers().LONG(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, l){
                public static final long serialVersionUID = 0L;
                private final long x6$1;

                public final void apply(ObjectOutputStream x$4) {
                    x$4.writeLong(this.x6$1);
                }
                {
                    this.x6$1 = x6$1;
                }
            });
        } else {
            byArray = $this.withObjectOutputStream($this.MagicNumbers().OBJECT(), (Function1<ObjectOutputStream, BoxedUnit>)new Serializable($this, object){
                public static final long serialVersionUID = 0L;
                private final Object x1$1;

                public final void apply(ObjectOutputStream x$5) {
                    x$5.writeObject(this.x1$1);
                }
                {
                    this.x1$1 = x1$1;
                }
            });
        }
        return byArray;
    }

    public static Object deserialize(RedisSerialization $this, byte[] bytes) {
        byte by;
        block8: {
            Object object;
            block3: {
                ObjectInputStream ois;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                                    byte typeId = (byte)bais.read();
                                    ois = RedisSerialization$class.createObjectInputStream($this, bais);
                                    by = typeId;
                                    if ($this.MagicNumbers().STRING() != by) break block2;
                                    object = ois.readUTF();
                                    break block3;
                                }
                                if ($this.MagicNumbers().BYTE_ARRAY() != by) break block4;
                                int len = ois.readInt();
                                byte[] bs = new byte[len];
                                ois.read(bs);
                                object = bs;
                                break block3;
                            }
                            if ($this.MagicNumbers().INT() != by) break block5;
                            object = BoxesRunTime.boxToInteger((int)ois.readInt());
                            break block3;
                        }
                        if ($this.MagicNumbers().DOUBLE() != by) break block6;
                        object = BoxesRunTime.boxToDouble((double)ois.readDouble());
                        break block3;
                    }
                    if ($this.MagicNumbers().LONG() != by) break block7;
                    object = BoxesRunTime.boxToLong((long)ois.readLong());
                    break block3;
                }
                if ($this.MagicNumbers().OBJECT() != by) break block8;
                object = ois.readObject();
            }
            String result = object;
            return result;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    private static ObjectInputStream createObjectInputStream(RedisSerialization $this, InputStream inputStream) {
        return new ClassLoaderOIS(inputStream, (ClassLoader)$this.customClassloader().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisSerialization $outer;

            public final ClassLoader apply() {
                return this.$outer.getClass().getClassLoader();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public static void $init$(RedisSerialization $this) {
    }
}

