/*
 * Decompiled with CFR 0.152.
 */
package cn.cedar.cedar.data.spring.boot;

import cn.cedar.cedar.data.spring.boot.CedarDataProperties;
import cn.cedar.cedar.data.spring.boot.CedarDataSpringBootRegister;
import cn.cedar.cedar.data.spring.boot.JdbcTemplatelManager;
import cn.cedar.data.InstanceFactory;
import cn.cedar.data.JdbcManager;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcTemplate;

@ComponentScan(value={"cn.cedar.cedar.data.spring.boot"})
@EnableConfigurationProperties(value={CedarDataProperties.class})
@Configuration
@ConditionalOnClass(value={JdbcTemplate.class})
public class CedarDataAutoConfiguration {
    @DependsOn(value={"cedarDataProperties"})
    @Bean
    public CedarDataSpringBootRegister cedarDataSpringBootRegister(CedarDataProperties cedarDataProperties) {
        return new CedarDataSpringBootRegister(cedarDataProperties);
    }

    @Primary
    @DependsOn(value={"dataSource"})
    @Bean
    public JdbcTemplate jdbcTemplate(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        InstanceFactory.setJdbcManager((JdbcManager)new JdbcTemplatelManager(jdbcTemplate));
        return jdbcTemplate;
    }
}

