/*
 * Decompiled with CFR 0.152.
 */
package cn.cedar.cedar.data.spring.boot;

import cn.cedar.cedar.data.spring.boot.factory.CedarDataSpringProxyFactory;
import cn.cedar.data.annotation.CedarData;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

class CedarDataBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private static Log log = LogFactory.getLog(CedarDataBeanDefinitionScanner.class);
    private static final String INTERFACE_CLASS = "interfaceClass";
    private String[] basePackage;

    public CedarDataBeanDefinitionScanner(BeanDefinitionRegistry registry, String[] basePackage) {
        super(registry, false);
        this.basePackage = basePackage;
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        this.addFilter();
        Set beanDefinitionHolders = super.doScan(basePackages);
        if (beanDefinitionHolders.isEmpty()) {
            log.error((Object)"@CedarData interface is empty");
            return beanDefinitionHolders;
        }
        this.createBeanDefinition(beanDefinitionHolders);
        return beanDefinitionHolders;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        return metadata.isInterface() && metadata.isIndependent();
    }

    private void addFilter() {
        this.addIncludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                try {
                    Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(className);
                    CedarData cedarData = cls.getAnnotation(CedarData.class);
                    if (cedarData != null) {
                        return true;
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e.getMessage());
                }
                return false;
            }
        });
    }

    private void createBeanDefinition(Set<BeanDefinitionHolder> beanDefinitionHolders) {
        for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
            GenericBeanDefinition definition = (GenericBeanDefinition)beanDefinitionHolder.getBeanDefinition();
            log.info((Object)definition.getBeanClassName());
            definition.getPropertyValues().add(INTERFACE_CLASS, (Object)definition.getBeanClassName());
            definition.setBeanClass(CedarDataSpringProxyFactory.class);
            definition.setAutowireMode(2);
        }
    }
}

