/*
 * Decompiled with CFR 0.152.
 */
package cn.cedar.cedar.data.spring.boot;

import cn.cedar.cedar.data.spring.boot.CedarDataBeanDefinitionScanner;
import cn.cedar.cedar.data.spring.boot.CedarDataProperties;
import cn.cedar.cedar.data.spring.boot.JdbcTemplatelManager;
import cn.cedar.data.InstanceFactory;
import cn.cedar.data.JdbcManager;
import java.sql.Connection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class CedarDataSpringBootRegister
implements BeanDefinitionRegistryPostProcessor {
    private String[] basePackage;
    private CedarDataProperties properties;
    private ApplicationContext ctx;
    private JdbcTemplate cedarDataJdbcTemplate;
    private BeanDefinitionRegistry registry;
    private static final String EVN = "cedar-data-spring-boot-starter";

    @Autowired
    public void setProperties(CedarDataProperties properties) {
        this.properties = properties;
        this.basePackage = properties.getScanPackage().split(",");
    }

    @Autowired
    public void setCedarDataJdbcTemplate(JdbcTemplate cedarDataJdbcTemplate) {
        this.cedarDataJdbcTemplate = cedarDataJdbcTemplate;
        InstanceFactory.setJdbcManager((JdbcManager)new JdbcTemplatelManager(cedarDataJdbcTemplate));
    }

    public CedarDataSpringBootRegister() {
    }

    public CedarDataSpringBootRegister(CedarDataProperties properties) {
        InstanceFactory.setEnv((String)EVN);
        this.properties = properties;
        this.basePackage = properties.getEnvironment().getProperty("cedar.data.scan-package").split(",");
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String displaySql;
        this.registry = registry;
        if (this.basePackage == null || this.basePackage.length == 0) {
            return;
        }
        String maxLayer = this.properties.getEnvironment().getProperty("cedar.data.max-layer");
        if (maxLayer != null) {
            InstanceFactory.setMaxLayer((int)Integer.parseInt(maxLayer));
        }
        if ((displaySql = this.properties.getEnvironment().getProperty("cedar.data.display-sql")) != null) {
            JdbcTemplatelManager.displaySql = Boolean.parseBoolean(displaySql);
        }
        CedarDataBeanDefinitionScanner scanner = new CedarDataBeanDefinitionScanner(registry, this.basePackage);
        scanner.doScan(this.basePackage);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public static class PreloadJdbcManger
    extends JdbcManager {
        public Connection getConnection() {
            return null;
        }
    }
}

