/*
 * Decompiled with CFR 0.152.
 */
package cn.cedar.cedar.data.spring.boot;

import cn.cedar.data.JdbcManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcTemplatelManager
extends JdbcManager {
    private static final Log log = LogFactory.getLog(JdbcTemplatelManager.class);
    protected static boolean displaySql = false;
    private JdbcTemplate jdbcTemplate;

    public JdbcTemplatelManager(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate.getDataSource());
        this.jdbcTemplate = jdbcTemplate;
    }

    private static void displaySql(String sql) {
        if (displaySql) {
            log.info((Object)sql);
        }
    }

    public List<Map<String, Object>> excuteQuery(String sql, Object ... params) {
        JdbcTemplatelManager.displaySql(sql);
        return this.jdbcTemplate.queryForList(sql);
    }

    public int excute(String sql, Object ... params) {
        JdbcTemplatelManager.displaySql(sql);
        return this.jdbcTemplate.update(sql);
    }

    public int excuteGetGeneratedKey(final String sql, Object ... params) {
        JdbcTemplatelManager.displaySql(sql);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int rc = this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        if (rc > 0) {
            return keyHolder.getKey().intValue();
        }
        return 0;
    }

    public Map<String, Object> excuteQueryOne(String sql, Object ... params) {
        JdbcTemplatelManager.displaySql(sql);
        return this.jdbcTemplate.queryForMap(sql);
    }

    public long excuteQueryCount(String sql, Object ... params) {
        JdbcTemplatelManager.displaySql(sql);
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
    }
}

