/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.amber.spring;

import com.github.charlemaznable.amber.AmberLogin;
import com.github.charlemaznable.amber.CookieValue;
import com.github.charlemaznable.amber.config.AmberConfig;
import com.github.charlemaznable.core.codec.Base64;
import com.github.charlemaznable.core.codec.Json;
import com.github.charlemaznable.core.crypto.AES;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.miner.MinerFactory;
import com.github.charlemaznable.core.net.Url;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AmberInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AmberInterceptor.class);
    @Autowired(required=false)
    private AmberConfig amberConfig;
    private Cache<HandlerAmberLoginCacheKey, Optional<AmberLogin>> handlerAmberLoginCache = CacheBuilder.newBuilder().build();

    @PostConstruct
    public void postConstruct() {
        if (null == this.amberConfig) {
            this.amberConfig = (AmberConfig)MinerFactory.getMiner(AmberConfig.class);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Cookie[] cookies;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (null == this.amberConfig) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        HandlerAmberLoginCacheKey cacheKey = new HandlerAmberLoginCacheKey(handlerMethod);
        Optional amberLogin = (Optional)this.handlerAmberLoginCache.get((Object)cacheKey, () -> this.findAmberLogin(cacheKey));
        if (amberLogin.isPresent() && !((AmberLogin)amberLogin.get()).required()) {
            return true;
        }
        if (!amberLogin.isPresent() && !this.amberConfig.forceLogin()) {
            return true;
        }
        String appId = this.amberConfig.appId();
        String cookieName = this.amberConfig.cookieName();
        String encryptKey = this.amberConfig.encryptKey();
        String amberLoginUrl = this.amberConfig.amberLoginUrl();
        String localUrl = this.amberConfig.localUrl();
        if (Str.isBlank((String)appId) || Str.isBlank((String)cookieName) || Str.isBlank((String)encryptKey) || Str.isBlank((String)amberLoginUrl) || Str.isBlank((String)localUrl)) {
            return false;
        }
        for (Cookie cookie : cookies = (Cookie[])Condition.nullThen((Object)request.getCookies(), () -> new Cookie[0])) {
            if (!cookie.getName().equals(cookieName)) continue;
            String decrypted = AES.decrypt((byte[])Base64.unBase64((String)cookie.getValue()), (String)encryptKey);
            CookieValue cookieValue = (CookieValue)Json.unJson((String)decrypted, CookieValue.class);
            if (cookieValue.getExpiredTime().isBeforeNow() || Str.isEmpty((String)cookieValue.getUsername())) break;
            return true;
        }
        String location = amberLoginUrl + "?appId=" + appId;
        location = location + "&redirectUrl=" + Url.encode((String)(localUrl + request.getRequestURI()));
        response.sendRedirect(location);
        return false;
    }

    private Optional<AmberLogin> findAmberLogin(HandlerAmberLoginCacheKey cacheKey) {
        AmberLogin methodAmberLogin = (AmberLogin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)cacheKey.getMethod(), AmberLogin.class);
        if (null != methodAmberLogin) {
            return Optional.of(methodAmberLogin);
        }
        AmberLogin classAmberLogin = (AmberLogin)AnnotatedElementUtils.findMergedAnnotation(cacheKey.getDeclaringClass(), AmberLogin.class);
        if (null != classAmberLogin) {
            return Optional.of(classAmberLogin);
        }
        return Optional.empty();
    }

    static class HandlerAmberLoginCacheKey {
        private Method method;
        private Class<?> declaringClass;

        HandlerAmberLoginCacheKey(HandlerMethod handlerMethod) {
            this.method = handlerMethod.getMethod();
            this.declaringClass = this.method.getDeclaringClass();
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandlerAmberLoginCacheKey)) {
                return false;
            }
            HandlerAmberLoginCacheKey other = (HandlerAmberLoginCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            Class<?> this$declaringClass = this.getDeclaringClass();
            Class<?> other$declaringClass = other.getDeclaringClass();
            return !(this$declaringClass == null ? other$declaringClass != null : !this$declaringClass.equals(other$declaringClass));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HandlerAmberLoginCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            Class<?> $declaringClass = this.getDeclaringClass();
            result = result * 59 + ($declaringClass == null ? 43 : $declaringClass.hashCode());
            return result;
        }
    }
}

