/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.annotation;

import com.github.charlemaznable.core.codec.Json;
import com.github.charlemaznable.core.codec.Xml;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.net.Url;
import com.google.common.net.MediaType;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@Documented
@Inherited
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ContentFormat {
    public Class<? extends ContentFormatter> value();

    public static enum ContentType {
        FORM(MediaType.FORM_DATA.toString(), new FormContentFormatter()),
        JSON(MediaType.JSON_UTF_8.toString(), new JsonContentFormatter()),
        APPLICATION_XML(MediaType.APPLICATION_XML_UTF_8.toString(), new ApplicationXmlContentFormatter()),
        TEXT_XML(MediaType.XML_UTF_8.toString(), new TextXmlContentFormatter());

        private final String contentTypeName;
        private final ContentFormatter contentFormatter;

        @Nullable
        public static ContentType resolve(String contentTypeName) {
            for (ContentType contentType : ContentType.values()) {
                if (!contentType.contentTypeName.equalsIgnoreCase(contentTypeName) && !contentType.name().equalsIgnoreCase(contentTypeName)) continue;
                return contentType;
            }
            return null;
        }

        @Generated
        private ContentType(String contentTypeName, ContentFormatter contentFormatter) {
            this.contentTypeName = contentTypeName;
            this.contentFormatter = contentFormatter;
        }

        @Generated
        public ContentFormatter getContentFormatter() {
            return this.contentFormatter;
        }
    }

    public static class TextXmlContentFormatter
    extends XmlContentFormatter {
        @Override
        public String contentType() {
            return MediaType.XML_UTF_8.toString();
        }
    }

    public static class ApplicationXmlContentFormatter
    extends XmlContentFormatter {
        @Override
        public String contentType() {
            return MediaType.APPLICATION_XML_UTF_8.toString();
        }
    }

    public static abstract class XmlContentFormatter
    implements ContentFormatter {
        public static final String XML_ROOT_NAME = "XML_ROOT_NAME";

        @Override
        public String format(@Nonnull Map<String, Object> parameterMap, @Nonnull Map<String, Object> contextMap) {
            return Xml.xml((Map)Mapp.newHashMap(parameterMap), (String)Mapp.getStr(contextMap, (Object)XML_ROOT_NAME, (String)"xml"));
        }
    }

    public static class JsonContentFormatter
    implements ContentFormatter {
        @Override
        public String contentType() {
            return MediaType.JSON_UTF_8.toString();
        }

        @Override
        public String format(@Nonnull Map<String, Object> parameterMap, @Nonnull Map<String, Object> contextMap) {
            return Json.json((Object)Mapp.newHashMap(parameterMap));
        }
    }

    public static class FormContentFormatter
    implements ContentFormatter {
        @Override
        public String contentType() {
            return MediaType.FORM_DATA.toString();
        }

        @Override
        public String format(@Nonnull Map<String, Object> parameterMap, @Nonnull Map<String, Object> contextMap) {
            return Mapp.newHashMap(parameterMap).entrySet().stream().filter(e -> Str.isNotBlank((String)((String)e.getKey())) && Objects.nonNull(e.getValue())).map(e -> (String)e.getKey() + "=" + Url.encode((String)Str.toStr(e.getValue()))).collect(Collectors.joining("&"));
        }
    }

    public static interface ContentFormatter {
        public String contentType();

        public String format(@Nonnull Map<String, Object> var1, @Nonnull Map<String, Object> var2);
    }
}

