/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.annotation;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Rand;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lombok.Generated;

@Documented
@Inherited
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MappingBalance {
    public Class<? extends MappingBalancer> value();

    public static enum BalanceType {
        RANDOM(new RandomBalancer()),
        ROUND_ROBIN(new RoundRobinBalancer());

        private final MappingBalancer mappingBalancer;

        @Nullable
        public static BalanceType resolve(String balanceTypeName) {
            for (BalanceType balanceType : BalanceType.values()) {
                if (!balanceType.name().equalsIgnoreCase(balanceTypeName)) continue;
                return balanceType;
            }
            return null;
        }

        @Generated
        private BalanceType(MappingBalancer mappingBalancer) {
            this.mappingBalancer = mappingBalancer;
        }

        @Generated
        public MappingBalancer getMappingBalancer() {
            return this.mappingBalancer;
        }
    }

    public static class RoundRobinBalancer
    implements MappingBalancer {
        private final AtomicInteger cyclicCounter = new AtomicInteger(0);

        @Override
        public String choose(List<String> urls) {
            Condition.checkNotEmpty(urls);
            if (1 == urls.size()) {
                return urls.get(0);
            }
            return urls.get(this.getAndIncrementMod(urls.size()));
        }

        private int getAndIncrementMod(int size) {
            int next;
            int curr;
            while (!this.cyclicCounter.compareAndSet(curr = this.cyclicCounter.get(), next = (curr + 1) % size)) {
            }
            return next;
        }
    }

    public static class RandomBalancer
    implements MappingBalancer {
        @Override
        public String choose(List<String> urls) {
            Condition.checkNotEmpty(urls);
            if (1 == urls.size()) {
                return urls.get(0);
            }
            return urls.get(Rand.randInt((int)urls.size()));
        }
    }

    public static interface MappingBalancer {
        public String choose(List<String> var1);
    }
}

