/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.common;

import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.httpclient.annotation.ContentFormat;
import com.github.charlemaznable.httpclient.annotation.ExtraUrlQuery;
import com.github.charlemaznable.httpclient.annotation.MappingBalance;
import com.github.charlemaznable.httpclient.annotation.RequestExtend;
import com.github.charlemaznable.httpclient.annotation.ResponseParse;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpMethod;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.github.charlemaznable.httpclient.common.StatusErrorFallback;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceBase;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommonBase<T extends CommonBase<T>> {
    Charset acceptCharset = CommonConstant.DEFAULT_ACCEPT_CHARSET;
    ContentFormat.ContentFormatter contentFormatter = CommonConstant.DEFAULT_CONTENT_FORMATTER;
    HttpMethod httpMethod = CommonConstant.DEFAULT_HTTP_METHOD;
    List<Pair<String, String>> headers = Listt.newArrayList();
    List<Pair<String, String>> pathVars = Listt.newArrayList();
    List<Pair<String, Object>> parameters = Listt.newArrayList();
    List<Pair<String, Object>> contexts = Listt.newArrayList();
    EnumMap<HttpStatus, FallbackFunction<?>> statusFallbackMapping = Mapp.newEnumMap(HttpStatus.class);
    EnumMap<HttpStatus.Series, FallbackFunction<?>> statusSeriesFallbackMapping = Mapp.newEnumMap(HttpStatus.Series.class, (Map)Mapp.of((Object)((Object)HttpStatus.Series.CLIENT_ERROR), (Object)new StatusErrorFallback(), (Object)((Object)HttpStatus.Series.SERVER_ERROR), (Object)new StatusErrorFallback()));
    RequestExtend.RequestExtender requestExtender;
    ResponseParse.ResponseParser responseParser;
    ExtraUrlQuery.ExtraUrlQueryBuilder extraUrlQueryBuilder;
    MappingBalance.MappingBalancer mappingBalancer = new MappingBalance.RandomBalancer();
    ResilienceBase resilienceBase = new ResilienceBase();

    public CommonBase(CommonBase<?> other) {
        this.acceptCharset = other.acceptCharset;
        this.contentFormatter = other.contentFormatter;
        this.httpMethod = other.httpMethod;
        this.headers = Listt.newArrayList(other.headers);
        this.pathVars = Listt.newArrayList(other.pathVars);
        this.parameters = Listt.newArrayList(other.parameters);
        this.contexts = Listt.newArrayList(other.contexts);
        this.statusFallbackMapping = Mapp.newEnumMap(HttpStatus.class, other.statusFallbackMapping);
        this.statusSeriesFallbackMapping = Mapp.newEnumMap(HttpStatus.Series.class, other.statusSeriesFallbackMapping);
        this.requestExtender = other.requestExtender;
        this.responseParser = other.responseParser;
        this.extraUrlQueryBuilder = other.extraUrlQueryBuilder;
        this.mappingBalancer = other.mappingBalancer;
        this.resilienceBase = new ResilienceBase(other.resilienceBase);
    }

    @Generated
    public CommonBase() {
    }

    @Generated
    public Charset acceptCharset() {
        return this.acceptCharset;
    }

    @Generated
    public ContentFormat.ContentFormatter contentFormatter() {
        return this.contentFormatter;
    }

    @Generated
    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    @Generated
    public List<Pair<String, String>> headers() {
        return this.headers;
    }

    @Generated
    public List<Pair<String, String>> pathVars() {
        return this.pathVars;
    }

    @Generated
    public List<Pair<String, Object>> parameters() {
        return this.parameters;
    }

    @Generated
    public List<Pair<String, Object>> contexts() {
        return this.contexts;
    }

    @Generated
    public EnumMap<HttpStatus, FallbackFunction<?>> statusFallbackMapping() {
        return this.statusFallbackMapping;
    }

    @Generated
    public EnumMap<HttpStatus.Series, FallbackFunction<?>> statusSeriesFallbackMapping() {
        return this.statusSeriesFallbackMapping;
    }

    @Generated
    public RequestExtend.RequestExtender requestExtender() {
        return this.requestExtender;
    }

    @Generated
    public ResponseParse.ResponseParser responseParser() {
        return this.responseParser;
    }

    @Generated
    public ExtraUrlQuery.ExtraUrlQueryBuilder extraUrlQueryBuilder() {
        return this.extraUrlQueryBuilder;
    }

    @Generated
    public MappingBalance.MappingBalancer mappingBalancer() {
        return this.mappingBalancer;
    }

    @Generated
    public ResilienceBase resilienceBase() {
        return this.resilienceBase;
    }
}

