/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.common;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.core.lang.Reloadable;
import com.github.charlemaznable.httpclient.annotation.MappingMethodNameDisabled;
import com.github.charlemaznable.httpclient.common.CommonBase;
import com.github.charlemaznable.httpclient.common.CommonElement;
import com.github.charlemaznable.httpclient.common.CommonMethod;
import com.github.charlemaznable.httpclient.configurer.Configurer;
import com.github.charlemaznable.httpclient.configurer.MappingMethodNameDisabledConfigurer;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceMeterBinder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public abstract class CommonClass<T extends CommonBase<T>>
implements Reloadable,
ResilienceMeterBinder {
    final CommonElement<T> element;
    final T defaultBase;
    final Class<?> clazz;
    final Logger logger;
    List<String> baseUrls;
    boolean mappingMethodNameDisabled;
    final LoadingCache<Method, CommonMethod<T>> commonMethodCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(this::loadMethod));

    public CommonClass(CommonElement<T> element, T defaultBase, Class<?> clazz) {
        this.element = element;
        this.defaultBase = defaultBase;
        this.clazz = clazz;
        this.logger = LoggerFactory.getLogger(clazz);
        this.element.initializeConfigListener(this::reload);
    }

    protected void initialize() {
        this.element.initializeConfigurer(this.clazz);
        this.element.setUpBeforeInitialization(this.clazz, null, null);
        this.baseUrls = (List)Condition.emptyThen(this.element.buildMappingUrls(this.clazz), () -> Listt.newArrayList((Object[])new String[]{""}));
        this.mappingMethodNameDisabled = this.checkMappingMethodNameDisabled();
        this.element.initialize(this.clazz, this.defaultBase);
        this.element.tearDownAfterInitialization(this.clazz, null, null);
    }

    private boolean checkMappingMethodNameDisabled() {
        Configurer configurer = this.element.configurer;
        if (configurer instanceof MappingMethodNameDisabledConfigurer) {
            MappingMethodNameDisabledConfigurer disabledConfigurer = (MappingMethodNameDisabledConfigurer)configurer;
            return disabledConfigurer.disabledMappingMethodName();
        }
        return AnnotatedElementUtils.isAnnotated(this.clazz, MappingMethodNameDisabled.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.element.configLock;
        synchronized (object) {
            this.initialize();
            this.commonMethodCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(MeterRegistry registry) {
        Object object = this.element.configLock;
        synchronized (object) {
            this.element.bindTo(registry);
            this.commonMethodCache.asMap().values().forEach(method -> method.element.bindTo(registry));
        }
    }

    protected abstract CommonMethod<T> loadMethod(Method var1);

    protected Object execute(Method method, Object[] args) throws Exception {
        if (method.getDeclaringClass().equals(Reloadable.class) || method.getDeclaringClass().equals(ResilienceMeterBinder.class)) {
            return method.invoke((Object)this, args);
        }
        return ((CommonMethod)LoadingCachee.get(this.commonMethodCache, (Object)method)).execute(args);
    }

    @Generated
    public CommonElement<T> element() {
        return this.element;
    }

    @Generated
    public Class<?> clazz() {
        return this.clazz;
    }

    @Generated
    public Logger logger() {
        return this.logger;
    }
}

