/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.common;

import com.github.charlemaznable.configservice.ConfigFactory;
import com.github.charlemaznable.configservice.ConfigListener;
import com.github.charlemaznable.configservice.ConfigListenerRegister;
import com.github.charlemaznable.core.context.FactoryContext;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Factory;
import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.httpclient.annotation.AcceptCharset;
import com.github.charlemaznable.httpclient.annotation.ConfigureWith;
import com.github.charlemaznable.httpclient.annotation.ContentFormat;
import com.github.charlemaznable.httpclient.annotation.DefaultFallbackDisabled;
import com.github.charlemaznable.httpclient.annotation.ExtraUrlQuery;
import com.github.charlemaznable.httpclient.annotation.FixedContext;
import com.github.charlemaznable.httpclient.annotation.FixedHeader;
import com.github.charlemaznable.httpclient.annotation.FixedParameter;
import com.github.charlemaznable.httpclient.annotation.FixedPathVar;
import com.github.charlemaznable.httpclient.annotation.Mapping;
import com.github.charlemaznable.httpclient.annotation.MappingBalance;
import com.github.charlemaznable.httpclient.annotation.RequestExtend;
import com.github.charlemaznable.httpclient.annotation.RequestMethod;
import com.github.charlemaznable.httpclient.annotation.ResponseParse;
import com.github.charlemaznable.httpclient.annotation.StatusFallback;
import com.github.charlemaznable.httpclient.annotation.StatusSeriesFallback;
import com.github.charlemaznable.httpclient.common.CommonBase;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpMethod;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.github.charlemaznable.httpclient.configurer.AcceptCharsetConfigurer;
import com.github.charlemaznable.httpclient.configurer.Configurer;
import com.github.charlemaznable.httpclient.configurer.ContentFormatConfigurer;
import com.github.charlemaznable.httpclient.configurer.DefaultFallbackDisabledConfigurer;
import com.github.charlemaznable.httpclient.configurer.ExtraUrlQueryConfigurer;
import com.github.charlemaznable.httpclient.configurer.ExtraUrlQueryDisabledConfigurer;
import com.github.charlemaznable.httpclient.configurer.FixedContextsConfigurer;
import com.github.charlemaznable.httpclient.configurer.FixedHeadersConfigurer;
import com.github.charlemaznable.httpclient.configurer.FixedParametersConfigurer;
import com.github.charlemaznable.httpclient.configurer.FixedPathVarsConfigurer;
import com.github.charlemaznable.httpclient.configurer.InitializationConfigurer;
import com.github.charlemaznable.httpclient.configurer.MappingBalanceConfigurer;
import com.github.charlemaznable.httpclient.configurer.MappingConfigurer;
import com.github.charlemaznable.httpclient.configurer.RequestExtendConfigurer;
import com.github.charlemaznable.httpclient.configurer.RequestExtendDisabledConfigurer;
import com.github.charlemaznable.httpclient.configurer.RequestMethodConfigurer;
import com.github.charlemaznable.httpclient.configurer.ResponseParseConfigurer;
import com.github.charlemaznable.httpclient.configurer.ResponseParseDisabledConfigurer;
import com.github.charlemaznable.httpclient.configurer.StatusFallbacksConfigurer;
import com.github.charlemaznable.httpclient.configurer.StatusSeriesFallbacksConfigurer;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceElement;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.core.annotation.AnnotatedElementUtils;

public abstract class CommonElement<T extends CommonBase<T>> {
    final T base;
    final Factory factory;
    ConfigListener configListener;
    Configurer configurer;
    ResilienceElement resilienceElement;
    final Object configLock = new Object();

    public void initializeConfigListener(Runnable reloader) {
        this.configListener = (keyset, key, value) -> Condition.notNullThenRun((Object)reloader, Runnable::run);
    }

    public void initializeConfigurer(AnnotatedElement element) {
        this.checkConfigurerIsRegisterThenRun(ConfigListenerRegister::removeConfigListener);
        this.configurer = this.buildConfigurer(element);
        this.checkConfigurerIsRegisterThenRun(ConfigListenerRegister::addConfigListener);
        this.resilienceElement = new ResilienceElement(((CommonBase)this.base).resilienceBase, this.factory, this.configurer);
    }

    public void setUpBeforeInitialization(Class<?> clazz, Method method, CommonElement<T> superElement) {
        Configurer configurer = this.configurer;
        if (configurer instanceof InitializationConfigurer) {
            InitializationConfigurer initializationConfigurer = (InitializationConfigurer)configurer;
            initializationConfigurer.setUpBeforeInitialization(clazz, method);
        } else if (Objects.nonNull(superElement)) {
            superElement.setUpBeforeInitialization(clazz, method, null);
        } else {
            InitializationConfigurer.INSTANCE.setUpBeforeInitialization(clazz, method);
        }
    }

    public void initialize(AnnotatedElement element, T superBase) {
        ((CommonBase)this.base).acceptCharset = (Charset)Condition.nullThen((Object)this.buildAcceptCharset(element), () -> superBase.acceptCharset);
        ((CommonBase)this.base).contentFormatter = (ContentFormat.ContentFormatter)Condition.nullThen((Object)this.buildContentFormatter(element), () -> superBase.contentFormatter);
        ((CommonBase)this.base).httpMethod = (HttpMethod)((Object)Condition.nullThen((Object)((Object)this.buildHttpMethod(element)), () -> superBase.httpMethod));
        ((CommonBase)this.base).headers = Listt.newArrayList(((CommonBase)superBase).headers);
        ((CommonBase)this.base).headers.addAll(this.buildFixedHeaders(element));
        ((CommonBase)this.base).pathVars = Listt.newArrayList(((CommonBase)superBase).pathVars);
        ((CommonBase)this.base).pathVars.addAll(this.buildFixedPathVars(element));
        ((CommonBase)this.base).parameters = Listt.newArrayList(((CommonBase)superBase).parameters);
        ((CommonBase)this.base).parameters.addAll(this.buildFixedParameters(element));
        ((CommonBase)this.base).contexts = Listt.newArrayList(((CommonBase)superBase).contexts);
        ((CommonBase)this.base).contexts.addAll(this.buildFixedContexts(element));
        ((CommonBase)this.base).statusFallbackMapping = this.defaultFallback(((CommonBase)superBase).statusFallbackMapping);
        ((CommonBase)this.base).statusFallbackMapping.putAll(this.buildStatusFallbackMapping(element));
        ((CommonBase)this.base).statusSeriesFallbackMapping = this.defaultFallback(element, ((CommonBase)superBase).statusSeriesFallbackMapping);
        ((CommonBase)this.base).statusSeriesFallbackMapping.putAll(this.buildStatusSeriesFallbackMapping(element));
        ((CommonBase)this.base).requestExtender = this.buildRequestExtender(element, ((CommonBase)superBase).requestExtender);
        ((CommonBase)this.base).responseParser = this.buildResponseParser(element, ((CommonBase)superBase).responseParser);
        ((CommonBase)this.base).extraUrlQueryBuilder = this.buildExtraUrlQueryBuilder(element, ((CommonBase)superBase).extraUrlQueryBuilder);
        ((CommonBase)this.base).mappingBalancer = this.buildMappingBalancer(element, ((CommonBase)superBase).mappingBalancer);
        this.resilienceElement.initialize(element, ((CommonBase)superBase).resilienceBase);
    }

    public void tearDownAfterInitialization(Class<?> clazz, Method method, CommonElement<T> superElement) {
        Configurer configurer = this.configurer;
        if (configurer instanceof InitializationConfigurer) {
            InitializationConfigurer initializationConfigurer = (InitializationConfigurer)configurer;
            initializationConfigurer.tearDownAfterInitialization(clazz, method);
        } else if (Objects.nonNull(superElement)) {
            superElement.tearDownAfterInitialization(clazz, method, null);
        } else {
            InitializationConfigurer.INSTANCE.tearDownAfterInitialization(clazz, method);
        }
    }

    public void bindTo(MeterRegistry registry) {
        this.resilienceElement.bindTo(registry);
    }

    public List<String> buildMappingUrls(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof MappingConfigurer) {
            MappingConfigurer mappingConfigurer = (MappingConfigurer)configurer;
            return Listt.newArrayList(mappingConfigurer.urls()).parallelStream().map(CommonConstant::substitute).toList();
        }
        Mapping mapping = (Mapping)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, Mapping.class);
        return (List)Condition.notNullThen((Object)mapping, anno -> ((Stream)Arrays.stream(anno.value()).parallel()).map(CommonConstant::substitute).toList());
    }

    private Configurer buildConfigurer(AnnotatedElement element) {
        ConfigureWith configureWith = (ConfigureWith)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ConfigureWith.class);
        if (Objects.isNull(configureWith)) {
            return null;
        }
        Class<? extends Configurer> configurerClass = configureWith.value();
        Configurer buildConfigurer = (Configurer)FactoryContext.build((Factory)this.factory, configurerClass);
        if (Objects.nonNull(buildConfigurer)) {
            return buildConfigurer;
        }
        try {
            return (Configurer)ConfigFactory.configLoader((Factory)this.factory).getConfig(configurerClass);
        }
        catch (Exception e) {
            CommonConstant.log.warn("Load Configurer by ConfigService with exception: ", (Throwable)e);
            return null;
        }
    }

    private void checkConfigurerIsRegisterThenRun(BiConsumer<ConfigListenerRegister, ConfigListener> runnable) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ConfigListenerRegister) {
            ConfigListenerRegister register = (ConfigListenerRegister)configurer;
            Condition.notNullThenRun(runnable, r -> r.accept(register, this.configListener));
        }
    }

    private Charset buildAcceptCharset(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof AcceptCharsetConfigurer) {
            AcceptCharsetConfigurer acceptCharsetConfigurer = (AcceptCharsetConfigurer)configurer;
            return acceptCharsetConfigurer.acceptCharset();
        }
        AcceptCharset acceptCharset = (AcceptCharset)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, AcceptCharset.class);
        return (Charset)Condition.notNullThen((Object)acceptCharset, anno -> Charset.forName(anno.value()));
    }

    private ContentFormat.ContentFormatter buildContentFormatter(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ContentFormatConfigurer) {
            ContentFormatConfigurer contentFormatConfigurer = (ContentFormatConfigurer)configurer;
            return contentFormatConfigurer.contentFormatter();
        }
        ContentFormat contentFormat = (ContentFormat)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ContentFormat.class);
        return (ContentFormat.ContentFormatter)Condition.notNullThen((Object)contentFormat, anno -> (ContentFormat.ContentFormatter)FactoryContext.build((Factory)this.factory, anno.value()));
    }

    private HttpMethod buildHttpMethod(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof RequestMethodConfigurer) {
            RequestMethodConfigurer requestMethodConfigurer = (RequestMethodConfigurer)configurer;
            return requestMethodConfigurer.requestMethod();
        }
        RequestMethod requestMethod = (RequestMethod)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, RequestMethod.class);
        return (HttpMethod)((Object)Condition.notNullThen((Object)requestMethod, RequestMethod::value));
    }

    private List<Pair<String, String>> buildFixedHeaders(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof FixedHeadersConfigurer) {
            FixedHeadersConfigurer fixedHeadersConfigurer = (FixedHeadersConfigurer)configurer;
            return Listt.newArrayList(fixedHeadersConfigurer.fixedHeaders()).stream().filter(CommonConstant.NOT_BLANK_KEY).toList();
        }
        return Listt.newArrayList((Iterable)AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, FixedHeader.class)).stream().map(a -> Pair.of((Object)a.name(), (Object)CommonElement.cleanupValue(a.value(), a.emptyAsCleanup()))).filter(CommonConstant.NOT_BLANK_KEY).toList();
    }

    private List<Pair<String, String>> buildFixedPathVars(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof FixedPathVarsConfigurer) {
            FixedPathVarsConfigurer fixedPathVarsConfigurer = (FixedPathVarsConfigurer)configurer;
            return Listt.newArrayList(fixedPathVarsConfigurer.fixedPathVars()).stream().filter(CommonConstant.NOT_BLANK_KEY).toList();
        }
        return Listt.newArrayList((Iterable)AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, FixedPathVar.class)).stream().map(a -> Pair.of((Object)a.name(), (Object)CommonElement.cleanupValue(a.value(), a.emptyAsCleanup()))).filter(CommonConstant.NOT_BLANK_KEY).toList();
    }

    private List<Pair<String, Object>> buildFixedParameters(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof FixedParametersConfigurer) {
            FixedParametersConfigurer fixedParametersConfigurer = (FixedParametersConfigurer)configurer;
            return Listt.newArrayList(fixedParametersConfigurer.fixedParameters()).stream().filter(CommonConstant.NOT_BLANK_KEY).toList();
        }
        return Listt.newArrayList((Iterable)AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, FixedParameter.class)).stream().map(a -> Pair.of((Object)a.name(), (Object)CommonElement.cleanupValue(a.value(), a.emptyAsCleanup()))).filter(CommonConstant.NOT_BLANK_KEY).toList();
    }

    private List<Pair<String, Object>> buildFixedContexts(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof FixedContextsConfigurer) {
            FixedContextsConfigurer fixedContextsConfigurer = (FixedContextsConfigurer)configurer;
            return Listt.newArrayList(fixedContextsConfigurer.fixedContexts()).stream().filter(CommonConstant.NOT_BLANK_KEY).toList();
        }
        return Listt.newArrayList((Iterable)AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, FixedContext.class)).stream().map(a -> Pair.of((Object)a.name(), (Object)CommonElement.cleanupValue(a.value(), a.emptyAsCleanup()))).filter(CommonConstant.NOT_BLANK_KEY).toList();
    }

    private static String cleanupValue(String value, boolean emptyAsCleanup) {
        return (String)Condition.emptyThen((Object)value, () -> emptyAsCleanup ? null : "");
    }

    private EnumMap<HttpStatus, FallbackFunction<?>> defaultFallback(Map<HttpStatus, FallbackFunction<?>> defaultValue) {
        return Mapp.newEnumMap(HttpStatus.class, defaultValue);
    }

    private Map<HttpStatus, FallbackFunction<?>> buildStatusFallbackMapping(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof StatusFallbacksConfigurer) {
            StatusFallbacksConfigurer statusFallbacksConfigurer = (StatusFallbacksConfigurer)configurer;
            return Mapp.newHashMap(statusFallbacksConfigurer.statusFallbackMapping());
        }
        return (Map)Listt.newArrayList((Iterable)AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, StatusFallback.class)).parallelStream().collect(Mapp.toMap(StatusFallback::status, anno -> this.buildFallbackFunction(anno.fallback())));
    }

    private EnumMap<HttpStatus.Series, FallbackFunction<?>> defaultFallback(AnnotatedElement element, Map<HttpStatus.Series, FallbackFunction<?>> defaultValue) {
        boolean bl;
        Configurer configurer = this.configurer;
        if (configurer instanceof DefaultFallbackDisabledConfigurer) {
            DefaultFallbackDisabledConfigurer disabledConfigurer = (DefaultFallbackDisabledConfigurer)configurer;
            bl = disabledConfigurer.disabledDefaultFallback();
        } else {
            bl = AnnotatedElementUtils.isAnnotated((AnnotatedElement)element, DefaultFallbackDisabled.class);
        }
        boolean disabled = bl;
        return Mapp.newEnumMap(HttpStatus.Series.class, disabled ? null : defaultValue);
    }

    private Map<HttpStatus.Series, FallbackFunction<?>> buildStatusSeriesFallbackMapping(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof StatusSeriesFallbacksConfigurer) {
            StatusSeriesFallbacksConfigurer statusSeriesFallbacksConfigurer = (StatusSeriesFallbacksConfigurer)configurer;
            return Mapp.newHashMap(statusSeriesFallbacksConfigurer.statusSeriesFallbackMapping());
        }
        return (Map)Listt.newArrayList((Iterable)AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, StatusSeriesFallback.class)).parallelStream().collect(Mapp.toMap(StatusSeriesFallback::statusSeries, anno -> this.buildFallbackFunction(anno.fallback())));
    }

    private FallbackFunction<?> buildFallbackFunction(Class<? extends FallbackFunction> fallbackClass) {
        return (FallbackFunction)FactoryContext.build((Factory)this.factory, fallbackClass);
    }

    private RequestExtend.RequestExtender buildRequestExtender(AnnotatedElement element, RequestExtend.RequestExtender defaultValue) {
        RequestExtendDisabledConfigurer disabledConfigurer;
        Configurer configurer = this.configurer;
        if (configurer instanceof RequestExtendDisabledConfigurer ? (disabledConfigurer = (RequestExtendDisabledConfigurer)configurer).disabledRequestExtend() : AnnotatedElementUtils.isAnnotated((AnnotatedElement)element, RequestExtend.Disabled.class)) {
            return null;
        }
        return (RequestExtend.RequestExtender)Condition.nullThen((Object)this.buildRequestExtender(element), () -> defaultValue);
    }

    private RequestExtend.RequestExtender buildRequestExtender(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof RequestExtendConfigurer) {
            RequestExtendConfigurer requestExtendConfigurer = (RequestExtendConfigurer)configurer;
            return requestExtendConfigurer.requestExtender();
        }
        RequestExtend requestExtend = (RequestExtend)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, RequestExtend.class);
        return (RequestExtend.RequestExtender)Condition.notNullThen((Object)requestExtend, anno -> (RequestExtend.RequestExtender)FactoryContext.build((Factory)this.factory, anno.value()));
    }

    private ResponseParse.ResponseParser buildResponseParser(AnnotatedElement element, ResponseParse.ResponseParser defaultValue) {
        ResponseParseDisabledConfigurer disabledConfigurer;
        Configurer configurer = this.configurer;
        if (configurer instanceof ResponseParseDisabledConfigurer ? (disabledConfigurer = (ResponseParseDisabledConfigurer)configurer).disabledResponseParse() : AnnotatedElementUtils.isAnnotated((AnnotatedElement)element, ResponseParse.Disabled.class)) {
            return null;
        }
        return (ResponseParse.ResponseParser)Condition.nullThen((Object)this.buildResponseParser(element), () -> defaultValue);
    }

    private ResponseParse.ResponseParser buildResponseParser(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResponseParseConfigurer) {
            ResponseParseConfigurer responseParseConfigurer = (ResponseParseConfigurer)configurer;
            return responseParseConfigurer.responseParser();
        }
        ResponseParse responseParse = (ResponseParse)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResponseParse.class);
        return (ResponseParse.ResponseParser)Condition.notNullThen((Object)responseParse, anno -> (ResponseParse.ResponseParser)FactoryContext.build((Factory)this.factory, anno.value()));
    }

    private ExtraUrlQuery.ExtraUrlQueryBuilder buildExtraUrlQueryBuilder(AnnotatedElement element, ExtraUrlQuery.ExtraUrlQueryBuilder defaultValue) {
        ExtraUrlQueryDisabledConfigurer disabledConfigurer;
        Configurer configurer = this.configurer;
        if (configurer instanceof ExtraUrlQueryDisabledConfigurer ? (disabledConfigurer = (ExtraUrlQueryDisabledConfigurer)configurer).disabledExtraUrlQuery() : AnnotatedElementUtils.isAnnotated((AnnotatedElement)element, ExtraUrlQuery.Disabled.class)) {
            return null;
        }
        return (ExtraUrlQuery.ExtraUrlQueryBuilder)Condition.nullThen((Object)this.buildExtraUrlQueryBuilder(element), () -> defaultValue);
    }

    private ExtraUrlQuery.ExtraUrlQueryBuilder buildExtraUrlQueryBuilder(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ExtraUrlQueryConfigurer) {
            ExtraUrlQueryConfigurer extraUrlQueryConfigurer = (ExtraUrlQueryConfigurer)configurer;
            return extraUrlQueryConfigurer.extraUrlQueryBuilder();
        }
        ExtraUrlQuery extraUrlQuery = (ExtraUrlQuery)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ExtraUrlQuery.class);
        return (ExtraUrlQuery.ExtraUrlQueryBuilder)Condition.notNullThen((Object)extraUrlQuery, anno -> (ExtraUrlQuery.ExtraUrlQueryBuilder)FactoryContext.build((Factory)this.factory, anno.value()));
    }

    private MappingBalance.MappingBalancer buildMappingBalancer(AnnotatedElement element, MappingBalance.MappingBalancer defaultValue) {
        return (MappingBalance.MappingBalancer)Condition.nullThen((Object)this.buildMappingBalancer(element), () -> defaultValue);
    }

    private MappingBalance.MappingBalancer buildMappingBalancer(AnnotatedElement element) {
        Configurer configurer = this.configurer;
        if (configurer instanceof MappingBalanceConfigurer) {
            MappingBalanceConfigurer mappingBalanceConfigurer = (MappingBalanceConfigurer)configurer;
            return mappingBalanceConfigurer.mappingBalancer();
        }
        MappingBalance mappingBalance = (MappingBalance)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, MappingBalance.class);
        return (MappingBalance.MappingBalancer)Condition.notNullThen((Object)mappingBalance, anno -> (MappingBalance.MappingBalancer)FactoryContext.build((Factory)this.factory, anno.value()));
    }

    @Generated
    public CommonElement(T base, Factory factory) {
        this.base = base;
        this.factory = factory;
    }

    @Generated
    public T base() {
        return this.base;
    }

    @Generated
    public Factory factory() {
        return this.factory;
    }

    @Generated
    public Configurer configurer() {
        return this.configurer;
    }
}

