/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.common;

import com.github.charlemaznable.core.codec.Json;
import com.github.charlemaznable.core.codec.Xml;
import com.github.charlemaznable.core.lang.Clz;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.lang.Reflectt;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.mutiny.MutinyBuildHelper;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.core.reactor.ReactorBuildHelper;
import com.github.charlemaznable.core.rxjava.RxJava1BuildHelper;
import com.github.charlemaznable.core.rxjava.RxJava2BuildHelper;
import com.github.charlemaznable.core.rxjava.RxJava3BuildHelper;
import com.github.charlemaznable.httpclient.annotation.Bundle;
import com.github.charlemaznable.httpclient.annotation.ContentFormat;
import com.github.charlemaznable.httpclient.annotation.Context;
import com.github.charlemaznable.httpclient.annotation.ExtraUrlQuery;
import com.github.charlemaznable.httpclient.annotation.Header;
import com.github.charlemaznable.httpclient.annotation.MappingBalance;
import com.github.charlemaznable.httpclient.annotation.PathVar;
import com.github.charlemaznable.httpclient.annotation.RequestBodyRaw;
import com.github.charlemaznable.httpclient.annotation.RequestExtend;
import com.github.charlemaznable.httpclient.annotation.ResponseParse;
import com.github.charlemaznable.httpclient.common.CncRequest;
import com.github.charlemaznable.httpclient.common.CncResponse;
import com.github.charlemaznable.httpclient.common.CommonBase;
import com.github.charlemaznable.httpclient.common.CommonMethod;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpMethod;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceDecorators;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.commons.text.StringSubstitutor;
import org.joor.Reflect;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class CommonExecute<T extends CommonBase<T>, M extends CommonMethod<T>, R, B> {
    final T base;
    final M executeMethod;
    Object[] args;
    Class<? extends CncResponse> responseClass = CncResponse.CncResponseImpl.class;
    String requestBodyRaw;

    public final void prepareArguments(Object[] args) {
        this.args = args;
        Class<?>[] parameterTypes = ((CommonMethod)this.executeMethod).method().getParameterTypes();
        Parameter[] parameters = ((CommonMethod)this.executeMethod).method().getParameters();
        for (int i = 0; i < args.length; ++i) {
            Object argument = args[i];
            Class<?> parameterType = parameterTypes[i];
            Parameter parameter = parameters[i];
            boolean configuredType = this.processParameterType(argument, parameterType);
            if (configuredType) continue;
            this.processAnnotations(argument, parameter, null);
        }
    }

    protected boolean processParameterType(Object argument, Class<?> parameterType) {
        if (argument instanceof Charset) {
            Charset acceptCharset;
            ((CommonBase)this.base).acceptCharset = acceptCharset = (Charset)argument;
        } else if (argument instanceof ContentFormat.ContentFormatter) {
            ContentFormat.ContentFormatter contentFormatter;
            ((CommonBase)this.base).contentFormatter = contentFormatter = (ContentFormat.ContentFormatter)argument;
        } else if (argument instanceof HttpMethod) {
            HttpMethod httpMethod;
            ((CommonBase)this.base).httpMethod = httpMethod = (HttpMethod)((Object)argument);
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{RequestExtend.RequestExtender.class})) {
            ((CommonBase)this.base).requestExtender = (RequestExtend.RequestExtender)argument;
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{ResponseParse.ResponseParser.class})) {
            ((CommonBase)this.base).responseParser = (ResponseParse.ResponseParser)argument;
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{ExtraUrlQuery.ExtraUrlQueryBuilder.class})) {
            ((CommonBase)this.base).extraUrlQueryBuilder = (ExtraUrlQuery.ExtraUrlQueryBuilder)argument;
        } else if (argument instanceof MappingBalance.MappingBalancer) {
            MappingBalance.MappingBalancer mappingBalancer;
            ((CommonBase)this.base).mappingBalancer = mappingBalancer = (MappingBalance.MappingBalancer)argument;
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{Bulkhead.class})) {
            ((CommonBase)this.base).resilienceBase.bulkhead((Bulkhead)argument);
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{TimeLimiter.class})) {
            ((CommonBase)this.base).resilienceBase.timeLimiter((TimeLimiter)argument);
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{RateLimiter.class})) {
            ((CommonBase)this.base).resilienceBase.rateLimiter((RateLimiter)argument);
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{CircuitBreaker.class})) {
            ((CommonBase)this.base).resilienceBase.circuitBreaker((CircuitBreaker)argument);
        } else if (Clz.isAssignable(parameterType, (Class[])new Class[]{Retry.class})) {
            ((CommonBase)this.base).resilienceBase.retry((Retry)argument);
        } else {
            if (Clz.isAssignable(parameterType, (Class[])new Class[]{CncRequest.class})) {
                this.responseClass = (Class)Condition.checkNull((Object)argument, () -> CncResponse.CncResponseImpl.class, xx -> ((CncRequest)xx).responseClass());
                return false;
            }
            return false;
        }
        return true;
    }

    private void processAnnotations(Object argument, AnnotatedElement annotatedElement, String defaultParameterName) {
        AtomicBoolean processed = new AtomicBoolean(false);
        Condition.notNullThenRun((Object)((Header)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, Header.class)), header -> {
            this.processHeader(argument, (Header)header);
            processed.set(true);
        });
        Condition.notNullThenRun((Object)((PathVar)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, PathVar.class)), pathVar -> {
            this.processPathVar(argument, (PathVar)pathVar);
            processed.set(true);
        });
        Condition.notNullThenRun((Object)((com.github.charlemaznable.httpclient.annotation.Parameter)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, com.github.charlemaznable.httpclient.annotation.Parameter.class)), parameter -> {
            this.processParameter(argument, (com.github.charlemaznable.httpclient.annotation.Parameter)parameter);
            processed.set(true);
        });
        Condition.notNullThenRun((Object)((Context)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, Context.class)), context -> {
            this.processContext(argument, (Context)context);
            processed.set(true);
        });
        Condition.notNullThenRun((Object)((RequestBodyRaw)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, RequestBodyRaw.class)), xx -> {
            this.processRequestBodyRaw(argument);
            processed.set(true);
        });
        Condition.notNullThenRun((Object)((Bundle)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, Bundle.class)), xx -> {
            this.processBundle(argument);
            processed.set(true);
        });
        if (!processed.get() && Objects.nonNull(defaultParameterName)) {
            this.processParameter(argument, new ParameterImpl(defaultParameterName));
        }
    }

    private void processHeader(Object argument, Header header) {
        ((CommonBase)this.base).headers.add((Pair<String, String>)Pair.of((Object)header.value(), (Object)((String)Condition.notNullThen((Object)argument, Str::toStr))));
    }

    private void processPathVar(Object argument, PathVar pathVar) {
        ((CommonBase)this.base).pathVars.add((Pair<String, String>)Pair.of((Object)pathVar.value(), (Object)((String)Condition.notNullThen((Object)argument, Str::toStr))));
    }

    private void processParameter(Object argument, com.github.charlemaznable.httpclient.annotation.Parameter parameter) {
        ((CommonBase)this.base).parameters.add((Pair<String, Object>)Pair.of((Object)parameter.value(), (Object)argument));
    }

    private void processContext(Object argument, Context context) {
        ((CommonBase)this.base).contexts.add((Pair<String, Object>)Pair.of((Object)context.value(), (Object)argument));
    }

    private void processRequestBodyRaw(Object argument) {
        if (null == argument || argument instanceof String) {
            this.requestBodyRaw = (String)argument;
            return;
        }
        ((CommonMethod)this.executeMethod).defaultClass.logger.warn("Argument annotated with @RequestBodyRaw, but Type is {} instead String.", argument.getClass());
    }

    private void processBundle(Object argument) {
        if (Objects.isNull(argument)) {
            return;
        }
        if (argument instanceof Map) {
            Json.desc((Object)argument).forEach((key, value) -> this.processParameter(value, new ParameterImpl(Str.toStr((Object)key))));
            return;
        }
        Class<?> clazz = argument.getClass();
        Reflect reflect = Reflect.on((Object)argument);
        Map fields = reflect.fields();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            String fieldName = (String)fieldEntry.getKey();
            this.processAnnotations(((Reflect)fieldEntry.getValue()).get(), Reflectt.field0(clazz, (String)fieldName), fieldName);
        }
    }

    public abstract Object execute();

    protected final CommonExecuteParams buildCommonExecuteParams() {
        CommonExecuteParams params = new CommonExecuteParams();
        Map pathVarMap = (Map)((CommonBase)this.base).pathVars.stream().collect(Mapp.toMap(Pair::getKey, Pair::getValue));
        params.parameterMap = (Map)((CommonBase)this.base).parameters.stream().collect(Mapp.toMap(Pair::getKey, Pair::getValue));
        params.contextMap = (Map)((CommonBase)this.base).contexts.stream().collect(Mapp.toMap(Pair::getKey, Pair::getValue));
        StringSubstitutor pathVarSubstitutor = new StringSubstitutor(pathVarMap, "{", "}");
        String substitutedUrl = pathVarSubstitutor.replace(((CommonBase)this.base).mappingBalancer.choose(((CommonMethod)this.executeMethod()).requestUrls));
        String extraUrlQuery = (String)Condition.checkNull((Object)((CommonBase)this.base).extraUrlQueryBuilder, () -> "", builder -> builder.build(params.parameterMap, params.contextMap));
        params.requestUrl = Url.concatUrlQuery((String)substitutedUrl, (String)extraUrlQuery);
        params.requestMethod = ((CommonBase)this.base).httpMethod.toString();
        return params;
    }

    public final Object processResponse(R response) {
        int statusCode = this.getResponseCode(response);
        B responseBody = this.getResponseBody(response);
        FallbackFunction<?> statusFallback = ((CommonBase)this.base).statusFallbackMapping.get((Object)HttpStatus.valueOf(statusCode));
        if (Objects.nonNull(statusFallback)) {
            return this.applyFallback(statusFallback, statusCode, responseBody);
        }
        FallbackFunction<?> statusSeriesFallback = ((CommonBase)this.base).statusSeriesFallbackMapping.get((Object)HttpStatus.Series.valueOf(statusCode));
        if (Objects.nonNull(statusSeriesFallback)) {
            return this.applyFallback(statusSeriesFallback, statusCode, responseBody);
        }
        List<Object> responseObjs = this.processResponseBody(statusCode, responseBody, this.responseClass);
        if (((CommonMethod)this.executeMethod).returnList) {
            Object responseObj = responseObjs.get(0);
            if (responseObj instanceof Collection) {
                return Listt.newArrayList((Iterable)((Collection)responseObj));
            }
            return Listt.newArrayList((Object[])new Object[]{responseObj});
        }
        if (((CommonMethod)this.executeMethod).returnMap) {
            Object responseObj = responseObjs.get(0);
            if (responseObj instanceof Map) {
                return Mapp.newHashMap((Map)((Map)responseObj));
            }
            return Json.unJson((String)Json.json((Object)responseObj), HashMap.class);
        }
        if (((CommonMethod)this.executeMethod).returnPair) {
            return Pair.of((Object)responseObjs.get(0), (Object)responseObjs.get(1));
        }
        if (((CommonMethod)this.executeMethod).returnTriple) {
            return Triple.of((Object)responseObjs.get(0), (Object)responseObjs.get(1), (Object)responseObjs.get(2));
        }
        return responseObjs.get(0);
    }

    protected abstract int getResponseCode(R var1);

    protected abstract B getResponseBody(R var1);

    protected abstract String getResponseBodyString(B var1);

    private Object applyFallback(FallbackFunction<?> function, int statusCode, B responseBody) {
        return function.apply(new FallbackFunction.Response<B>(statusCode, responseBody){

            @Override
            public String responseBodyAsString() {
                return Str.toStr((Object)Condition.notNullThen(this.getResponseBody(), body -> CommonExecute.this.getResponseBodyString(body)));
            }
        });
    }

    private List<Object> processResponseBody(int statusCode, B responseBody, Class<?> responseClass) {
        return ((CommonMethod)this.executeMethod).returnTypes.stream().map(returnType -> this.processReturnTypeValue(statusCode, responseBody, CncResponse.class == returnType ? responseClass : returnType)).collect(Collectors.toList());
    }

    private Object processReturnTypeValue(int statusCode, B responseBody, Class<?> returnType) {
        if (this.returnVoid(returnType)) {
            return null;
        }
        if (this.returnInteger(returnType)) {
            return statusCode;
        }
        if (HttpStatus.class == returnType) {
            return HttpStatus.valueOf(statusCode);
        }
        if (HttpStatus.Series.class == returnType) {
            return HttpStatus.Series.valueOf(statusCode);
        }
        if (this.returnBoolean(returnType)) {
            return HttpStatus.valueOf(statusCode).is2xxSuccessful();
        }
        if (this.returnUnCollectionString(returnType)) {
            return Condition.notNullThen(responseBody, this::getResponseBodyString);
        }
        return this.customProcessReturnTypeValue(statusCode, responseBody, returnType);
    }

    protected Object customProcessReturnTypeValue(int statusCode, B responseBody, Class<?> returnType) {
        return this.parseObject(responseBody, returnType);
    }

    private Object parseObject(B responseBody, Class<?> returnType) {
        String content = (String)Condition.notNullThen(responseBody, this::getResponseBodyString);
        if (Str.isBlank((String)content)) {
            return null;
        }
        if (Objects.nonNull(((CommonBase)this.base).responseParser)) {
            Map contextMap = (Map)((CommonBase)this.base).contexts.stream().collect(Mapp.toMap(Pair::getKey, Pair::getValue));
            return ((CommonBase)this.base).responseParser.parse(content, returnType, contextMap);
        }
        if (content.startsWith("<")) {
            return Json.spec((Map)Xml.unXml((String)content), returnType);
        }
        if (content.startsWith("[")) {
            return Json.unJsonArray((String)content, returnType);
        }
        if (content.startsWith("{")) {
            return Json.unJson((String)content, returnType);
        }
        throw new IllegalArgumentException("Parse response body Error: \n" + content);
    }

    private boolean returnVoid(Class<?> returnType) {
        return Void.TYPE == returnType || Void.class == returnType;
    }

    private boolean returnInteger(Class<?> returnType) {
        return Integer.TYPE == returnType || Integer.class == returnType;
    }

    private boolean returnBoolean(Class<?> returnType) {
        return Boolean.TYPE == returnType || Boolean.class == returnType;
    }

    private boolean returnUnCollectionString(Class<?> returnType) {
        return String.class == returnType && !((CommonMethod)this.executeMethod).returnList;
    }

    protected Object adaptationFromFuture(CompletableFuture<Object> future) {
        if (((CommonMethod)this.executeMethod).returnReactorMono()) {
            return ReactorBuildHelper.buildMonoFromFuture(future);
        }
        if (((CommonMethod)this.executeMethod).returnRxJavaSingle()) {
            return RxJava1BuildHelper.buildSingleFromFuture(future);
        }
        if (((CommonMethod)this.executeMethod).returnRxJava2Single()) {
            return RxJava2BuildHelper.buildSingleFromFuture(future);
        }
        if (((CommonMethod)this.executeMethod).returnRxJava3Single()) {
            return RxJava3BuildHelper.buildSingleFromFuture(future);
        }
        if (((CommonMethod)this.executeMethod).returnMutinyUni()) {
            return MutinyBuildHelper.buildUniFromFuture(future);
        }
        return future;
    }

    protected CompletableFuture<Object> decorateAsyncExecute(Supplier<CompletionStage<Object>> stageSupplier) {
        return ResilienceDecorators.ofCompletionStage(stageSupplier).withResilienceBase(((CommonBase)this.base).resilienceBase).get().toCompletableFuture();
    }

    @Generated
    public CommonExecute(T base, M executeMethod) {
        this.base = base;
        this.executeMethod = executeMethod;
    }

    @Generated
    public T base() {
        return this.base;
    }

    @Generated
    public M executeMethod() {
        return this.executeMethod;
    }

    @Generated
    public Object[] args() {
        return this.args;
    }

    @Generated
    public Class<? extends CncResponse> responseClass() {
        return this.responseClass;
    }

    @Generated
    public String requestBodyRaw() {
        return this.requestBodyRaw;
    }

    private static class ParameterImpl
    implements com.github.charlemaznable.httpclient.annotation.Parameter {
        private final Class<? extends Annotation> annotationType = com.github.charlemaznable.httpclient.annotation.Parameter.class;
        private String value;

        @Override
        public String value() {
            return this.value;
        }

        @Generated
        public ParameterImpl(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }
    }

    protected static final class CommonExecuteParams {
        private Map<String, Object> parameterMap;
        private Map<String, Object> contextMap;
        private String requestUrl;
        private String requestMethod;

        protected CommonExecuteParams() {
        }

        @Generated
        public Map<String, Object> parameterMap() {
            return this.parameterMap;
        }

        @Generated
        public Map<String, Object> contextMap() {
            return this.contextMap;
        }

        @Generated
        public String requestUrl() {
            return this.requestUrl;
        }

        @Generated
        public String requestMethod() {
            return this.requestMethod;
        }
    }
}

