/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.common;

import com.github.charlemaznable.core.lang.Clz;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.Reloadable;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.mutiny.MutinyCheckHelper;
import com.github.charlemaznable.core.reactor.ReactorCheckHelper;
import com.github.charlemaznable.core.rxjava.RxJavaCheckHelper;
import com.github.charlemaznable.httpclient.common.CncResponse;
import com.github.charlemaznable.httpclient.common.CommonBase;
import com.github.charlemaznable.httpclient.common.CommonClass;
import com.github.charlemaznable.httpclient.common.CommonElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class CommonMethod<T extends CommonBase<T>>
implements Reloadable {
    final CommonElement<T> element;
    final CommonClass<T> defaultClass;
    final Method method;
    List<String> requestUrls;
    static final String RETURN_GENERIC_ERROR = "Method return type generic Error";
    boolean returnFuture;
    boolean returnJavaConcurrent;
    boolean returnReactorMono;
    boolean returnRxJavaSingle;
    boolean returnRxJava2Single;
    boolean returnRxJava3Single;
    boolean returnMutinyUni;
    boolean returnList;
    boolean returnMap;
    boolean returnPair;
    boolean returnTriple;
    List<Class<?>> returnTypes;

    public CommonMethod(CommonElement<T> element, CommonClass<T> defaultClass, Method method) {
        this.element = element;
        this.defaultClass = defaultClass;
        this.method = method;
        this.element.initializeConfigListener(this::reload);
        this.initializeReturnTypes();
    }

    private void initializeReturnTypes() {
        Class returnType = this.method.getReturnType();
        this.returnFuture = this.checkReturnFuture(returnType);
        this.returnList = this.checkReturnList(returnType);
        this.returnMap = this.checkReturnMap(returnType);
        this.returnPair = this.checkReturnPair(returnType);
        this.returnTriple = this.checkReturnTriple(returnType);
        Type genericReturnType = this.method.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            this.checkUnParameterizedType(genericReturnType, this.returnFuture);
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (this.returnFuture) {
            Type futureTypeArgument = actualTypeArguments[0];
            if (futureTypeArgument instanceof Class) {
                returnType = (Class)futureTypeArgument;
                this.returnList = this.checkReturnList(returnType);
                this.returnMap = this.checkReturnMap(returnType);
                this.returnPair = this.checkReturnPair(returnType);
                this.returnTriple = this.checkReturnTriple(returnType);
            }
            if (!(futureTypeArgument instanceof ParameterizedType)) {
                this.checkUnParameterizedType(futureTypeArgument, false);
                return;
            }
            parameterizedType = (ParameterizedType)futureTypeArgument;
            returnType = (Class)parameterizedType.getRawType();
            this.returnList = this.checkReturnList(returnType);
            this.returnMap = this.checkReturnMap(returnType);
            this.returnPair = this.checkReturnPair(returnType);
            this.returnTriple = this.checkReturnTriple(returnType);
            actualTypeArguments = parameterizedType.getActualTypeArguments();
        }
        this.returnTypes = this.returnList || this.returnPair || this.returnTriple ? this.processActualTypeArguments(actualTypeArguments) : Listt.newArrayList((Object[])new Class[]{returnType});
    }

    protected boolean checkReturnFuture(Class<?> returnType) {
        this.returnJavaConcurrent = this.checkReturnJavaConcurrent(returnType);
        this.returnReactorMono = ReactorCheckHelper.checkReturnReactorMono(returnType);
        this.returnRxJavaSingle = RxJavaCheckHelper.checkReturnRxJavaSingle(returnType);
        this.returnRxJava2Single = RxJavaCheckHelper.checkReturnRxJava2Single(returnType);
        this.returnRxJava3Single = RxJavaCheckHelper.checkReturnRxJava3Single(returnType);
        this.returnMutinyUni = MutinyCheckHelper.checkReturnMutinyUni(returnType);
        return this.returnJavaConcurrent || this.returnReactorMono || this.returnRxJavaSingle || this.returnRxJava2Single || this.returnRxJava3Single || this.returnMutinyUni;
    }

    private boolean checkReturnJavaConcurrent(Class<?> returnType) {
        return Object.class != returnType && Clz.isAssignable(CompletableFuture.class, (Class[])new Class[]{returnType});
    }

    private boolean checkReturnList(Class<?> returnType) {
        return Clz.isAssignable(ArrayList.class, (Class[])new Class[]{returnType}) && Clz.isAssignable(returnType, (Class[])new Class[]{Iterable.class});
    }

    private boolean checkReturnMap(Class<?> returnType) {
        return Clz.isAssignable(HashMap.class, (Class[])new Class[]{returnType}) && Clz.isAssignable(returnType, (Class[])new Class[]{Map.class});
    }

    private boolean checkReturnPair(Class<?> returnType) {
        return Pair.class == returnType;
    }

    private boolean checkReturnTriple(Class<?> returnType) {
        return Triple.class == returnType;
    }

    private void checkUnParameterizedType(Type type, boolean checkReturnFutureOrNot) {
        if (checkReturnFutureOrNot || this.returnList || this.returnPair || this.returnTriple) {
            throw new IllegalStateException(RETURN_GENERIC_ERROR);
        }
        if (type instanceof TypeVariable) {
            this.checkTypeVariableBounds(type);
            this.returnTypes = Listt.newArrayList((Object[])new Class[]{CncResponse.class});
        } else {
            this.returnTypes = Listt.newArrayList((Object[])new Class[]{(Class)type});
        }
    }

    private void checkTypeVariableBounds(Type type) {
        Type[] bounds = ((TypeVariable)type).getBounds();
        if (bounds.length != 1 || !Clz.isAssignable((Class)((Class)bounds[0]), (Class[])new Class[]{CncResponse.class})) {
            throw new IllegalStateException(RETURN_GENERIC_ERROR);
        }
    }

    private List<Class<?>> processActualTypeArguments(Type[] actualTypeArguments) {
        List result = Listt.newArrayList();
        for (Type actualTypeArgument : actualTypeArguments) {
            if (actualTypeArgument instanceof TypeVariable) {
                this.checkTypeVariableBounds(actualTypeArgument);
                result.add(CncResponse.class);
                continue;
            }
            result.add((Class)actualTypeArgument);
        }
        return result;
    }

    protected void initialize() {
        this.element.initializeConfigurer(this.method);
        this.element.setUpBeforeInitialization(this.defaultClass.clazz, this.method, this.defaultClass.element);
        this.requestUrls = this.buildRequestUrls();
        this.element.initialize(this.method, this.defaultClass.element.base);
        this.element.tearDownAfterInitialization(this.defaultClass.clazz, this.method, this.defaultClass.element);
    }

    private List<String> buildRequestUrls() {
        List urls = (List)Condition.emptyThen(this.element.buildMappingUrls(this.method), () -> Listt.newArrayList((Object[])new String[]{this.defaultClass.mappingMethodNameDisabled ? "" : "/" + this.method.getName()}));
        List concatedUrls = Listt.newArrayList();
        for (String url : urls) {
            if (Str.isBlank((String)url)) {
                concatedUrls.addAll(this.defaultClass.baseUrls);
                continue;
            }
            concatedUrls.addAll(this.defaultClass.baseUrls.stream().map(base -> (String)Condition.checkBlank((String)base, () -> url, b -> b + url)).toList());
        }
        return concatedUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.element.configLock;
        synchronized (object) {
            this.initialize();
        }
    }

    public abstract Object execute(Object[] var1);

    @Generated
    public CommonElement<T> element() {
        return this.element;
    }

    @Generated
    public CommonClass<T> defaultClass() {
        return this.defaultClass;
    }

    @Generated
    public Method method() {
        return this.method;
    }

    @Generated
    public boolean returnFuture() {
        return this.returnFuture;
    }

    @Generated
    public boolean returnJavaConcurrent() {
        return this.returnJavaConcurrent;
    }

    @Generated
    public boolean returnReactorMono() {
        return this.returnReactorMono;
    }

    @Generated
    public boolean returnRxJavaSingle() {
        return this.returnRxJavaSingle;
    }

    @Generated
    public boolean returnRxJava2Single() {
        return this.returnRxJava2Single;
    }

    @Generated
    public boolean returnRxJava3Single() {
        return this.returnRxJava3Single;
    }

    @Generated
    public boolean returnMutinyUni() {
        return this.returnMutinyUni;
    }
}

