/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.common;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.annotation.ContentFormat;
import com.github.charlemaznable.httpclient.annotation.ExtraUrlQuery;
import com.github.charlemaznable.httpclient.common.CommonBase;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.internal.http.HttpMethod;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommonReq<T extends CommonReq<T>>
extends CommonBase<CommonReq<T>> {
    protected String baseUrl;
    protected String reqPath;
    protected String requestBody;

    public static Boolean permitsRequestBody(String requestMethod) {
        return HttpMethod.permitsRequestBody((String)requestMethod);
    }

    public static String parseCharset(String contentType) {
        return (String)Condition.checkNull((Object)MediaType.parse((String)contentType), StandardCharsets.UTF_8::name, mediaType -> (String)Condition.checkNull((Object)mediaType.charset(), StandardCharsets.UTF_8::name, Charset::name));
    }

    public CommonReq(String baseUrl) {
        this();
        this.baseUrl = baseUrl;
    }

    public <U extends CommonReq<U>> CommonReq(CommonReq<U> other) {
        super(other);
        this.baseUrl = other.baseUrl;
        this.reqPath = other.reqPath;
        this.requestBody = other.requestBody;
    }

    public T req(String reqPath) {
        this.reqPath = reqPath;
        return (T)this;
    }

    public T requestBody(String requestBody) {
        this.requestBody = requestBody;
        return (T)this;
    }

    public T acceptCharset(Charset acceptCharset) {
        this.acceptCharset = acceptCharset;
        return (T)this;
    }

    public T contentFormat(ContentFormat.ContentFormatter contentFormatter) {
        this.contentFormatter = contentFormatter;
        return (T)this;
    }

    public T header(String name, String value) {
        this.headers.add(Pair.of((Object)name, (Object)value));
        return (T)this;
    }

    public T headers(Map<String, String> headers) {
        headers.forEach(this::header);
        return (T)this;
    }

    public T parameter(String name, Object value) {
        this.parameters.add(Pair.of((Object)name, (Object)value));
        return (T)this;
    }

    public T parameters(Map<String, Object> parameters) {
        parameters.forEach(this::parameter);
        return (T)this;
    }

    public T statusFallback(HttpStatus httpStatus, FallbackFunction<?> fallbackFunction) {
        this.statusFallbackMapping.put(httpStatus, fallbackFunction);
        return (T)this;
    }

    public T statusSeriesFallback(HttpStatus.Series httpStatusSeries, FallbackFunction<?> fallbackFunction) {
        this.statusSeriesFallbackMapping.put(httpStatusSeries, fallbackFunction);
        return (T)this;
    }

    public T extraUrlQueryBuilder(ExtraUrlQuery.ExtraUrlQueryBuilder extraUrlQueryBuilder) {
        this.extraUrlQueryBuilder = extraUrlQueryBuilder;
        return (T)this;
    }

    protected Map<String, Object> fetchParameterMap() {
        return (Map)this.parameters.stream().collect(Mapp.toMap(Pair::getKey, Pair::getValue));
    }

    protected String concatRequestUrl(Map<String, Object> parameterMap) {
        String requestUrl = Str.toStr((Object)this.baseUrl).trim() + Str.toStr((Object)this.reqPath).trim();
        String extraUrlQuery = (String)Condition.checkNull((Object)this.extraUrlQueryBuilder, () -> "", builder -> builder.build(parameterMap, Mapp.newHashMap()));
        return Url.concatUrlQuery((String)requestUrl, (String)extraUrlQuery);
    }

    @Generated
    public CommonReq() {
    }

    public static abstract class Instance<T extends Instance<T>>
    extends CommonReq<Instance<T>> {
        public <U extends CommonReq<U>> Instance(CommonReq<U> other) {
            super(other);
        }

        public abstract T copy();

        @Override
        public T req(String reqPath) {
            T copy = this.copy();
            ((Instance)copy).reqPath = reqPath;
            return copy;
        }

        @Override
        public T requestBody(String requestBody) {
            T copy = this.copy();
            ((Instance)copy).requestBody = requestBody;
            return copy;
        }

        @Override
        public T acceptCharset(Charset acceptCharset) {
            T copy = this.copy();
            ((Instance)copy).acceptCharset = acceptCharset;
            return copy;
        }

        @Override
        public T contentFormat(ContentFormat.ContentFormatter contentFormatter) {
            T copy = this.copy();
            ((Instance)copy).contentFormatter = contentFormatter;
            return copy;
        }

        @Override
        public T header(String name, String value) {
            T copy = this.copy();
            ((Instance)copy).headers.add(Pair.of((Object)name, (Object)value));
            return copy;
        }

        @Override
        public T headers(Map<String, String> headers) {
            T copy = this.copy();
            headers.forEach((name, value) -> copy.headers.add(Pair.of((Object)name, (Object)value)));
            return copy;
        }

        @Override
        public T parameter(String name, Object value) {
            T copy = this.copy();
            ((Instance)copy).parameters.add(Pair.of((Object)name, (Object)value));
            return copy;
        }

        @Override
        public T parameters(Map<String, Object> parameters) {
            T copy = this.copy();
            parameters.forEach((name, value) -> copy.parameters.add(Pair.of((Object)name, (Object)value)));
            return copy;
        }

        @Override
        public T statusFallback(HttpStatus httpStatus, FallbackFunction<?> fallbackFunction) {
            T copy = this.copy();
            ((Instance)copy).statusFallbackMapping.put(httpStatus, fallbackFunction);
            return copy;
        }

        @Override
        public T statusSeriesFallback(HttpStatus.Series httpStatusSeries, FallbackFunction<?> fallbackFunction) {
            T copy = this.copy();
            ((Instance)copy).statusSeriesFallbackMapping.put(httpStatusSeries, fallbackFunction);
            return copy;
        }

        @Override
        public T extraUrlQueryBuilder(ExtraUrlQuery.ExtraUrlQueryBuilder extraUrlQueryBuilder) {
            T copy = this.copy();
            ((Instance)copy).extraUrlQueryBuilder = extraUrlQueryBuilder;
            return copy;
        }
    }
}

