/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.logging;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Str;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class LoggingOhInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Logger logger = (Logger)request.tag(Logger.class);
        if (Objects.isNull(logger) || !logger.isDebugEnabled()) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        String requestStartMessage = "--> " + request.method() + " " + request.url();
        if (Objects.nonNull(connection)) {
            requestStartMessage = requestStartMessage + " " + connection.protocol();
        }
        this.log(logger, requestStartMessage);
        Headers requestHeaders = request.headers();
        if (Objects.nonNull(requestBody)) {
            long contentLength;
            MediaType contentType = requestBody.contentType();
            if (Objects.nonNull(contentType) && Objects.isNull(requestHeaders.get("Content-Type"))) {
                this.log(logger, "Content-Type: " + contentType);
            }
            if (-1L != (contentLength = requestBody.contentLength()) && Objects.isNull(requestHeaders.get("Content-Length"))) {
                this.log(logger, "Content-Length: " + contentLength);
            }
        }
        for (int i = 0; i < requestHeaders.size(); ++i) {
            this.logHeader(logger, requestHeaders, i);
        }
        if (Objects.isNull(requestBody)) {
            this.log(logger, "--> END " + request.method());
        } else if (this.bodyHasUnknownEncoding(requestHeaders)) {
            this.log(logger, "--> END " + request.method() + " (encoded body omitted)");
        } else if (requestBody.isDuplex()) {
            this.log(logger, "--> END " + request.method() + " (duplex request body omitted)");
        } else if (requestBody.isOneShot()) {
            this.log(logger, "--> END " + request.method() + " (one-shot body omitted)");
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            Charset charset = (Charset)Condition.checkNull((Object)contentType, () -> StandardCharsets.UTF_8, t -> t.charset(StandardCharsets.UTF_8));
            this.log(logger, "");
            this.log(logger, buffer.readString(charset));
            this.log(logger, "--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.log(logger, "<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = (ResponseBody)Condition.checkNotNull((Object)response.body());
        this.log(logger, "<-- " + response.code() + (String)(Str.isEmpty((String)response.message()) ? "" : " " + response.message()) + " " + response.request().url() + " (" + tookMs + "ms)");
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            this.logHeader(logger, responseHeaders, i);
        }
        if (!HttpHeaders.promisesBody((Response)response)) {
            this.log(logger, "<-- END HTTP");
        } else if (this.bodyHasUnknownEncoding(responseHeaders)) {
            this.log(logger, "<-- END HTTP (encoded body omitted)");
        } else {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Long gzippedLength = null;
            if ("gzip".equalsIgnoreCase(responseHeaders.get("Content-Encoding"))) {
                gzippedLength = buffer.size();
                GzipSource gzippedResponseBody = new GzipSource((Source)buffer.clone());
                buffer = new Buffer();
                buffer.writeAll((Source)gzippedResponseBody);
            }
            MediaType contentType = responseBody.contentType();
            Charset charset = (Charset)Condition.checkNull((Object)contentType, () -> StandardCharsets.UTF_8, t -> t.charset(StandardCharsets.UTF_8));
            if (responseBody.contentLength() != 0L) {
                this.log(logger, "");
                this.log(logger, buffer.clone().readString(charset));
            }
            if (Objects.nonNull(gzippedLength)) {
                this.log(logger, "<-- END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body)");
            } else {
                this.log(logger, "<-- END HTTP (" + buffer.size() + "-byte body)");
            }
        }
        return response;
    }

    private void logHeader(Logger logger, Headers headers, int i) {
        this.log(logger, headers.name(i) + ": " + headers.value(i));
    }

    private boolean bodyHasUnknownEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        if (Objects.isNull(contentEncoding)) {
            return false;
        }
        return !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip");
    }

    private void log(Logger logger, String content) {
        logger.debug(content);
    }
}

