/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.logging;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.httpclient.common.CommonReq;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.github.charlemaznable.httpclient.vxclient.internal.VxExecuteRequest;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.ClientPhase;
import io.vertx.ext.web.client.impl.HttpContext;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;

public final class LoggingVxInterceptor
implements Handler<HttpContext<?>> {
    private static final String START_NS = "logging.startNs";

    public void handle(HttpContext<?> httpContext) {
        Logger logger = (Logger)httpContext.get(Logger.class.getName());
        if (Objects.isNull(logger) || !logger.isDebugEnabled()) {
            httpContext.next();
            return;
        }
        if (ClientPhase.CREATE_REQUEST == httpContext.phase()) {
            this.loggingCreateRequest(httpContext, logger);
        } else if (ClientPhase.DISPATCH_RESPONSE == httpContext.phase()) {
            this.loggingDispatchResponse(httpContext, logger);
        } else if (ClientPhase.FAILURE == httpContext.phase()) {
            this.loggingFailure(httpContext, logger);
        }
        httpContext.next();
    }

    private void loggingCreateRequest(HttpContext<Buffer> httpContext, Logger logger) {
        if (Objects.nonNull(httpContext.get(START_NS))) {
            long startNs = System.nanoTime();
            httpContext.set(START_NS, (Object)startNs);
            httpContext.next();
            return;
        }
        VxExecuteRequest executeRequest = (VxExecuteRequest)httpContext.get(VxExecuteRequest.class.getName());
        RequestOptions requestOptions = httpContext.requestOptions();
        HttpRequest request = httpContext.request();
        Buffer requestBody = (Buffer)httpContext.body();
        this.log(logger, "--> " + requestOptions.getMethod() + " " + (String)Condition.checkNull((Object)executeRequest, () -> "unknown url", VxExecuteRequest::getRequestUrl));
        MultiMap requestHeaders = request.headers();
        for (String name : requestHeaders.names()) {
            this.logHeader(logger, requestHeaders, name);
        }
        if (Objects.isNull(requestBody)) {
            this.log(logger, "--> END " + requestOptions.getMethod());
        } else if (this.bodyHasUnknownEncoding(requestHeaders)) {
            this.log(logger, "--> END " + requestOptions.getMethod() + " (encoded body omitted)");
        } else {
            String contentType = requestHeaders.get("Content-Type");
            String charset = (String)Condition.checkNull((Object)contentType, StandardCharsets.UTF_8::name, CommonReq::parseCharset);
            this.log(logger, "");
            this.log(logger, requestBody.toString(charset));
            this.log(logger, "--> END " + requestOptions.getMethod() + " (" + requestBody.length() + "-byte body)");
        }
        long startNs = System.nanoTime();
        httpContext.set(START_NS, (Object)startNs);
    }

    private void loggingDispatchResponse(HttpContext<Buffer> httpContext, Logger logger) {
        Long startNs = (Long)httpContext.get(START_NS);
        long tookMs = Objects.isNull(startNs) ? -1L : TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        VxExecuteRequest executeRequest = (VxExecuteRequest)httpContext.get(VxExecuteRequest.class.getName());
        RequestOptions requestOptions = httpContext.requestOptions();
        HttpResponse response = httpContext.response();
        this.log(logger, "<-- " + response.statusCode() + (String)(Str.isEmpty((String)response.statusMessage()) ? "" : " " + response.statusMessage()) + " " + (String)Condition.checkNull((Object)executeRequest, () -> "unknown url", VxExecuteRequest::getRequestUrl) + " (" + tookMs + "ms)");
        MultiMap responseHeaders = response.headers();
        for (String name : responseHeaders.names()) {
            this.logHeader(logger, responseHeaders, name);
        }
        if (!this.promisesBody(requestOptions, response)) {
            this.log(logger, "<-- END HTTP");
        } else if (this.bodyHasUnknownEncoding(responseHeaders)) {
            this.log(logger, "<-- END HTTP (encoded body omitted)");
        } else {
            String contentType = responseHeaders.get("Content-Type");
            String charset = (String)Condition.checkNull((Object)contentType, StandardCharsets.UTF_8::name, CommonReq::parseCharset);
            Buffer responseBody = (Buffer)Condition.nullThen((Object)((Buffer)response.body()), Buffer::buffer);
            int contentLength = responseBody.length();
            if ((long)contentLength != 0L) {
                this.log(logger, "");
                this.log(logger, responseBody.toString(charset));
            }
            this.log(logger, "<-- END HTTP (" + contentLength + "-byte body)");
        }
    }

    private void loggingFailure(HttpContext<Buffer> httpContext, Logger logger) {
        this.log(logger, "<-- HTTP FAILED: " + httpContext.failure());
    }

    private void logHeader(Logger logger, MultiMap headers, String name) {
        this.log(logger, name + ": " + String.join((CharSequence)", ", headers.getAll(name)));
    }

    private boolean bodyHasUnknownEncoding(MultiMap headers) {
        String contentEncoding = headers.get("Content-Encoding");
        if (Objects.isNull(contentEncoding)) {
            return false;
        }
        return !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip");
    }

    private boolean promisesBody(RequestOptions requestOptions, HttpResponse<?> response) {
        if (requestOptions.getMethod() == HttpMethod.HEAD) {
            return false;
        }
        int responseCode = response.statusCode();
        if ((responseCode < HttpStatus.CONTINUE.value() || responseCode >= 200) && responseCode != HttpStatus.NO_CONTENT.value() && responseCode != HttpStatus.NOT_MODIFIED.value()) {
            return true;
        }
        return NumberUtils.toLong((String)response.headers().get("Content-Length"), (long)-1L) != -1L || "chunked".equalsIgnoreCase(response.headers().get("Transfer-Encoding"));
    }

    private void log(Logger logger, String content) {
        logger.debug(content);
    }
}

