/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.logging;

import com.github.charlemaznable.core.codec.Bytes;
import com.github.charlemaznable.core.lang.Condition;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public final class LoggingWfInterceptor
implements ExchangeFilterFunction {
    @Nonnull
    public Mono<ClientResponse> filter(@Nonnull ClientRequest request, @Nonnull ExchangeFunction next) {
        Optional loggerOptional = request.attribute(Logger.class.getName());
        if (loggerOptional.isEmpty()) {
            return next.exchange(request);
        }
        Logger logger = (Logger)loggerOptional.get();
        if (!logger.isDebugEnabled()) {
            return next.exchange(request);
        }
        this.log(logger, "--> " + request.method().name() + " " + request.url());
        HttpHeaders requestHeaders = request.headers();
        for (String name : requestHeaders.keySet()) {
            this.logHeader(logger, requestHeaders, name);
        }
        Optional requestBodyOptional = request.attribute("RequestBodyAsStringSpecAttributeKey");
        if (requestBodyOptional.isEmpty()) {
            this.log(logger, "--> END " + request.method());
        } else {
            String requestBody = (String)requestBodyOptional.get();
            if (this.bodyHasUnknownEncoding(requestHeaders)) {
                this.log(logger, "--> END " + request.method() + " (encoded body omitted)");
            } else {
                MediaType contentType = requestHeaders.getContentType();
                Charset charset = (Charset)Condition.checkNull((Object)contentType, () -> StandardCharsets.UTF_8, MimeType::getCharset);
                int requestLength = ((byte[])Condition.nullThen((Object)Bytes.bytes((String)requestBody, (Charset)charset), () -> new byte[0])).length;
                this.log(logger, "");
                this.log(logger, requestBody);
                this.log(logger, "--> END " + request.method() + " (" + requestLength + "-byte body)");
            }
        }
        long startNs = System.nanoTime();
        return next.exchange(request).flatMap(clientResponse -> {
            ClientResponse.Builder builder = clientResponse.mutate();
            return clientResponse.toEntity(String.class).map(responseEntity -> {
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                int statusCode = responseEntity.getStatusCode().value();
                String statusMessage = (String)Condition.checkNull((Object)HttpStatus.resolve((int)statusCode), () -> "", s -> " " + s.getReasonPhrase());
                this.log(logger, "<-- " + statusCode + statusMessage + " " + request.url() + " (" + tookMs + "ms)");
                HttpHeaders responseHeaders = responseEntity.getHeaders();
                for (String name : responseHeaders.keySet()) {
                    this.logHeader(logger, responseHeaders, name);
                }
                String responseBody = (String)responseEntity.getBody();
                if (!this.promisesBody(request.method(), (ResponseEntity<?>)responseEntity)) {
                    this.log(logger, "<-- END HTTP");
                } else if (this.bodyHasUnknownEncoding(responseHeaders)) {
                    this.log(logger, "<-- END HTTP (encoded body omitted)");
                } else {
                    MediaType contentType = responseHeaders.getContentType();
                    Charset charset = (Charset)Condition.checkNull((Object)contentType, () -> StandardCharsets.UTF_8, MimeType::getCharset);
                    int responseLength = ((byte[])Condition.nullThen((Object)Bytes.bytes((String)responseBody, (Charset)charset), () -> new byte[0])).length;
                    if ((long)responseLength != 0L) {
                        this.log(logger, "");
                        this.log(logger, responseBody);
                    }
                    this.log(logger, "<-- END HTTP (" + responseLength + "-byte body)");
                }
                if (Objects.nonNull(responseBody)) {
                    builder.body(responseBody);
                }
                return builder.build();
            });
        });
    }

    private void logHeader(Logger logger, HttpHeaders headers, String name) {
        this.log(logger, name + ": " + String.join((CharSequence)", ", headers.getOrEmpty((Object)name)));
    }

    private boolean bodyHasUnknownEncoding(HttpHeaders headers) {
        String contentEncoding = headers.getFirst("Content-Encoding");
        if (Objects.isNull(contentEncoding)) {
            return false;
        }
        return !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip");
    }

    private boolean promisesBody(HttpMethod httpMethod, ResponseEntity<?> response) {
        if (httpMethod == HttpMethod.HEAD) {
            return false;
        }
        int responseCode = response.getStatusCode().value();
        if ((responseCode < com.github.charlemaznable.httpclient.common.HttpStatus.CONTINUE.value() || responseCode >= 200) && responseCode != com.github.charlemaznable.httpclient.common.HttpStatus.NO_CONTENT.value() && responseCode != com.github.charlemaznable.httpclient.common.HttpStatus.NOT_MODIFIED.value()) {
            return true;
        }
        return response.getHeaders().getContentLength() != -1L || "chunked".equalsIgnoreCase(response.getHeaders().getFirst("Transfer-Encoding"));
    }

    private void log(Logger logger, String content) {
        logger.debug(content);
    }
}

