/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.ohclient;

import com.github.charlemaznable.core.context.FactoryContext;
import com.github.charlemaznable.core.lang.BuddyEnhancer;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Factory;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.core.lang.Reloadable;
import com.github.charlemaznable.core.spring.SpringFactory;
import com.github.charlemaznable.httpclient.ohclient.OhException;
import com.github.charlemaznable.httpclient.ohclient.enhancer.OhClientEnhancer;
import com.github.charlemaznable.httpclient.ohclient.internal.OhClass;
import com.github.charlemaznable.httpclient.ohclient.internal.OhDummy;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceMeterBinder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class OhFactory {
    private static final LoadingCache<Factory, OhLoader> ohLoaderCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(OhLoader::new));
    private static final CopyOnWriteArrayList<OhClientEnhancer> enhancers = StreamSupport.stream(ServiceLoader.load(OhClientEnhancer.class).spliterator(), false).sorted(Comparator.comparingInt(OhClientEnhancer::getOrder).reversed()).collect(Collectors.toCollection(CopyOnWriteArrayList::new));

    public static <T> T getClient(Class<T> ohClass) {
        return OhFactory.ohLoader(FactoryContext.get()).getClient(ohClass);
    }

    public static OhLoader springOhLoader() {
        return OhFactory.ohLoader((Factory)SpringFactory.springFactory());
    }

    public static OhLoader ohLoader(Factory factory) {
        return (OhLoader)LoadingCachee.get(ohLoaderCache, (Object)factory);
    }

    @Generated
    private OhFactory() {
    }

    public static class OhLoader {
        private final Factory factory;
        private final LoadingCache<Class<?>, Object> ohCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(this::loadClient));

        OhLoader(Factory factory) {
            this.factory = (Factory)Condition.checkNotNull((Object)factory);
        }

        public <T> T getClient(Class<T> ohClass) {
            return (T)LoadingCachee.get(this.ohCache, ohClass);
        }

        @Nonnull
        private <T> Object loadClient(@Nonnull Class<T> ohClass) {
            this.ensureClassIsAnInterface(ohClass);
            return this.wrapWithEnhancer(ohClass, BuddyEnhancer.create(OhDummy.class, (Object[])new Object[]{ohClass}, (Class[])new Class[]{ohClass, Reloadable.class, ResilienceMeterBinder.class}, invocation -> {
                if (invocation.getMethod().isDefault() || invocation.getMethod().getDeclaringClass().equals(OhDummy.class)) {
                    return 1;
                }
                return 0;
            }, (BuddyEnhancer.Delegate[])new BuddyEnhancer.Delegate[]{new OhClass(this.factory, ohClass), BuddyEnhancer.CALL_SUPER}));
        }

        private <T> void ensureClassIsAnInterface(Class<T> clazz) {
            if (clazz.isInterface()) {
                return;
            }
            throw new OhException(clazz + " is not An Interface");
        }

        private <T> Object wrapWithEnhancer(Class<T> ohClass, Object impl) {
            Object enhancedImpl = impl;
            for (OhClientEnhancer enhancer : enhancers) {
                if (!enhancer.isEnabled(ohClass)) continue;
                enhancedImpl = enhancer.build(ohClass, enhancedImpl);
            }
            return enhancedImpl;
        }
    }
}

