/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.ohclient;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.CommonReq;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpMethod;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.github.charlemaznable.httpclient.ohclient.elf.GlobalClientElf;
import com.github.charlemaznable.httpclient.ohclient.internal.OhCallbackFuture;
import com.github.charlemaznable.httpclient.ohclient.internal.OhResponseBody;
import java.net.Proxy;
import java.net.ProxySelector;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.functions.Function1;
import lombok.Generated;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.tls.CertificateChainCleaner;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.lambda.Sneaky;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class OhReq
extends CommonReq<OhReq> {
    private static final OkHttpClient globalClient = GlobalClientElf.globalClient();
    private final OkHttpClient.Builder builder = new OkHttpClient.Builder();

    public OhReq() {
    }

    public OhReq(String baseUrl) {
        super(baseUrl);
    }

    public OkHttpClient buildHttpClient() {
        OkHttpClient buildClient = (OkHttpClient)Condition.notNullThen((Object)this.builder, OkHttpClient.Builder::build);
        return (OkHttpClient)Condition.nullThen((Object)buildClient, () -> globalClient);
    }

    public Instance buildInstance() {
        return new Instance(this, this.buildHttpClient());
    }

    public String get() {
        return this.buildInstance().get();
    }

    public String post() {
        return this.buildInstance().post();
    }

    public CompletableFuture<String> getFuture() {
        return this.buildInstance().getFuture();
    }

    public CompletableFuture<String> postFuture() {
        return this.buildInstance().postFuture();
    }

    @Generated
    public Dispatcher getDispatcher$okhttp() {
        return this.builder.getDispatcher$okhttp();
    }

    @Generated
    public void setDispatcher$okhttp(Dispatcher dispatcher) {
        this.builder.setDispatcher$okhttp(dispatcher);
    }

    @Generated
    public ConnectionPool getConnectionPool$okhttp() {
        return this.builder.getConnectionPool$okhttp();
    }

    @Generated
    public void setConnectionPool$okhttp(ConnectionPool connectionPool) {
        this.builder.setConnectionPool$okhttp(connectionPool);
    }

    @Generated
    public List<Interceptor> getInterceptors$okhttp() {
        return this.builder.getInterceptors$okhttp();
    }

    @Generated
    public List<Interceptor> getNetworkInterceptors$okhttp() {
        return this.builder.getNetworkInterceptors$okhttp();
    }

    @Generated
    public EventListener.Factory getEventListenerFactory$okhttp() {
        return this.builder.getEventListenerFactory$okhttp();
    }

    @Generated
    public void setEventListenerFactory$okhttp(EventListener.Factory factory) {
        this.builder.setEventListenerFactory$okhttp(factory);
    }

    @Generated
    public boolean getRetryOnConnectionFailure$okhttp() {
        return this.builder.getRetryOnConnectionFailure$okhttp();
    }

    @Generated
    public void setRetryOnConnectionFailure$okhttp(boolean bl) {
        this.builder.setRetryOnConnectionFailure$okhttp(bl);
    }

    @Generated
    public Authenticator getAuthenticator$okhttp() {
        return this.builder.getAuthenticator$okhttp();
    }

    @Generated
    public void setAuthenticator$okhttp(Authenticator authenticator) {
        this.builder.setAuthenticator$okhttp(authenticator);
    }

    @Generated
    public boolean getFollowRedirects$okhttp() {
        return this.builder.getFollowRedirects$okhttp();
    }

    @Generated
    public void setFollowRedirects$okhttp(boolean bl) {
        this.builder.setFollowRedirects$okhttp(bl);
    }

    @Generated
    public boolean getFollowSslRedirects$okhttp() {
        return this.builder.getFollowSslRedirects$okhttp();
    }

    @Generated
    public void setFollowSslRedirects$okhttp(boolean bl) {
        this.builder.setFollowSslRedirects$okhttp(bl);
    }

    @Generated
    public CookieJar getCookieJar$okhttp() {
        return this.builder.getCookieJar$okhttp();
    }

    @Generated
    public void setCookieJar$okhttp(CookieJar cookieJar) {
        this.builder.setCookieJar$okhttp(cookieJar);
    }

    @Generated
    public Cache getCache$okhttp() {
        return this.builder.getCache$okhttp();
    }

    @Generated
    public void setCache$okhttp(Cache cache) {
        this.builder.setCache$okhttp(cache);
    }

    @Generated
    public Dns getDns$okhttp() {
        return this.builder.getDns$okhttp();
    }

    @Generated
    public void setDns$okhttp(Dns dns) {
        this.builder.setDns$okhttp(dns);
    }

    @Generated
    public Proxy getProxy$okhttp() {
        return this.builder.getProxy$okhttp();
    }

    @Generated
    public void setProxy$okhttp(Proxy proxy) {
        this.builder.setProxy$okhttp(proxy);
    }

    @Generated
    public ProxySelector getProxySelector$okhttp() {
        return this.builder.getProxySelector$okhttp();
    }

    @Generated
    public void setProxySelector$okhttp(ProxySelector proxySelector) {
        this.builder.setProxySelector$okhttp(proxySelector);
    }

    @Generated
    public Authenticator getProxyAuthenticator$okhttp() {
        return this.builder.getProxyAuthenticator$okhttp();
    }

    @Generated
    public void setProxyAuthenticator$okhttp(Authenticator authenticator) {
        this.builder.setProxyAuthenticator$okhttp(authenticator);
    }

    @Generated
    public SocketFactory getSocketFactory$okhttp() {
        return this.builder.getSocketFactory$okhttp();
    }

    @Generated
    public void setSocketFactory$okhttp(SocketFactory socketFactory) {
        this.builder.setSocketFactory$okhttp(socketFactory);
    }

    @Generated
    public SSLSocketFactory getSslSocketFactoryOrNull$okhttp() {
        return this.builder.getSslSocketFactoryOrNull$okhttp();
    }

    @Generated
    public void setSslSocketFactoryOrNull$okhttp(SSLSocketFactory sSLSocketFactory) {
        this.builder.setSslSocketFactoryOrNull$okhttp(sSLSocketFactory);
    }

    @Generated
    public X509TrustManager getX509TrustManagerOrNull$okhttp() {
        return this.builder.getX509TrustManagerOrNull$okhttp();
    }

    @Generated
    public void setX509TrustManagerOrNull$okhttp(X509TrustManager x509TrustManager) {
        this.builder.setX509TrustManagerOrNull$okhttp(x509TrustManager);
    }

    @Generated
    public List<ConnectionSpec> getConnectionSpecs$okhttp() {
        return this.builder.getConnectionSpecs$okhttp();
    }

    @Generated
    public void setConnectionSpecs$okhttp(List<ConnectionSpec> list) {
        this.builder.setConnectionSpecs$okhttp(list);
    }

    @Generated
    public List<Protocol> getProtocols$okhttp() {
        return this.builder.getProtocols$okhttp();
    }

    @Generated
    public void setProtocols$okhttp(List<? extends Protocol> list) {
        this.builder.setProtocols$okhttp(list);
    }

    @Generated
    public HostnameVerifier getHostnameVerifier$okhttp() {
        return this.builder.getHostnameVerifier$okhttp();
    }

    @Generated
    public void setHostnameVerifier$okhttp(HostnameVerifier hostnameVerifier) {
        this.builder.setHostnameVerifier$okhttp(hostnameVerifier);
    }

    @Generated
    public CertificatePinner getCertificatePinner$okhttp() {
        return this.builder.getCertificatePinner$okhttp();
    }

    @Generated
    public void setCertificatePinner$okhttp(CertificatePinner certificatePinner) {
        this.builder.setCertificatePinner$okhttp(certificatePinner);
    }

    @Generated
    public CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.builder.getCertificateChainCleaner$okhttp();
    }

    @Generated
    public void setCertificateChainCleaner$okhttp(CertificateChainCleaner certificateChainCleaner) {
        this.builder.setCertificateChainCleaner$okhttp(certificateChainCleaner);
    }

    @Generated
    public int getCallTimeout$okhttp() {
        return this.builder.getCallTimeout$okhttp();
    }

    @Generated
    public void setCallTimeout$okhttp(int n) {
        this.builder.setCallTimeout$okhttp(n);
    }

    @Generated
    public int getConnectTimeout$okhttp() {
        return this.builder.getConnectTimeout$okhttp();
    }

    @Generated
    public void setConnectTimeout$okhttp(int n) {
        this.builder.setConnectTimeout$okhttp(n);
    }

    @Generated
    public int getReadTimeout$okhttp() {
        return this.builder.getReadTimeout$okhttp();
    }

    @Generated
    public void setReadTimeout$okhttp(int n) {
        this.builder.setReadTimeout$okhttp(n);
    }

    @Generated
    public int getWriteTimeout$okhttp() {
        return this.builder.getWriteTimeout$okhttp();
    }

    @Generated
    public void setWriteTimeout$okhttp(int n) {
        this.builder.setWriteTimeout$okhttp(n);
    }

    @Generated
    public int getPingInterval$okhttp() {
        return this.builder.getPingInterval$okhttp();
    }

    @Generated
    public void setPingInterval$okhttp(int n) {
        this.builder.setPingInterval$okhttp(n);
    }

    @Generated
    public long getMinWebSocketMessageToCompress$okhttp() {
        return this.builder.getMinWebSocketMessageToCompress$okhttp();
    }

    @Generated
    public void setMinWebSocketMessageToCompress$okhttp(long l) {
        this.builder.setMinWebSocketMessageToCompress$okhttp(l);
    }

    @Generated
    public RouteDatabase getRouteDatabase$okhttp() {
        return this.builder.getRouteDatabase$okhttp();
    }

    @Generated
    public void setRouteDatabase$okhttp(RouteDatabase routeDatabase) {
        this.builder.setRouteDatabase$okhttp(routeDatabase);
    }

    @Generated
    public OkHttpClient.Builder dispatcher(Dispatcher dispatcher) {
        return this.builder.dispatcher(dispatcher);
    }

    @Generated
    public OkHttpClient.Builder connectionPool(ConnectionPool connectionPool) {
        return this.builder.connectionPool(connectionPool);
    }

    @Generated
    public List<Interceptor> interceptors() {
        return this.builder.interceptors();
    }

    @Generated
    public OkHttpClient.Builder addInterceptor(Interceptor interceptor) {
        return this.builder.addInterceptor(interceptor);
    }

    @Generated
    public OkHttpClient.Builder -addInterceptor(Function1<? super Interceptor.Chain, Response> block) {
        return this.builder.-addInterceptor(block);
    }

    @Generated
    public List<Interceptor> networkInterceptors() {
        return this.builder.networkInterceptors();
    }

    @Generated
    public OkHttpClient.Builder addNetworkInterceptor(Interceptor interceptor) {
        return this.builder.addNetworkInterceptor(interceptor);
    }

    @Generated
    public OkHttpClient.Builder -addNetworkInterceptor(Function1<? super Interceptor.Chain, Response> block) {
        return this.builder.-addNetworkInterceptor(block);
    }

    @Generated
    public OkHttpClient.Builder eventListener(EventListener eventListener) {
        return this.builder.eventListener(eventListener);
    }

    @Generated
    public OkHttpClient.Builder eventListenerFactory(EventListener.Factory eventListenerFactory) {
        return this.builder.eventListenerFactory(eventListenerFactory);
    }

    @Generated
    public OkHttpClient.Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        return this.builder.retryOnConnectionFailure(retryOnConnectionFailure);
    }

    @Generated
    public OkHttpClient.Builder authenticator(Authenticator authenticator) {
        return this.builder.authenticator(authenticator);
    }

    @Generated
    public OkHttpClient.Builder followRedirects(boolean followRedirects) {
        return this.builder.followRedirects(followRedirects);
    }

    @Generated
    public OkHttpClient.Builder followSslRedirects(boolean followProtocolRedirects) {
        return this.builder.followSslRedirects(followProtocolRedirects);
    }

    @Generated
    public OkHttpClient.Builder cookieJar(CookieJar cookieJar) {
        return this.builder.cookieJar(cookieJar);
    }

    @Generated
    public OkHttpClient.Builder cache(Cache cache) {
        return this.builder.cache(cache);
    }

    @Generated
    public OkHttpClient.Builder dns(Dns dns) {
        return this.builder.dns(dns);
    }

    @Generated
    public OkHttpClient.Builder proxy(Proxy proxy) {
        return this.builder.proxy(proxy);
    }

    @Generated
    public OkHttpClient.Builder proxySelector(ProxySelector proxySelector) {
        return this.builder.proxySelector(proxySelector);
    }

    @Generated
    public OkHttpClient.Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
        return this.builder.proxyAuthenticator(proxyAuthenticator);
    }

    @Generated
    public OkHttpClient.Builder socketFactory(SocketFactory socketFactory) {
        return this.builder.socketFactory(socketFactory);
    }

    @Deprecated
    @Generated
    public OkHttpClient.Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return this.builder.sslSocketFactory(sslSocketFactory);
    }

    @Generated
    public OkHttpClient.Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        return this.builder.sslSocketFactory(sslSocketFactory, trustManager);
    }

    @Generated
    public OkHttpClient.Builder connectionSpecs(List<ConnectionSpec> connectionSpecs) {
        return this.builder.connectionSpecs(connectionSpecs);
    }

    @Generated
    public OkHttpClient.Builder protocols(List<? extends Protocol> protocols) {
        return this.builder.protocols(protocols);
    }

    @Generated
    public OkHttpClient.Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        return this.builder.hostnameVerifier(hostnameVerifier);
    }

    @Generated
    public OkHttpClient.Builder certificatePinner(CertificatePinner certificatePinner) {
        return this.builder.certificatePinner(certificatePinner);
    }

    @Generated
    public OkHttpClient.Builder callTimeout(long timeout, TimeUnit unit) {
        return this.builder.callTimeout(timeout, unit);
    }

    @Generated
    public OkHttpClient.Builder callTimeout(Duration duration) {
        return this.builder.callTimeout(duration);
    }

    @Generated
    public OkHttpClient.Builder connectTimeout(long timeout, TimeUnit unit) {
        return this.builder.connectTimeout(timeout, unit);
    }

    @Generated
    public OkHttpClient.Builder connectTimeout(Duration duration) {
        return this.builder.connectTimeout(duration);
    }

    @Generated
    public OkHttpClient.Builder readTimeout(long timeout, TimeUnit unit) {
        return this.builder.readTimeout(timeout, unit);
    }

    @Generated
    public OkHttpClient.Builder readTimeout(Duration duration) {
        return this.builder.readTimeout(duration);
    }

    @Generated
    public OkHttpClient.Builder writeTimeout(long timeout, TimeUnit unit) {
        return this.builder.writeTimeout(timeout, unit);
    }

    @Generated
    public OkHttpClient.Builder writeTimeout(Duration duration) {
        return this.builder.writeTimeout(duration);
    }

    @Generated
    public OkHttpClient.Builder pingInterval(long interval, TimeUnit unit) {
        return this.builder.pingInterval(interval, unit);
    }

    @Generated
    public OkHttpClient.Builder pingInterval(Duration duration) {
        return this.builder.pingInterval(duration);
    }

    @Generated
    public OkHttpClient.Builder minWebSocketMessageToCompress(long bytes) {
        return this.builder.minWebSocketMessageToCompress(bytes);
    }

    @Generated
    public OkHttpClient build() {
        return this.builder.build();
    }

    public static final class Instance
    extends CommonReq.Instance<Instance> {
        private final OkHttpClient httpClient;

        public <U extends CommonReq<U>> Instance(CommonReq<U> other, OkHttpClient httpClient) {
            super(other);
            this.httpClient = httpClient;
        }

        @Override
        public Instance copy() {
            return new Instance(this, this.httpClient);
        }

        public String get() {
            return this.execute(this::buildGetRequest);
        }

        public String post() {
            return this.execute(this::buildPostRequest);
        }

        public CompletableFuture<String> getFuture() {
            return this.enqueue(this::buildGetRequest);
        }

        public CompletableFuture<String> postFuture() {
            return this.enqueue(this::buildPostRequest);
        }

        private String execute(Supplier<Request> requestSupplier) {
            return this.processResponse(this.httpClient.newCall(requestSupplier.get()).execute());
        }

        private CompletableFuture<String> enqueue(Supplier<Request> requestSupplier) {
            OhCallbackFuture<String> future = new OhCallbackFuture<String>(this::processResponse);
            this.httpClient.newCall(requestSupplier.get()).enqueue(future);
            return future;
        }

        private Request buildGetRequest() {
            Map<String, Object> parameterMap = this.fetchParameterMap();
            String requestUrl = this.concatRequestUrl(parameterMap);
            Headers.Builder headersBuilder = this.buildHeadersBuilder();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.headers(headersBuilder.build());
            requestBuilder.method(HttpMethod.GET.toString(), null);
            String query = CommonConstant.URL_QUERY_FORMATTER.format(parameterMap, Mapp.newHashMap());
            requestBuilder.url(Url.concatUrlQuery((String)requestUrl, (String)query));
            return requestBuilder.build();
        }

        private Request buildPostRequest() {
            Map<String, Object> parameterMap = this.fetchParameterMap();
            String requestUrl = this.concatRequestUrl(parameterMap);
            Headers.Builder headersBuilder = this.buildHeadersBuilder();
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.headers(headersBuilder.build());
            String content = (String)Condition.nullThen((Object)this.requestBody, () -> this.contentFormatter().format(parameterMap, Mapp.newHashMap()));
            String contentType = (String)Condition.nullThen((Object)headersBuilder.get("Content-Type"), CommonConstant.DEFAULT_CONTENT_FORMATTER::contentType);
            requestBuilder.method(HttpMethod.POST.toString(), RequestBody.create((String)content, (MediaType)MediaType.parse((String)contentType)));
            requestBuilder.url(requestUrl);
            return requestBuilder.build();
        }

        private Headers.Builder buildHeadersBuilder() {
            Headers.Builder headersBuilder = new Headers.Builder();
            String acceptCharsetName = this.acceptCharset().name();
            headersBuilder.set("Accept-Charset", acceptCharsetName);
            String contentType = this.contentFormatter().contentType();
            headersBuilder.set("Content-Type", contentType);
            for (Pair<String, String> header : this.headers()) {
                Condition.checkNull((Object)((String)header.getValue()), () -> headersBuilder.removeAll((String)header.getKey()), xx -> headersBuilder.set((String)header.getKey(), (String)header.getValue()));
            }
            return headersBuilder;
        }

        private String processResponse(Response response) {
            FallbackFunction<?> statusFallback;
            int statusCode = response.code();
            OhResponseBody responseBody = (OhResponseBody)((Object)Condition.notNullThen((Object)response.body(), OhResponseBody::new));
            if (Objects.nonNull(response.body())) {
                response.close();
            }
            if (Objects.nonNull(statusFallback = this.statusFallbackMapping().get((Object)HttpStatus.valueOf(statusCode)))) {
                return this.applyFallback(statusFallback, statusCode, responseBody);
            }
            FallbackFunction<?> statusSeriesFallback = this.statusSeriesFallbackMapping().get((Object)HttpStatus.Series.valueOf(statusCode));
            if (Objects.nonNull(statusSeriesFallback)) {
                return this.applyFallback(statusSeriesFallback, statusCode, responseBody);
            }
            return (String)Condition.notNullThen((Object)((Object)responseBody), (Function)Sneaky.function(ResponseBody::string));
        }

        private String applyFallback(FallbackFunction<?> function, int statusCode, ResponseBody responseBody) {
            return Str.toStr(function.apply(new FallbackFunction.Response<ResponseBody>(statusCode, responseBody){

                @Override
                public String responseBodyAsString() {
                    return Str.toStr((Object)Condition.notNullThen((Object)((ResponseBody)this.getResponseBody()), (Function)Sneaky.function(ResponseBody::string)));
                }
            }));
        }
    }
}

