/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.ohclient.elf;

import com.github.charlemaznable.httpclient.logging.LoggingOhInterceptor;
import com.github.charlemaznable.httpclient.ohclient.elf.GlobalClientSupplier;
import com.github.charlemaznable.httpclient.westcache.WestCacheConstant;
import com.github.charlemaznable.httpclient.westcache.WestCacheOhInterceptor;
import java.util.Iterator;
import java.util.ServiceLoader;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class GlobalClientElf {
    private static final OkHttpClient instance = GlobalClientElf.findSupplier().supply();

    public static OkHttpClient globalClient() {
        return instance;
    }

    private static GlobalClientSupplier findSupplier() {
        Iterator<GlobalClientSupplier> suppliers = ServiceLoader.load(GlobalClientSupplier.class).iterator();
        if (!suppliers.hasNext()) {
            return new DefaultGlobalClientSupplier();
        }
        GlobalClientSupplier result = suppliers.next();
        if (suppliers.hasNext()) {
            throw new IllegalStateException("Multiple GlobalClientSupplier Found");
        }
        return result;
    }

    @Generated
    private GlobalClientElf() {
    }

    public static class DefaultGlobalClientSupplier
    implements GlobalClientSupplier {
        @Override
        public OkHttpClient supply() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.addInterceptor((Interceptor)new LoggingOhInterceptor());
            if (WestCacheConstant.HAS_WESTCACHE) {
                builder.addInterceptor((Interceptor)new WestCacheOhInterceptor());
            }
            return builder.build();
        }
    }
}

