/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.ohclient.internal;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.CommonExecute;
import com.github.charlemaznable.httpclient.ohclient.elf.RequestBuilderConfigElf;
import com.github.charlemaznable.httpclient.ohclient.internal.OhBase;
import com.github.charlemaznable.httpclient.ohclient.internal.OhCallbackFuture;
import com.github.charlemaznable.httpclient.ohclient.internal.OhMethod;
import com.github.charlemaznable.httpclient.ohclient.internal.OhResponseBody;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSource;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.lambda.Sneaky;

final class OhExecute
extends CommonExecute<OhBase, OhMethod, Response, ResponseBody> {
    public OhExecute(OhMethod ohMethod) {
        super(new OhBase((OhBase)ohMethod.element().base()), ohMethod);
    }

    @Override
    protected boolean processParameterType(Object argument, Class<?> parameterType) {
        if (argument instanceof OkHttpClient) {
            OkHttpClient client;
            ((OhBase)this.base()).client = client = (OkHttpClient)argument;
            return true;
        }
        return super.processParameterType(argument, parameterType);
    }

    @Override
    public Object execute() {
        CompletableFuture<Object> completableFuture = this.decorateAsyncExecute(() -> {
            OhCallbackFuture<Object> future = new OhCallbackFuture<Object>(this::processResponse);
            ((OhBase)this.base()).client.newCall(this.buildRequest()).enqueue(future);
            return future;
        });
        if (((OhMethod)this.executeMethod()).returnFuture()) {
            return this.adaptationFromFuture(completableFuture);
        }
        return this.getFromFuture(completableFuture);
    }

    private Request buildRequest() {
        Request.Builder requestBuilder = new Request.Builder();
        Condition.notNullThenRun((Object)((OhBase)this.base()).requestExtender(), extender -> extender.extend(((OhBase)this.base()).headers(), ((OhBase)this.base()).pathVars(), ((OhBase)this.base()).parameters(), ((OhBase)this.base()).contexts()));
        Headers.Builder headersBuilder = new Headers.Builder();
        String acceptCharsetName = ((OhBase)this.base()).acceptCharset().name();
        headersBuilder.set("Accept-Charset", acceptCharsetName);
        String contentType = ((OhBase)this.base()).contentFormatter().contentType();
        headersBuilder.set("Content-Type", contentType);
        for (Pair<String, String> header : ((OhBase)this.base()).headers()) {
            Condition.checkNull((Object)((String)header.getValue()), () -> headersBuilder.removeAll((String)header.getKey()), xx -> headersBuilder.set((String)header.getKey(), (String)header.getValue()));
        }
        requestBuilder.headers(headersBuilder.build());
        CommonExecute.CommonExecuteParams executeParams = this.buildCommonExecuteParams();
        if (!HttpMethod.permitsRequestBody((String)executeParams.requestMethod())) {
            requestBuilder.method(executeParams.requestMethod(), null);
            String query = CommonConstant.URL_QUERY_FORMATTER.format(executeParams.parameterMap(), executeParams.contextMap());
            requestBuilder.url(Url.concatUrlQuery((String)executeParams.requestUrl(), (String)query));
        } else {
            String content = (String)Condition.nullThen((Object)this.requestBodyRaw(), () -> ((OhBase)this.base()).contentFormatter().format(executeParams.parameterMap(), executeParams.contextMap()));
            String contentTypeHeader = (String)Condition.nullThen((Object)headersBuilder.get("Content-Type"), CommonConstant.DEFAULT_CONTENT_FORMATTER::contentType);
            requestBuilder.method(executeParams.requestMethod(), RequestBody.create((String)content, (MediaType)MediaType.parse((String)contentTypeHeader)));
            requestBuilder.url(executeParams.requestUrl());
        }
        RequestBuilderConfigElf.configRequestBuilder(requestBuilder, this);
        return requestBuilder.build();
    }

    @Override
    protected int getResponseCode(Response response) {
        return response.code();
    }

    @Override
    protected ResponseBody getResponseBody(Response response) {
        OhResponseBody responseBody = (OhResponseBody)((Object)Condition.notNullThen((Object)response.body(), OhResponseBody::new));
        if (Objects.nonNull(response.body())) {
            response.close();
        }
        return responseBody;
    }

    @Override
    protected String getResponseBodyString(ResponseBody responseBody) {
        return responseBody.string();
    }

    @Override
    protected Object customProcessReturnTypeValue(int statusCode, ResponseBody responseBody, Class<?> returnType) {
        if (ResponseBody.class == returnType) {
            return responseBody;
        }
        if (InputStream.class == returnType) {
            return Condition.notNullThen((Object)responseBody, ResponseBody::byteStream);
        }
        if (BufferedSource.class == returnType) {
            return Condition.notNullThen((Object)responseBody, ResponseBody::source);
        }
        if (byte[].class == returnType) {
            return Condition.notNullThen((Object)responseBody, (Function)Sneaky.function(ResponseBody::bytes));
        }
        if (Reader.class == returnType) {
            return Condition.notNullThen((Object)responseBody, ResponseBody::charStream);
        }
        return super.customProcessReturnTypeValue(statusCode, responseBody, returnType);
    }

    private Object getFromFuture(Future<Object> future) {
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            throw (Throwable)Objects.requireNonNullElse(e.getCause(), e);
        }
    }
}

