/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.ohclient.internal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public final class OhResponseBody
extends ResponseBody {
    private final MediaType contentType;
    private final long contentLength;
    private final Buffer buffer;

    public OhResponseBody(ResponseBody responseBody) {
        this.contentType = responseBody.contentType();
        this.contentLength = responseBody.contentLength();
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        this.buffer = source.getBuffer().clone();
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    @Nonnull
    public BufferedSource source() {
        return this.buffer.clone();
    }
}

