/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.annotation;

import com.github.charlemaznable.httpclient.resilience.function.ResilienceCircuitBreakerRecover;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Inherited
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ResilienceCircuitBreaker {
    public String name() default "";

    public CircuitBreakerConfig.SlidingWindowType slidingWindowType() default CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;

    public int slidingWindowSize() default 100;

    public int minimumNumberOfCalls() default 100;

    public float failureRateThreshold() default 50.0f;

    public float slowCallRateThreshold() default 100.0f;

    public int slowCallDurationThresholdInSeconds() default 60;

    public boolean automaticTransitionFromOpenToHalfOpenEnabled() default false;

    public int waitDurationInOpenStateInSeconds() default 60;

    public int permittedNumberOfCallsInHalfOpenState() default 10;

    public int maxWaitDurationInHalfOpenStateInSeconds() default 0;

    public Class<? extends ResilienceCircuitBreakerRecover> fallback() default ResilienceCircuitBreakerRecover.class;
}

