/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.common;

import com.github.charlemaznable.httpclient.resilience.function.ResilienceBulkheadRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceCircuitBreakerRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceRateLimiterRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceTimeLimiterRecover;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetricsPublisher;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetricsPublisher;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetricsPublisher;
import io.github.resilience4j.micrometer.tagged.TaggedRetryMetricsPublisher;
import io.github.resilience4j.micrometer.tagged.TaggedTimeLimiterMetricsPublisher;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.DefaultEventLoop;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import lombok.Generated;

public final class ResilienceBase {
    Bulkhead bulkhead;
    ResilienceBulkheadRecover<?> bulkheadRecover;
    TimeLimiter timeLimiter;
    ResilienceTimeLimiterRecover<?> timeLimiterRecover;
    RateLimiter rateLimiter;
    ResilienceRateLimiterRecover<?> rateLimiterRecover;
    CircuitBreaker circuitBreaker;
    ResilienceCircuitBreakerRecover<?> circuitBreakerRecover;
    Retry retry;
    ScheduledExecutorService retryExecutor = new DefaultEventLoop();
    ResilienceRecover<?> recover;
    MeterRegistry meterRegistry;

    public ResilienceBase(ResilienceBase other) {
        this.bulkhead = other.bulkhead;
        this.bulkheadRecover = other.bulkheadRecover;
        this.timeLimiter = other.timeLimiter;
        this.timeLimiterRecover = other.timeLimiterRecover;
        this.rateLimiter = other.rateLimiter;
        this.rateLimiterRecover = other.rateLimiterRecover;
        this.circuitBreaker = other.circuitBreaker;
        this.circuitBreakerRecover = other.circuitBreakerRecover;
        this.retry = other.retry;
        this.retryExecutor = other.retryExecutor;
        this.recover = other.recover;
        this.meterRegistry = other.meterRegistry;
    }

    void publishBulkheadMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.bulkhead, (m, b) -> new TaggedBulkheadMetricsPublisher(m).publishMetrics(b));
    }

    void removeBulkheadMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.bulkhead, (m, b) -> new TaggedBulkheadMetricsPublisher(m).removeMetrics(b));
    }

    void publishTimeLimiterMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.timeLimiter, (m, t) -> new TaggedTimeLimiterMetricsPublisher(m).publishMetrics(t));
    }

    void removeTimeLimiterMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.timeLimiter, (m, t) -> new TaggedTimeLimiterMetricsPublisher(m).removeMetrics(t));
    }

    void publishRateLimiterMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.rateLimiter, (m, r) -> new TaggedRateLimiterMetricsPublisher(m).publishMetrics(r));
    }

    void removeRateLimiterMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.rateLimiter, (m, r) -> new TaggedRateLimiterMetricsPublisher(m).removeMetrics(r));
    }

    void publishCircuitBreakerMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.circuitBreaker, (m, c) -> new TaggedCircuitBreakerMetricsPublisher(m).publishMetrics(c));
    }

    void removeCircuitBreakerMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.circuitBreaker, (m, c) -> new TaggedCircuitBreakerMetricsPublisher(m).removeMetrics(c));
    }

    void publishRetryMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.retry, (m, r) -> new TaggedRetryMetricsPublisher(m).publishMetrics(r));
    }

    void removeRetryMetrics() {
        ResilienceBase.notNullThenBiRun(this.meterRegistry, this.retry, (m, r) -> new TaggedRetryMetricsPublisher(m).removeMetrics(r));
    }

    private static <T, U> void notNullThenBiRun(T t, U u, BiConsumer<T, U> biConsumer) {
        if (Objects.isNull(t) || Objects.isNull(u)) {
            return;
        }
        biConsumer.accept(t, u);
    }

    @Generated
    public ResilienceBase() {
    }

    @Generated
    public Bulkhead bulkhead() {
        return this.bulkhead;
    }

    @Generated
    public ResilienceBulkheadRecover<?> bulkheadRecover() {
        return this.bulkheadRecover;
    }

    @Generated
    public TimeLimiter timeLimiter() {
        return this.timeLimiter;
    }

    @Generated
    public ResilienceTimeLimiterRecover<?> timeLimiterRecover() {
        return this.timeLimiterRecover;
    }

    @Generated
    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    @Generated
    public ResilienceRateLimiterRecover<?> rateLimiterRecover() {
        return this.rateLimiterRecover;
    }

    @Generated
    public CircuitBreaker circuitBreaker() {
        return this.circuitBreaker;
    }

    @Generated
    public ResilienceCircuitBreakerRecover<?> circuitBreakerRecover() {
        return this.circuitBreakerRecover;
    }

    @Generated
    public Retry retry() {
        return this.retry;
    }

    @Generated
    public ScheduledExecutorService retryExecutor() {
        return this.retryExecutor;
    }

    @Generated
    public ResilienceRecover<?> recover() {
        return this.recover;
    }

    @Generated
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Generated
    public ResilienceBase bulkhead(Bulkhead bulkhead) {
        this.bulkhead = bulkhead;
        return this;
    }

    @Generated
    public ResilienceBase timeLimiter(TimeLimiter timeLimiter) {
        this.timeLimiter = timeLimiter;
        return this;
    }

    @Generated
    public ResilienceBase rateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    @Generated
    public ResilienceBase circuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
        return this;
    }

    @Generated
    public ResilienceBase retry(Retry retry) {
        this.retry = retry;
        return this;
    }
}

