/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.common;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceBase;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.CompletionStageUtils;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.netty.channel.DefaultEventLoop;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ResilienceDecorators {
    public static <T> DecorateCompletionStage<T> ofCompletionStage(Supplier<CompletionStage<T>> stageSupplier) {
        return new DecorateCompletionStage<T>(stageSupplier);
    }

    public static class DecorateCompletionStage<T> {
        private static final ScheduledExecutorService timeLimiterScheduler = new DefaultEventLoop();
        private Supplier<CompletionStage<T>> stageSupplier;

        public DecorateCompletionStage(Supplier<CompletionStage<T>> stageSupplier) {
            this.stageSupplier = stageSupplier;
        }

        public DecorateCompletionStage<T> withResilienceBase(ResilienceBase base) {
            return this.withBulkhead(base.bulkhead, base.bulkheadRecover).withTimeLimiter(base.timeLimiter, base.timeLimiterRecover).withRateLimiter(base.rateLimiter, base.rateLimiterRecover).withCircuitBreaker(base.circuitBreaker, base.circuitBreakerRecover).withRetry(base.retry, base.retryExecutor).withRecover(base.recover);
        }

        private DecorateCompletionStage<T> withBulkhead(Bulkhead bulkhead, Function<BulkheadFullException, ?> bulkheadRecover) {
            Condition.notNullThenRun((Object)bulkhead, b -> {
                this.stageSupplier = Bulkhead.decorateCompletionStage((Bulkhead)b, this.stageSupplier);
                Condition.notNullThenRun((Object)bulkheadRecover, br -> {
                    this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, BulkheadFullException.class, DecorateCompletionStage.fallback(BulkheadFullException.class, DecorateCompletionStage.cast(br)));
                });
            });
            return this;
        }

        private DecorateCompletionStage<T> withTimeLimiter(TimeLimiter timeLimiter, Function<TimeoutException, ?> timeLimiterRecover) {
            Condition.notNullThenRun((Object)timeLimiter, t -> {
                this.stageSupplier = TimeLimiter.decorateCompletionStage((TimeLimiter)t, (ScheduledExecutorService)timeLimiterScheduler, this.stageSupplier);
                Condition.notNullThenRun((Object)timeLimiterRecover, tr -> {
                    this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, TimeoutException.class, DecorateCompletionStage.fallback(TimeoutException.class, DecorateCompletionStage.cast(tr)));
                });
            });
            return this;
        }

        private DecorateCompletionStage<T> withRateLimiter(RateLimiter rateLimiter, Function<RequestNotPermitted, ?> rateLimiterRecover) {
            Condition.notNullThenRun((Object)rateLimiter, r -> {
                this.stageSupplier = RateLimiter.decorateCompletionStage((RateLimiter)r, (int)1, this.stageSupplier);
                Condition.notNullThenRun((Object)rateLimiterRecover, rr -> {
                    this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, RequestNotPermitted.class, DecorateCompletionStage.fallback(RequestNotPermitted.class, DecorateCompletionStage.cast(rr)));
                });
            });
            return this;
        }

        private DecorateCompletionStage<T> withCircuitBreaker(CircuitBreaker circuitBreaker, Function<CallNotPermittedException, ?> circuitBreakerRecover) {
            Condition.notNullThenRun((Object)circuitBreaker, c -> {
                this.stageSupplier = CircuitBreaker.decorateCompletionStage((CircuitBreaker)c, this.stageSupplier);
                Condition.notNullThenRun((Object)circuitBreakerRecover, cr -> {
                    this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, CallNotPermittedException.class, DecorateCompletionStage.fallback(CallNotPermittedException.class, DecorateCompletionStage.cast(cr)));
                });
            });
            return this;
        }

        private DecorateCompletionStage<T> withRetry(Retry retry, ScheduledExecutorService scheduler) {
            Condition.notNullThenRun((Object)retry, r -> {
                this.stageSupplier = Retry.decorateCompletionStage((Retry)r, (ScheduledExecutorService)Objects.requireNonNull(scheduler), this.stageSupplier);
            });
            return this;
        }

        private DecorateCompletionStage<T> withRecover(Function<Throwable, ?> recover) {
            Condition.notNullThenRun(recover, r -> {
                this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, DecorateCompletionStage.cast(r));
            });
            return this;
        }

        public CompletionStage<T> get() {
            return this.stageSupplier.get();
        }

        private static <X, Y> Function<X, Y> cast(Function<X, ?> function) {
            return x -> function.apply(x);
        }

        private static <X extends Throwable, Y> Function<Throwable, Y> fallback(Class<X> exceptionType, Function<X, Y> function) {
            return throwable -> function.apply((Throwable)exceptionType.cast(throwable));
        }
    }
}

