/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.common;

import com.github.charlemaznable.core.context.FactoryContext;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Factory;
import com.github.charlemaznable.httpclient.configurer.Configurer;
import com.github.charlemaznable.httpclient.resilience.annotation.ResilienceBulkhead;
import com.github.charlemaznable.httpclient.resilience.annotation.ResilienceCircuitBreaker;
import com.github.charlemaznable.httpclient.resilience.annotation.ResilienceFallback;
import com.github.charlemaznable.httpclient.resilience.annotation.ResilienceRateLimiter;
import com.github.charlemaznable.httpclient.resilience.annotation.ResilienceRetry;
import com.github.charlemaznable.httpclient.resilience.annotation.ResilienceTimeLimiter;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceBase;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceBulkheadConfigurer;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceCircuitBreakerConfigurer;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceFallbackConfigurer;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceRateLimiterConfigurer;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceRetryConfigurer;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceTimeLimiterConfigurer;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceBulkheadRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceCircuitBreakerRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceRateLimiterRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceRecover;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceTimeLimiterRecover;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.DefaultEventLoop;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.springframework.core.annotation.AnnotatedElementUtils;

public final class ResilienceElement {
    final ResilienceBase base;
    final Factory factory;
    final Configurer configurer;

    public void initialize(AnnotatedElement element, ResilienceBase superBase) {
        this.base.removeBulkheadMetrics();
        this.base.removeTimeLimiterMetrics();
        this.base.removeRateLimiterMetrics();
        this.base.removeCircuitBreakerMetrics();
        this.base.removeRetryMetrics();
        this.base.bulkhead = this.buildBulkhead(element, superBase.bulkhead);
        this.base.bulkheadRecover = this.buildBulkheadRecover(element, superBase.bulkheadRecover);
        this.base.timeLimiter = this.buildTimeLimiter(element, superBase.timeLimiter);
        this.base.timeLimiterRecover = this.buildTimeLimiterRecover(element, superBase.timeLimiterRecover);
        this.base.rateLimiter = this.buildRateLimiter(element, superBase.rateLimiter);
        this.base.rateLimiterRecover = this.buildRateLimiterRecover(element, superBase.rateLimiterRecover);
        this.base.circuitBreaker = this.buildCircuitBreaker(element, superBase.circuitBreaker);
        this.base.circuitBreakerRecover = this.buildCircuitBreakerRecover(element, superBase.circuitBreakerRecover);
        this.base.retry = this.buildRetry(element, superBase.retry);
        this.base.retryExecutor = this.buildRetryExecutor(element, superBase.retryExecutor);
        this.base.recover = this.buildRecover(element, superBase.recover);
        this.base.meterRegistry = superBase.meterRegistry;
        this.base.publishBulkheadMetrics();
        this.base.publishTimeLimiterMetrics();
        this.base.publishRateLimiterMetrics();
        this.base.publishCircuitBreakerMetrics();
        this.base.publishRetryMetrics();
    }

    public void bindTo(MeterRegistry registry) {
        this.base.removeBulkheadMetrics();
        this.base.removeTimeLimiterMetrics();
        this.base.removeRateLimiterMetrics();
        this.base.removeCircuitBreakerMetrics();
        this.base.removeRetryMetrics();
        this.base.meterRegistry = registry;
        this.base.publishBulkheadMetrics();
        this.base.publishTimeLimiterMetrics();
        this.base.publishRateLimiterMetrics();
        this.base.publishCircuitBreakerMetrics();
        this.base.publishRetryMetrics();
    }

    private Bulkhead buildBulkhead(AnnotatedElement element, Bulkhead defaultValue) {
        String defaultName = "Bulkhead-" + this.defaultResilienceName(element);
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceBulkheadConfigurer) {
            ResilienceBulkheadConfigurer bulkheadConfigurer = (ResilienceBulkheadConfigurer)configurer;
            return bulkheadConfigurer.bulkhead(defaultName);
        }
        ResilienceBulkhead bulkhead = (ResilienceBulkhead)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceBulkhead.class);
        return (Bulkhead)Condition.checkNull((Object)bulkhead, () -> defaultValue, anno -> Bulkhead.of((String)Condition.blankThen((String)anno.name(), () -> defaultName), (BulkheadConfig)BulkheadConfig.custom().maxConcurrentCalls(anno.maxConcurrentCalls()).maxWaitDuration(Duration.ofMillis(anno.maxWaitDurationInMillis())).build()));
    }

    private ResilienceBulkheadRecover<?> buildBulkheadRecover(AnnotatedElement element, ResilienceBulkheadRecover<?> defaultValue) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceBulkheadConfigurer) {
            ResilienceBulkheadConfigurer bulkheadConfigurer = (ResilienceBulkheadConfigurer)configurer;
            return bulkheadConfigurer.bulkheadRecover();
        }
        ResilienceBulkhead bulkhead = (ResilienceBulkhead)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceBulkhead.class);
        return (ResilienceBulkheadRecover)Condition.checkNull((Object)bulkhead, () -> defaultValue, anno -> (ResilienceBulkheadRecover)FactoryContext.build((Factory)this.factory, anno.fallback()));
    }

    private TimeLimiter buildTimeLimiter(AnnotatedElement element, TimeLimiter defaultValue) {
        String defaultName = "TimeLimiter-" + this.defaultResilienceName(element);
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceTimeLimiterConfigurer) {
            ResilienceTimeLimiterConfigurer timeLimiterConfigurer = (ResilienceTimeLimiterConfigurer)configurer;
            return timeLimiterConfigurer.timeLimiter(defaultName);
        }
        ResilienceTimeLimiter timeLimiter = (ResilienceTimeLimiter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceTimeLimiter.class);
        return (TimeLimiter)Condition.checkNull((Object)timeLimiter, () -> defaultValue, anno -> TimeLimiter.of((String)Condition.blankThen((String)anno.name(), () -> defaultName), (TimeLimiterConfig)TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(anno.timeoutDurationInMillis())).build()));
    }

    private ResilienceTimeLimiterRecover<?> buildTimeLimiterRecover(AnnotatedElement element, ResilienceTimeLimiterRecover<?> defaultValue) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceTimeLimiterConfigurer) {
            ResilienceTimeLimiterConfigurer timeLimiterConfigurer = (ResilienceTimeLimiterConfigurer)configurer;
            return timeLimiterConfigurer.timeLimiterRecover();
        }
        ResilienceTimeLimiter timeLimiter = (ResilienceTimeLimiter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceTimeLimiter.class);
        return (ResilienceTimeLimiterRecover)Condition.checkNull((Object)timeLimiter, () -> defaultValue, anno -> (ResilienceTimeLimiterRecover)FactoryContext.build((Factory)this.factory, anno.fallback()));
    }

    private RateLimiter buildRateLimiter(AnnotatedElement element, RateLimiter defaultValue) {
        String defaultName = "RateLimiter-" + this.defaultResilienceName(element);
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceRateLimiterConfigurer) {
            ResilienceRateLimiterConfigurer rateLimiterConfigurer = (ResilienceRateLimiterConfigurer)configurer;
            return rateLimiterConfigurer.rateLimiter(defaultName);
        }
        ResilienceRateLimiter rateLimiter = (ResilienceRateLimiter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceRateLimiter.class);
        return (RateLimiter)Condition.checkNull((Object)rateLimiter, () -> defaultValue, anno -> RateLimiter.of((String)Condition.blankThen((String)anno.name(), () -> defaultName), (RateLimiterConfig)RateLimiterConfig.custom().limitForPeriod(anno.limitForPeriod()).limitRefreshPeriod(Duration.ofNanos(anno.limitRefreshPeriodInNanos())).timeoutDuration(Duration.ofMillis(anno.timeoutDurationInMillis())).build()));
    }

    private ResilienceRateLimiterRecover<?> buildRateLimiterRecover(AnnotatedElement element, ResilienceRateLimiterRecover<?> defaultValue) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceRateLimiterConfigurer) {
            ResilienceRateLimiterConfigurer rateLimiterConfigurer = (ResilienceRateLimiterConfigurer)configurer;
            return rateLimiterConfigurer.rateLimiterRecover();
        }
        ResilienceRateLimiter rateLimiter = (ResilienceRateLimiter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceRateLimiter.class);
        return (ResilienceRateLimiterRecover)Condition.checkNull((Object)rateLimiter, () -> defaultValue, anno -> (ResilienceRateLimiterRecover)FactoryContext.build((Factory)this.factory, anno.fallback()));
    }

    private CircuitBreaker buildCircuitBreaker(AnnotatedElement element, CircuitBreaker defaultValue) {
        String defaultName = "CircuitBreaker-" + this.defaultResilienceName(element);
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceCircuitBreakerConfigurer) {
            ResilienceCircuitBreakerConfigurer circuitBreakerConfigurer = (ResilienceCircuitBreakerConfigurer)configurer;
            return circuitBreakerConfigurer.circuitBreaker(defaultName);
        }
        ResilienceCircuitBreaker circuitBreaker = (ResilienceCircuitBreaker)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceCircuitBreaker.class);
        return (CircuitBreaker)Condition.checkNull((Object)circuitBreaker, () -> defaultValue, anno -> CircuitBreaker.of((String)Condition.blankThen((String)anno.name(), () -> defaultName), (CircuitBreakerConfig)CircuitBreakerConfig.custom().slidingWindow(anno.slidingWindowSize(), anno.minimumNumberOfCalls(), anno.slidingWindowType()).failureRateThreshold(anno.failureRateThreshold()).slowCallRateThreshold(anno.slowCallRateThreshold()).slowCallDurationThreshold(Duration.ofSeconds(anno.slowCallDurationThresholdInSeconds())).automaticTransitionFromOpenToHalfOpenEnabled(anno.automaticTransitionFromOpenToHalfOpenEnabled()).waitDurationInOpenState(Duration.ofSeconds(anno.waitDurationInOpenStateInSeconds())).permittedNumberOfCallsInHalfOpenState(anno.permittedNumberOfCallsInHalfOpenState()).maxWaitDurationInHalfOpenState(Duration.ofSeconds(anno.maxWaitDurationInHalfOpenStateInSeconds())).build()));
    }

    private ResilienceCircuitBreakerRecover<?> buildCircuitBreakerRecover(AnnotatedElement element, ResilienceCircuitBreakerRecover<?> defaultValue) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceCircuitBreakerConfigurer) {
            ResilienceCircuitBreakerConfigurer circuitBreakerConfigurer = (ResilienceCircuitBreakerConfigurer)configurer;
            return circuitBreakerConfigurer.circuitBreakerRecover();
        }
        ResilienceCircuitBreaker circuitBreaker = (ResilienceCircuitBreaker)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceCircuitBreaker.class);
        return (ResilienceCircuitBreakerRecover)Condition.checkNull((Object)circuitBreaker, () -> defaultValue, anno -> (ResilienceCircuitBreakerRecover)FactoryContext.build((Factory)this.factory, anno.fallback()));
    }

    private Retry buildRetry(AnnotatedElement element, Retry defaultValue) {
        String defaultName = "Retry-" + this.defaultResilienceName(element);
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceRetryConfigurer) {
            ResilienceRetryConfigurer retryConfigurer = (ResilienceRetryConfigurer)configurer;
            return retryConfigurer.retry(defaultName);
        }
        ResilienceRetry retry = (ResilienceRetry)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceRetry.class);
        return (Retry)Condition.checkNull((Object)retry, () -> defaultValue, anno -> Retry.of((String)Condition.blankThen((String)anno.name(), () -> defaultName), (RetryConfig)RetryConfig.custom().maxAttempts(anno.maxAttempts()).waitDuration(Duration.ofMillis(anno.waitDurationInMillis())).build()));
    }

    private ScheduledExecutorService buildRetryExecutor(AnnotatedElement element, ScheduledExecutorService defaultValue) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceRetryConfigurer) {
            ResilienceRetryConfigurer retryConfigurer = (ResilienceRetryConfigurer)configurer;
            return retryConfigurer.isolatedExecutor() ? new DefaultEventLoop() : defaultValue;
        }
        ResilienceRetry retry = (ResilienceRetry)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceRetry.class);
        return (ScheduledExecutorService)Condition.checkNull((Object)retry, () -> defaultValue, anno -> anno.isolatedExecutor() ? new DefaultEventLoop() : defaultValue);
    }

    private ResilienceRecover<?> buildRecover(AnnotatedElement element, ResilienceRecover<?> defaultValue) {
        Configurer configurer = this.configurer;
        if (configurer instanceof ResilienceFallbackConfigurer) {
            ResilienceFallbackConfigurer fallbackConfigurer = (ResilienceFallbackConfigurer)configurer;
            return fallbackConfigurer.recover();
        }
        ResilienceFallback fallback = (ResilienceFallback)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)element, ResilienceFallback.class);
        return (ResilienceRecover)Condition.checkNull((Object)fallback, () -> defaultValue, anno -> (ResilienceRecover)FactoryContext.build((Factory)this.factory, anno.value()));
    }

    private String defaultResilienceName(AnnotatedElement element) {
        if (element instanceof Class) {
            Class clazz = (Class)element;
            return clazz.getSimpleName();
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return method.getDeclaringClass().getSimpleName() + "#" + method.getName();
        }
        return "Unamed#" + Integer.toHexString(element.hashCode());
    }

    @Generated
    public ResilienceElement(ResilienceBase base, Factory factory, Configurer configurer) {
        this.base = base;
        this.factory = factory;
        this.configurer = configurer;
    }
}

