/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.configurer.configservice;

import com.github.charlemaznable.configservice.Config;
import com.github.charlemaznable.configservice.impl.Functions;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Objectt;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceBulkheadConfigurer;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceBulkheadRecover;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public interface ResilienceBulkheadConfig
extends ResilienceBulkheadConfigurer {
    @Config(value="enabledBulkhead")
    public String enabledBulkheadString();

    default public boolean enabledBulkhead() {
        return BooleanUtils.toBoolean((String)this.enabledBulkheadString());
    }

    @Config(value="bulkheadName")
    public String bulkheadName();

    @Config(value="maxConcurrentCalls")
    public String maxConcurrentCalls();

    default public int parseMaxConcurrentCalls() {
        return (Integer)Functions.parseStringToValue((String)this.maxConcurrentCalls(), (Object)25, (Function)Functions.TO_INT_FUNCTION);
    }

    @Config(value="maxWaitDuration")
    public String maxWaitDuration();

    default public Duration parseMaxWaitDuration() {
        return (Duration)Functions.parseStringToValue((String)this.maxWaitDuration(), (Object)BulkheadConfig.DEFAULT_MAX_WAIT_DURATION, Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Override
    default public Bulkhead bulkhead(String defaultName) {
        if (!this.enabledBulkhead()) {
            return null;
        }
        return Bulkhead.of((String)Condition.checkNotBlank((String)Condition.nonBlank((String[])new String[]{this.bulkheadName(), defaultName})), (BulkheadConfig)BulkheadConfig.custom().maxConcurrentCalls(this.parseMaxConcurrentCalls()).maxWaitDuration(this.parseMaxWaitDuration()).build());
    }

    @Config(value="bulkheadRecover")
    public String bulkheadRecoverString();

    @Override
    default public <T> ResilienceBulkheadRecover<T> bulkheadRecover() {
        return (ResilienceBulkheadRecover)Objectt.parseObject((String)this.bulkheadRecoverString(), ResilienceBulkheadRecover.class);
    }
}

