/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.configurer.configservice;

import com.github.charlemaznable.configservice.Config;
import com.github.charlemaznable.configservice.impl.Functions;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Objectt;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceCircuitBreakerConfigurer;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceCircuitBreakerRecover;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public interface ResilienceCircuitBreakerConfig
extends ResilienceCircuitBreakerConfigurer {
    @Config(value="enabledCircuitBreaker")
    public String enabledCircuitBreakerString();

    default public boolean enabledCircuitBreaker() {
        return BooleanUtils.toBoolean((String)this.enabledCircuitBreakerString());
    }

    @Config(value="circuitBreakerName")
    public String circuitBreakerName();

    @Config(value="slidingWindowType")
    public String slidingWindowType();

    default public CircuitBreakerConfig.SlidingWindowType parseSlidingWindowType() {
        return (CircuitBreakerConfig.SlidingWindowType)Functions.parseStringToValue((String)this.slidingWindowType(), (Object)CircuitBreakerConfig.SlidingWindowType.COUNT_BASED, CircuitBreakerConfig.SlidingWindowType::valueOf);
    }

    @Config(value="slidingWindowSize")
    public String slidingWindowSize();

    default public int parseSlidingWindowSize() {
        return (Integer)Functions.parseStringToValue((String)this.slidingWindowSize(), (Object)100, (Function)Functions.TO_INT_FUNCTION);
    }

    @Config(value="minimumNumberOfCalls")
    public String minimumNumberOfCalls();

    default public int parseMinimumNumberOfCalls() {
        return (Integer)Functions.parseStringToValue((String)this.minimumNumberOfCalls(), (Object)100, (Function)Functions.TO_INT_FUNCTION);
    }

    @Config(value="failureRateThreshold")
    public String failureRateThreshold();

    default public float parseFailureRateThreshold() {
        return ((Float)Functions.parseStringToValue((String)this.failureRateThreshold(), (Object)Float.valueOf(50.0f), (Function)Functions.TO_FLOAT_FUNCTION)).floatValue();
    }

    @Config(value="slowCallRateThreshold")
    public String slowCallRateThreshold();

    default public float parseSlowCallRateThreshold() {
        return ((Float)Functions.parseStringToValue((String)this.slowCallRateThreshold(), (Object)Float.valueOf(100.0f), (Function)Functions.TO_FLOAT_FUNCTION)).floatValue();
    }

    @Config(value="slowCallDurationThreshold")
    public String slowCallDurationThreshold();

    default public Duration parseSlowCallDurationThreshold() {
        return (Duration)Functions.parseStringToValue((String)this.slowCallDurationThreshold(), (Object)Duration.ofSeconds(60L), Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Config(value="automaticTransitionFromOpenToHalfOpenEnabled")
    public String automaticTransitionFromOpenToHalfOpenEnabled();

    default public boolean parseAutomaticTransitionFromOpenToHalfOpenEnabled() {
        return (Boolean)Functions.parseStringToValue((String)this.automaticTransitionFromOpenToHalfOpenEnabled(), (Object)false, (Function)Functions.TO_BOOLEAN_FUNCTION);
    }

    @Config(value="waitDurationInOpenState")
    public String waitDurationInOpenState();

    default public Duration parseWaitDurationInOpenState() {
        return (Duration)Functions.parseStringToValue((String)this.waitDurationInOpenState(), (Object)Duration.ofSeconds(60L), Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Config(value="permittedNumberOfCallsInHalfOpenState")
    public String permittedNumberOfCallsInHalfOpenState();

    default public int parsePermittedNumberOfCallsInHalfOpenState() {
        return (Integer)Functions.parseStringToValue((String)this.permittedNumberOfCallsInHalfOpenState(), (Object)10, (Function)Functions.TO_INT_FUNCTION);
    }

    @Config(value="maxWaitDurationInHalfOpenState")
    public String maxWaitDurationInHalfOpenState();

    default public Duration parseMaxWaitDurationInHalfOpenState() {
        return (Duration)Functions.parseStringToValue((String)this.maxWaitDurationInHalfOpenState(), (Object)Duration.ofSeconds(0L), Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Override
    default public CircuitBreaker circuitBreaker(String defaultName) {
        if (!this.enabledCircuitBreaker()) {
            return null;
        }
        return CircuitBreaker.of((String)Condition.checkNotBlank((String)Condition.nonBlank((String[])new String[]{this.circuitBreakerName(), defaultName})), (CircuitBreakerConfig)CircuitBreakerConfig.custom().slidingWindow(this.parseSlidingWindowSize(), this.parseMinimumNumberOfCalls(), this.parseSlidingWindowType()).failureRateThreshold(this.parseFailureRateThreshold()).slowCallRateThreshold(this.parseSlowCallRateThreshold()).slowCallDurationThreshold(this.parseSlowCallDurationThreshold()).automaticTransitionFromOpenToHalfOpenEnabled(this.parseAutomaticTransitionFromOpenToHalfOpenEnabled()).waitDurationInOpenState(this.parseWaitDurationInOpenState()).permittedNumberOfCallsInHalfOpenState(this.parsePermittedNumberOfCallsInHalfOpenState()).maxWaitDurationInHalfOpenState(this.parseMaxWaitDurationInHalfOpenState()).build());
    }

    @Config(value="circuitBreakerRecover")
    public String circuitBreakerRecoverString();

    @Override
    default public <T> ResilienceCircuitBreakerRecover<T> circuitBreakerRecover() {
        return (ResilienceCircuitBreakerRecover)Objectt.parseObject((String)this.circuitBreakerRecoverString(), ResilienceCircuitBreakerRecover.class);
    }
}

