/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.configurer.configservice;

import com.github.charlemaznable.configservice.Config;
import com.github.charlemaznable.configservice.impl.Functions;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Objectt;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceRateLimiterConfigurer;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceRateLimiterRecover;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public interface ResilienceRateLimiterConfig
extends ResilienceRateLimiterConfigurer {
    @Config(value="enabledRateLimiter")
    public String enabledRateLimiterString();

    default public boolean enabledRateLimiter() {
        return BooleanUtils.toBoolean((String)this.enabledRateLimiterString());
    }

    @Config(value="rateLimiterName")
    public String rateLimiterName();

    @Config(value="limitForPeriod")
    public String limitForPeriod();

    default public int parseLimitForPeriod() {
        return (Integer)Functions.parseStringToValue((String)this.limitForPeriod(), (Object)50, (Function)Functions.TO_INT_FUNCTION);
    }

    @Config(value="limitRefreshPeriodInNanos")
    public String limitRefreshPeriodInNanos();

    default public Duration parseLimitRefreshPeriod() {
        return (Duration)Functions.parseStringToValue((String)this.limitRefreshPeriodInNanos(), (Object)Duration.ofNanos(500L), Functions.TO_LONG_FUNCTION.andThen(Duration::ofNanos));
    }

    @Config(value="timeoutDuration")
    public String timeoutDuration();

    default public Duration parseTimeoutDuration() {
        return (Duration)Functions.parseStringToValue((String)this.timeoutDuration(), (Object)Duration.ofMillis(5000L), Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Override
    default public RateLimiter rateLimiter(String defaultName) {
        if (!this.enabledRateLimiter()) {
            return null;
        }
        return RateLimiter.of((String)Condition.checkNotBlank((String)Condition.nonBlank((String[])new String[]{this.rateLimiterName(), defaultName})), (RateLimiterConfig)RateLimiterConfig.custom().limitForPeriod(this.parseLimitForPeriod()).limitRefreshPeriod(this.parseLimitRefreshPeriod()).timeoutDuration(this.parseTimeoutDuration()).build());
    }

    @Config(value="rateLimiterRecover")
    public String rateLimiterRecoverString();

    @Override
    default public <T> ResilienceRateLimiterRecover<T> rateLimiterRecover() {
        return (ResilienceRateLimiterRecover)Objectt.parseObject((String)this.rateLimiterRecoverString(), ResilienceRateLimiterRecover.class);
    }
}

