/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.configurer.configservice;

import com.github.charlemaznable.configservice.Config;
import com.github.charlemaznable.configservice.impl.Functions;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceRetryConfigurer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public interface ResilienceRetryConfig
extends ResilienceRetryConfigurer {
    @Config(value="enabledRetry")
    public String enabledRetryString();

    default public boolean enabledRetry() {
        return BooleanUtils.toBoolean((String)this.enabledRetryString());
    }

    @Config(value="retryName")
    public String retryName();

    @Config(value="maxAttempts")
    public String maxAttempts();

    default public int parseMaxAttempts() {
        return (Integer)Functions.parseStringToValue((String)this.maxAttempts(), (Object)3, (Function)Functions.TO_INT_FUNCTION);
    }

    @Config(value="waitDuration")
    public String waitDuration();

    default public Duration parseWaitDuration() {
        return (Duration)Functions.parseStringToValue((String)this.waitDuration(), (Object)Duration.ofMillis(500L), Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Override
    default public Retry retry(String defaultName) {
        if (!this.enabledRetry()) {
            return null;
        }
        return Retry.of((String)Condition.checkNotBlank((String)Condition.nonBlank((String[])new String[]{this.retryName(), defaultName})), (RetryConfig)RetryConfig.custom().maxAttempts(this.parseMaxAttempts()).waitDuration(this.parseWaitDuration()).build());
    }

    @Config(value="isolatedExecutor")
    public String isolatedExecutorString();

    @Override
    default public boolean isolatedExecutor() {
        return BooleanUtils.toBoolean((String)this.isolatedExecutorString());
    }
}

