/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.resilience.configurer.configservice;

import com.github.charlemaznable.configservice.Config;
import com.github.charlemaznable.configservice.impl.Functions;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Objectt;
import com.github.charlemaznable.httpclient.resilience.configurer.ResilienceTimeLimiterConfigurer;
import com.github.charlemaznable.httpclient.resilience.function.ResilienceTimeLimiterRecover;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import org.apache.commons.lang3.BooleanUtils;

public interface ResilienceTimeLimiterConfig
extends ResilienceTimeLimiterConfigurer {
    @Config(value="enabledTimeLimiter")
    public String enabledTimeLimiterString();

    default public boolean enabledTimeLimiter() {
        return BooleanUtils.toBoolean((String)this.enabledTimeLimiterString());
    }

    @Config(value="timeLimiterName")
    public String timeLimiterName();

    @Config(value="timeoutDuration")
    public String timeoutDuration();

    default public Duration parseTimeoutDuration() {
        return (Duration)Functions.parseStringToValue((String)this.timeoutDuration(), (Object)Duration.ofMillis(1000L), Functions.TO_DURATION_FUNCTION.andThen(Duration::ofMillis));
    }

    @Override
    default public TimeLimiter timeLimiter(String defaultName) {
        if (!this.enabledTimeLimiter()) {
            return null;
        }
        return TimeLimiter.of((String)Condition.checkNotBlank((String)Condition.nonBlank((String[])new String[]{this.timeLimiterName(), defaultName})), (TimeLimiterConfig)TimeLimiterConfig.custom().timeoutDuration(this.parseTimeoutDuration()).build());
    }

    @Config(value="timeLimiterRecover")
    public String timeLimiterRecoverString();

    @Override
    default public <T> ResilienceTimeLimiterRecover<T> timeLimiterRecover() {
        return (ResilienceTimeLimiterRecover)Objectt.parseObject((String)this.timeLimiterRecoverString(), ResilienceTimeLimiterRecover.class);
    }
}

