/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient;

import com.github.charlemaznable.core.context.FactoryContext;
import com.github.charlemaznable.core.lang.BuddyEnhancer;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Factory;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.core.lang.Reloadable;
import com.github.charlemaznable.core.spring.SpringFactory;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceMeterBinder;
import com.github.charlemaznable.httpclient.vxclient.VxException;
import com.github.charlemaznable.httpclient.vxclient.enhancer.VxClientEnhancer;
import com.github.charlemaznable.httpclient.vxclient.internal.VxClass;
import com.github.charlemaznable.httpclient.vxclient.internal.VxDummy;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.vertx.core.Vertx;
import java.util.Comparator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class VxFactory {
    private static final LoadingCache<Factory, VxLoader> vxLoaderCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(VxLoader::new));
    private static final CopyOnWriteArrayList<VxClientEnhancer> enhancers = StreamSupport.stream(ServiceLoader.load(VxClientEnhancer.class).spliterator(), false).sorted(Comparator.comparingInt(VxClientEnhancer::getOrder).reversed()).collect(Collectors.toCollection(CopyOnWriteArrayList::new));

    public static <T> T getClient(Class<T> vxClass) {
        return VxFactory.vxLoader(FactoryContext.get()).getClient(vxClass);
    }

    public static VxLoader springVxLoader() {
        return VxFactory.vxLoader((Factory)SpringFactory.springFactory());
    }

    public static VxLoader vxLoader(Factory factory) {
        return (VxLoader)LoadingCachee.get(vxLoaderCache, (Object)factory);
    }

    @Generated
    private VxFactory() {
    }

    public static class VxLoader {
        private final Factory factory;
        private final LoadingCache<Class<?>, Object> vxCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(this::loadClient));
        private final Object vertxLock = new Object();
        private volatile VertxHolder vertxHolder;

        VxLoader(Factory factory) {
            this.factory = (Factory)Condition.checkNotNull((Object)factory);
        }

        public <T> T getClient(Class<T> vxClass) {
            return (T)LoadingCachee.get(this.vxCache, vxClass);
        }

        @Nonnull
        private <T> Object loadClient(@Nonnull Class<T> vxClass) {
            this.ensureClassIsAnInterface(vxClass);
            return this.wrapWithEnhancer(vxClass, BuddyEnhancer.create(VxDummy.class, (Object[])new Object[]{vxClass}, (Class[])new Class[]{vxClass, Reloadable.class, ResilienceMeterBinder.class}, invocation -> {
                if (invocation.getMethod().isDefault() || invocation.getMethod().getDeclaringClass().equals(VxDummy.class)) {
                    return 1;
                }
                return 0;
            }, (BuddyEnhancer.Delegate[])new BuddyEnhancer.Delegate[]{new VxClass(this.vertx(), this.factory, vxClass), BuddyEnhancer.CALL_SUPER}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Vertx vertx() {
            if (Objects.nonNull(this.vertxHolder)) {
                return this.vertxHolder.vertx;
            }
            Object object = this.vertxLock;
            synchronized (object) {
                if (Objects.nonNull(this.vertxHolder)) {
                    return this.vertxHolder.vertx;
                }
                this.vertxHolder = new VertxHolder((Vertx)Condition.checkNotNull((Object)((Vertx)FactoryContext.build((Factory)this.factory, Vertx.class)), (RuntimeException)new VxException("Cannot find Vertx Instance in Context")));
                return this.vertxHolder.vertx;
            }
        }

        private <T> void ensureClassIsAnInterface(Class<T> clazz) {
            if (clazz.isInterface()) {
                return;
            }
            throw new VxException(clazz + " is not An Interface");
        }

        private <T> Object wrapWithEnhancer(Class<T> ohClass, Object impl) {
            Object enhancedImpl = impl;
            for (VxClientEnhancer enhancer : enhancers) {
                if (!enhancer.isEnabled(ohClass)) continue;
                enhancedImpl = enhancer.build(ohClass, enhancedImpl);
            }
            return enhancedImpl;
        }
    }

    private static final class VertxHolder {
        private final Vertx vertx;

        @Generated
        public VertxHolder(Vertx vertx) {
            this.vertx = vertx;
        }
    }
}

