/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.CommonReq;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.google.common.collect.Iterators;
import io.netty.handler.logging.ByteBufFormat;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.uritemplate.ExpandOptions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class VxReq
extends CommonReq<VxReq> {
    private final Vertx vertx;
    private final WebClientOptions webClientOptions;

    public VxReq(Vertx vertx) {
        this.vertx = vertx;
        this.webClientOptions = new WebClientOptions();
    }

    public VxReq(Vertx vertx, String baseUrl) {
        super(baseUrl);
        this.vertx = vertx;
        this.webClientOptions = new WebClientOptions();
    }

    public WebClient buildWebClient() {
        return WebClient.create((Vertx)Objects.requireNonNull(this.vertx), (WebClientOptions)this.webClientOptions);
    }

    public Instance buildInstance() {
        return new Instance(this, this.buildWebClient());
    }

    @SafeVarargs
    public final void get(Handler<AsyncResult<String>> ... handlers) {
        this.buildInstance().get(handlers);
    }

    @SafeVarargs
    public final void post(Handler<AsyncResult<String>> ... handlers) {
        this.buildInstance().post(handlers);
    }

    public Future<String> get() {
        return this.buildInstance().get();
    }

    public Future<String> post() {
        return this.buildInstance().post();
    }

    @Generated
    public JsonObject toJson() {
        return this.webClientOptions.toJson();
    }

    @Generated
    public boolean isUserAgentEnabled() {
        return this.webClientOptions.isUserAgentEnabled();
    }

    @Generated
    public WebClientOptions setUserAgentEnabled(boolean userAgentEnabled) {
        return this.webClientOptions.setUserAgentEnabled(userAgentEnabled);
    }

    @Generated
    public String getUserAgent() {
        return this.webClientOptions.getUserAgent();
    }

    @Generated
    public WebClientOptions setUserAgent(String userAgent) {
        return this.webClientOptions.setUserAgent(userAgent);
    }

    @Generated
    public boolean isFollowRedirects() {
        return this.webClientOptions.isFollowRedirects();
    }

    @Generated
    public WebClientOptions setFollowRedirects(boolean followRedirects) {
        return this.webClientOptions.setFollowRedirects(followRedirects);
    }

    @Generated
    public ExpandOptions getTemplateExpandOptions() {
        return this.webClientOptions.getTemplateExpandOptions();
    }

    @Generated
    public WebClientOptions setTemplateExpandOptions(ExpandOptions templateExpandOptions) {
        return this.webClientOptions.setTemplateExpandOptions(templateExpandOptions);
    }

    @Generated
    public WebClientOptions setMaxRedirects(int maxRedirects) {
        return this.webClientOptions.setMaxRedirects(maxRedirects);
    }

    @Generated
    public WebClientOptions setSendBufferSize(int sendBufferSize) {
        return this.webClientOptions.setSendBufferSize(sendBufferSize);
    }

    @Generated
    public WebClientOptions setReceiveBufferSize(int receiveBufferSize) {
        return this.webClientOptions.setReceiveBufferSize(receiveBufferSize);
    }

    @Generated
    public WebClientOptions setReuseAddress(boolean reuseAddress) {
        return this.webClientOptions.setReuseAddress(reuseAddress);
    }

    @Generated
    public WebClientOptions setTrafficClass(int trafficClass) {
        return this.webClientOptions.setTrafficClass(trafficClass);
    }

    @Generated
    public WebClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        return this.webClientOptions.setTcpNoDelay(tcpNoDelay);
    }

    @Generated
    public WebClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return this.webClientOptions.setTcpKeepAlive(tcpKeepAlive);
    }

    @Generated
    public WebClientOptions setSoLinger(int soLinger) {
        return this.webClientOptions.setSoLinger(soLinger);
    }

    @Generated
    public WebClientOptions setIdleTimeout(int idleTimeout) {
        return this.webClientOptions.setIdleTimeout(idleTimeout);
    }

    @Generated
    public WebClientOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return this.webClientOptions.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    @Generated
    public WebClientOptions setSsl(boolean ssl) {
        return this.webClientOptions.setSsl(ssl);
    }

    @Generated
    public WebClientOptions setKeyCertOptions(KeyCertOptions options) {
        return this.webClientOptions.setKeyCertOptions(options);
    }

    @Generated
    public WebClientOptions setKeyStoreOptions(JksOptions options) {
        return this.webClientOptions.setKeyStoreOptions(options);
    }

    @Generated
    public WebClientOptions setPfxKeyCertOptions(PfxOptions options) {
        return this.webClientOptions.setPfxKeyCertOptions(options);
    }

    @Generated
    public WebClientOptions setTrustOptions(TrustOptions options) {
        return this.webClientOptions.setTrustOptions(options);
    }

    @Generated
    public WebClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return this.webClientOptions.setPemKeyCertOptions(options);
    }

    @Generated
    public WebClientOptions setTrustStoreOptions(JksOptions options) {
        return this.webClientOptions.setTrustStoreOptions(options);
    }

    @Generated
    public WebClientOptions setPfxTrustOptions(PfxOptions options) {
        return this.webClientOptions.setPfxTrustOptions(options);
    }

    @Generated
    public WebClientOptions setPemTrustOptions(PemTrustOptions options) {
        return this.webClientOptions.setPemTrustOptions(options);
    }

    @Generated
    public WebClientOptions addEnabledCipherSuite(String suite) {
        return this.webClientOptions.addEnabledCipherSuite(suite);
    }

    @Generated
    public WebClientOptions addCrlPath(String crlPath) throws NullPointerException {
        return this.webClientOptions.addCrlPath(crlPath);
    }

    @Generated
    public WebClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return this.webClientOptions.addCrlValue(crlValue);
    }

    @Generated
    public WebClientOptions setConnectTimeout(int connectTimeout) {
        return this.webClientOptions.setConnectTimeout(connectTimeout);
    }

    @Generated
    public WebClientOptions setTrustAll(boolean trustAll) {
        return this.webClientOptions.setTrustAll(trustAll);
    }

    @Generated
    public WebClientOptions setMaxPoolSize(int maxPoolSize) {
        return this.webClientOptions.setMaxPoolSize(maxPoolSize);
    }

    @Generated
    public WebClientOptions setHttp2MultiplexingLimit(int limit) {
        return this.webClientOptions.setHttp2MultiplexingLimit(limit);
    }

    @Generated
    public WebClientOptions setHttp2MaxPoolSize(int max) {
        return this.webClientOptions.setHttp2MaxPoolSize(max);
    }

    @Generated
    public WebClientOptions setHttp2ConnectionWindowSize(int http2ConnectionWindowSize) {
        return this.webClientOptions.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
    }

    @Generated
    public WebClientOptions setKeepAlive(boolean keepAlive) {
        return this.webClientOptions.setKeepAlive(keepAlive);
    }

    @Generated
    public WebClientOptions setPipelining(boolean pipelining) {
        return this.webClientOptions.setPipelining(pipelining);
    }

    @Generated
    public WebClientOptions setPipeliningLimit(int limit) {
        return this.webClientOptions.setPipeliningLimit(limit);
    }

    @Generated
    public WebClientOptions setVerifyHost(boolean verifyHost) {
        return this.webClientOptions.setVerifyHost(verifyHost);
    }

    @Generated
    public WebClientOptions setTryUseCompression(boolean tryUseCompression) {
        return this.webClientOptions.setTryUseCompression(tryUseCompression);
    }

    @Generated
    public WebClientOptions setSendUnmaskedFrames(boolean sendUnmaskedFrames) {
        return this.webClientOptions.setSendUnmaskedFrames(sendUnmaskedFrames);
    }

    @Generated
    public WebClientOptions setMaxWebSocketFrameSize(int maxWebsocketFrameSize) {
        return this.webClientOptions.setMaxWebSocketFrameSize(maxWebsocketFrameSize);
    }

    @Generated
    public WebClientOptions setDefaultHost(String defaultHost) {
        return this.webClientOptions.setDefaultHost(defaultHost);
    }

    @Generated
    public WebClientOptions setDefaultPort(int defaultPort) {
        return this.webClientOptions.setDefaultPort(defaultPort);
    }

    @Generated
    public WebClientOptions setMaxChunkSize(int maxChunkSize) {
        return this.webClientOptions.setMaxChunkSize(maxChunkSize);
    }

    @Generated
    public WebClientOptions setProtocolVersion(HttpVersion protocolVersion) {
        return this.webClientOptions.setProtocolVersion(protocolVersion);
    }

    @Generated
    public WebClientOptions setMaxHeaderSize(int maxHeaderSize) {
        return this.webClientOptions.setMaxHeaderSize(maxHeaderSize);
    }

    @Generated
    public WebClientOptions setMaxWaitQueueSize(int maxWaitQueueSize) {
        return this.webClientOptions.setMaxWaitQueueSize(maxWaitQueueSize);
    }

    @Generated
    public WebClientOptions setUseAlpn(boolean useAlpn) {
        return this.webClientOptions.setUseAlpn(useAlpn);
    }

    @Generated
    public WebClientOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return this.webClientOptions.setSslEngineOptions(sslEngineOptions);
    }

    @Generated
    public WebClientOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return this.webClientOptions.setJdkSslEngineOptions(sslEngineOptions);
    }

    @Generated
    public WebClientOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return this.webClientOptions.setOpenSslEngineOptions(sslEngineOptions);
    }

    @Generated
    public WebClientOptions setHttp2ClearTextUpgrade(boolean value) {
        return this.webClientOptions.setHttp2ClearTextUpgrade(value);
    }

    @Generated
    public WebClientOptions setAlpnVersions(List<HttpVersion> alpnVersions) {
        return this.webClientOptions.setAlpnVersions(alpnVersions);
    }

    @Generated
    public WebClientOptions setMetricsName(String metricsName) {
        return this.webClientOptions.setMetricsName(metricsName);
    }

    @Generated
    public WebClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        return this.webClientOptions.setProxyOptions(proxyOptions);
    }

    @Generated
    public WebClientOptions setLocalAddress(String localAddress) {
        return this.webClientOptions.setLocalAddress(localAddress);
    }

    @Generated
    public WebClientOptions setLogActivity(boolean logEnabled) {
        return this.webClientOptions.setLogActivity(logEnabled);
    }

    @Generated
    public WebClientOptions addEnabledSecureTransportProtocol(String protocol) {
        return this.webClientOptions.addEnabledSecureTransportProtocol(protocol);
    }

    @Generated
    public WebClientOptions removeEnabledSecureTransportProtocol(String protocol) {
        return this.webClientOptions.removeEnabledSecureTransportProtocol(protocol);
    }

    @Generated
    public WebClientOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return this.webClientOptions.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    @Generated
    public WebClientOptions setReusePort(boolean reusePort) {
        return this.webClientOptions.setReusePort(reusePort);
    }

    @Generated
    public WebClientOptions setTcpFastOpen(boolean tcpFastOpen) {
        return this.webClientOptions.setTcpFastOpen(tcpFastOpen);
    }

    @Generated
    public WebClientOptions setTcpCork(boolean tcpCork) {
        return this.webClientOptions.setTcpCork(tcpCork);
    }

    @Generated
    public WebClientOptions setTcpQuickAck(boolean tcpQuickAck) {
        return this.webClientOptions.setTcpQuickAck(tcpQuickAck);
    }

    @Generated
    public WebClientOptions setHttp2KeepAliveTimeout(int keepAliveTimeout) {
        return this.webClientOptions.setHttp2KeepAliveTimeout(keepAliveTimeout);
    }

    @Generated
    public WebClientOptions setForceSni(boolean forceSni) {
        return this.webClientOptions.setForceSni(forceSni);
    }

    @Generated
    public WebClientOptions setDecoderInitialBufferSize(int decoderInitialBufferSize) {
        return this.webClientOptions.setDecoderInitialBufferSize(decoderInitialBufferSize);
    }

    @Generated
    public WebClientOptions setPoolCleanerPeriod(int poolCleanerPeriod) {
        return this.webClientOptions.setPoolCleanerPeriod(poolCleanerPeriod);
    }

    @Generated
    public WebClientOptions setKeepAliveTimeout(int keepAliveTimeout) {
        return this.webClientOptions.setKeepAliveTimeout(keepAliveTimeout);
    }

    @Generated
    public WebClientOptions setMaxWebSocketMessageSize(int maxWebsocketMessageSize) {
        return this.webClientOptions.setMaxWebSocketMessageSize(maxWebsocketMessageSize);
    }

    @Generated
    public WebClientOptions setMaxInitialLineLength(int maxInitialLineLength) {
        return this.webClientOptions.setMaxInitialLineLength(maxInitialLineLength);
    }

    @Generated
    public WebClientOptions setInitialSettings(Http2Settings settings) {
        return this.webClientOptions.setInitialSettings(settings);
    }

    @Generated
    public WebClientOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return this.webClientOptions.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    @Generated
    public WebClientOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return this.webClientOptions.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    @Generated
    public WebClientOptions setTryUsePerFrameWebSocketCompression(boolean offer) {
        return this.webClientOptions.setTryUsePerFrameWebSocketCompression(offer);
    }

    @Generated
    public WebClientOptions setTryUsePerMessageWebSocketCompression(boolean offer) {
        return this.webClientOptions.setTryUsePerMessageWebSocketCompression(offer);
    }

    @Generated
    public WebClientOptions setWebSocketCompressionLevel(int compressionLevel) {
        return this.webClientOptions.setWebSocketCompressionLevel(compressionLevel);
    }

    @Generated
    public WebClientOptions setWebSocketCompressionAllowClientNoContext(boolean offer) {
        return this.webClientOptions.setWebSocketCompressionAllowClientNoContext(offer);
    }

    @Generated
    public WebClientOptions setWebSocketCompressionRequestServerNoContext(boolean offer) {
        return this.webClientOptions.setWebSocketCompressionRequestServerNoContext(offer);
    }

    @Generated
    public WebClientOptions setReadIdleTimeout(int idleTimeout) {
        return this.webClientOptions.setReadIdleTimeout(idleTimeout);
    }

    @Generated
    public WebClientOptions setWriteIdleTimeout(int idleTimeout) {
        return this.webClientOptions.setWriteIdleTimeout(idleTimeout);
    }

    @Generated
    public WebClientOptions setMaxWebSockets(int maxWebSockets) {
        return this.webClientOptions.setMaxWebSockets(maxWebSockets);
    }

    @Generated
    public WebClientOptions setNonProxyHosts(List<String> nonProxyHosts) {
        return this.webClientOptions.setNonProxyHosts(nonProxyHosts);
    }

    @Generated
    public WebClientOptions addNonProxyHost(String nonProxyHost) {
        return this.webClientOptions.addNonProxyHost(nonProxyHost);
    }

    @Generated
    public WebClientOptions setWebSocketClosingTimeout(int webSocketClosingTimeout) {
        return this.webClientOptions.setWebSocketClosingTimeout(webSocketClosingTimeout);
    }

    @Generated
    public WebClientOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        return this.webClientOptions.setTracingPolicy(tracingPolicy);
    }

    @Generated
    public WebClientOptions setPoolEventLoopSize(int poolEventLoopSize) {
        return this.webClientOptions.setPoolEventLoopSize(poolEventLoopSize);
    }

    @Generated
    public WebClientOptions setShared(boolean shared) {
        return this.webClientOptions.setShared(shared);
    }

    @Generated
    public WebClientOptions setName(String name) {
        return this.webClientOptions.setName(name);
    }

    @Generated
    public HttpClientOptions removeEnabledCipherSuite(String suite) {
        return this.webClientOptions.removeEnabledCipherSuite(suite);
    }

    @Generated
    public HttpClientOptions setTcpUserTimeout(int tcpUserTimeout) {
        return this.webClientOptions.setTcpUserTimeout(tcpUserTimeout);
    }

    @Generated
    public int getMaxPoolSize() {
        return this.webClientOptions.getMaxPoolSize();
    }

    @Generated
    public int getHttp2MultiplexingLimit() {
        return this.webClientOptions.getHttp2MultiplexingLimit();
    }

    @Generated
    public int getHttp2MaxPoolSize() {
        return this.webClientOptions.getHttp2MaxPoolSize();
    }

    @Generated
    public int getHttp2ConnectionWindowSize() {
        return this.webClientOptions.getHttp2ConnectionWindowSize();
    }

    @Generated
    public int getHttp2KeepAliveTimeout() {
        return this.webClientOptions.getHttp2KeepAliveTimeout();
    }

    @Generated
    public boolean isKeepAlive() {
        return this.webClientOptions.isKeepAlive();
    }

    @Generated
    public int getKeepAliveTimeout() {
        return this.webClientOptions.getKeepAliveTimeout();
    }

    @Generated
    public boolean isPipelining() {
        return this.webClientOptions.isPipelining();
    }

    @Generated
    public int getPipeliningLimit() {
        return this.webClientOptions.getPipeliningLimit();
    }

    @Generated
    public boolean isVerifyHost() {
        return this.webClientOptions.isVerifyHost();
    }

    @Generated
    public boolean isTryUseCompression() {
        return this.webClientOptions.isTryUseCompression();
    }

    @Generated
    public boolean isSendUnmaskedFrames() {
        return this.webClientOptions.isSendUnmaskedFrames();
    }

    @Generated
    public int getMaxWebSocketFrameSize() {
        return this.webClientOptions.getMaxWebSocketFrameSize();
    }

    @Generated
    public int getMaxWebSocketMessageSize() {
        return this.webClientOptions.getMaxWebSocketMessageSize();
    }

    @Generated
    public int getMaxWebSockets() {
        return this.webClientOptions.getMaxWebSockets();
    }

    @Generated
    public String getDefaultHost() {
        return this.webClientOptions.getDefaultHost();
    }

    @Generated
    public int getDefaultPort() {
        return this.webClientOptions.getDefaultPort();
    }

    @Generated
    public HttpVersion getProtocolVersion() {
        return this.webClientOptions.getProtocolVersion();
    }

    @Generated
    public int getMaxChunkSize() {
        return this.webClientOptions.getMaxChunkSize();
    }

    @Generated
    public int getMaxInitialLineLength() {
        return this.webClientOptions.getMaxInitialLineLength();
    }

    @Generated
    public int getMaxHeaderSize() {
        return this.webClientOptions.getMaxHeaderSize();
    }

    @Generated
    public int getMaxWaitQueueSize() {
        return this.webClientOptions.getMaxWaitQueueSize();
    }

    @Generated
    public Http2Settings getInitialSettings() {
        return this.webClientOptions.getInitialSettings();
    }

    @Generated
    public List<HttpVersion> getAlpnVersions() {
        return this.webClientOptions.getAlpnVersions();
    }

    @Generated
    public boolean isHttp2ClearTextUpgrade() {
        return this.webClientOptions.isHttp2ClearTextUpgrade();
    }

    @Generated
    public boolean isHttp2ClearTextUpgradeWithPreflightRequest() {
        return this.webClientOptions.isHttp2ClearTextUpgradeWithPreflightRequest();
    }

    @Generated
    public HttpClientOptions setHttp2ClearTextUpgradeWithPreflightRequest(boolean value) {
        return this.webClientOptions.setHttp2ClearTextUpgradeWithPreflightRequest(value);
    }

    @Generated
    public int getMaxRedirects() {
        return this.webClientOptions.getMaxRedirects();
    }

    @Generated
    public boolean isForceSni() {
        return this.webClientOptions.isForceSni();
    }

    @Generated
    public HttpClientOptions setActivityLogDataFormat(ByteBufFormat activityLogDataFormat) {
        return this.webClientOptions.setActivityLogDataFormat(activityLogDataFormat);
    }

    @Generated
    public boolean getTryWebSocketDeflateFrameCompression() {
        return this.webClientOptions.getTryWebSocketDeflateFrameCompression();
    }

    @Generated
    public boolean getTryUsePerMessageWebSocketCompression() {
        return this.webClientOptions.getTryUsePerMessageWebSocketCompression();
    }

    @Generated
    public int getWebSocketCompressionLevel() {
        return this.webClientOptions.getWebSocketCompressionLevel();
    }

    @Generated
    public boolean getWebSocketCompressionAllowClientNoContext() {
        return this.webClientOptions.getWebSocketCompressionAllowClientNoContext();
    }

    @Generated
    public boolean getWebSocketCompressionRequestServerNoContext() {
        return this.webClientOptions.getWebSocketCompressionRequestServerNoContext();
    }

    @Generated
    public int getWebSocketClosingTimeout() {
        return this.webClientOptions.getWebSocketClosingTimeout();
    }

    @Generated
    public int getDecoderInitialBufferSize() {
        return this.webClientOptions.getDecoderInitialBufferSize();
    }

    @Generated
    public int getPoolCleanerPeriod() {
        return this.webClientOptions.getPoolCleanerPeriod();
    }

    @Generated
    public int getPoolEventLoopSize() {
        return this.webClientOptions.getPoolEventLoopSize();
    }

    @Generated
    public TracingPolicy getTracingPolicy() {
        return this.webClientOptions.getTracingPolicy();
    }

    @Generated
    public boolean isShared() {
        return this.webClientOptions.isShared();
    }

    @Generated
    public String getName() {
        return this.webClientOptions.getName();
    }

    @Generated
    public boolean isTrustAll() {
        return this.webClientOptions.isTrustAll();
    }

    @Generated
    public int getConnectTimeout() {
        return this.webClientOptions.getConnectTimeout();
    }

    @Generated
    public String getMetricsName() {
        return this.webClientOptions.getMetricsName();
    }

    @Generated
    public ProxyOptions getProxyOptions() {
        return this.webClientOptions.getProxyOptions();
    }

    @Generated
    public List<String> getNonProxyHosts() {
        return this.webClientOptions.getNonProxyHosts();
    }

    @Generated
    public String getLocalAddress() {
        return this.webClientOptions.getLocalAddress();
    }

    @Generated
    public SSLOptions getSslOptions() {
        return this.webClientOptions.getSslOptions();
    }

    @Generated
    public boolean isTcpNoDelay() {
        return this.webClientOptions.isTcpNoDelay();
    }

    @Generated
    public boolean isTcpKeepAlive() {
        return this.webClientOptions.isTcpKeepAlive();
    }

    @Generated
    public int getSoLinger() {
        return this.webClientOptions.getSoLinger();
    }

    @Generated
    public int getIdleTimeout() {
        return this.webClientOptions.getIdleTimeout();
    }

    @Generated
    public int getReadIdleTimeout() {
        return this.webClientOptions.getReadIdleTimeout();
    }

    @Generated
    public int getWriteIdleTimeout() {
        return this.webClientOptions.getWriteIdleTimeout();
    }

    @Generated
    public TimeUnit getIdleTimeoutUnit() {
        return this.webClientOptions.getIdleTimeoutUnit();
    }

    @Generated
    public boolean isSsl() {
        return this.webClientOptions.isSsl();
    }

    @Generated
    public KeyCertOptions getKeyCertOptions() {
        return this.webClientOptions.getKeyCertOptions();
    }

    @Generated
    public JksOptions getKeyStoreOptions() {
        return this.webClientOptions.getKeyStoreOptions();
    }

    @Generated
    public PfxOptions getPfxKeyCertOptions() {
        return this.webClientOptions.getPfxKeyCertOptions();
    }

    @Generated
    public PemKeyCertOptions getPemKeyCertOptions() {
        return this.webClientOptions.getPemKeyCertOptions();
    }

    @Generated
    public TrustOptions getTrustOptions() {
        return this.webClientOptions.getTrustOptions();
    }

    @Generated
    public JksOptions getTrustStoreOptions() {
        return this.webClientOptions.getTrustStoreOptions();
    }

    @Generated
    public PfxOptions getPfxTrustOptions() {
        return this.webClientOptions.getPfxTrustOptions();
    }

    @Generated
    public PemTrustOptions getPemTrustOptions() {
        return this.webClientOptions.getPemTrustOptions();
    }

    @Generated
    public Set<String> getEnabledCipherSuites() {
        return this.webClientOptions.getEnabledCipherSuites();
    }

    @Generated
    public List<String> getCrlPaths() {
        return this.webClientOptions.getCrlPaths();
    }

    @Generated
    public List<Buffer> getCrlValues() {
        return this.webClientOptions.getCrlValues();
    }

    @Generated
    public boolean isUseAlpn() {
        return this.webClientOptions.isUseAlpn();
    }

    @Generated
    public SSLEngineOptions getSslEngineOptions() {
        return this.webClientOptions.getSslEngineOptions();
    }

    @Generated
    public JdkSSLEngineOptions getJdkSslEngineOptions() {
        return this.webClientOptions.getJdkSslEngineOptions();
    }

    @Generated
    public OpenSSLEngineOptions getOpenSslEngineOptions() {
        return this.webClientOptions.getOpenSslEngineOptions();
    }

    @Generated
    public boolean isTcpFastOpen() {
        return this.webClientOptions.isTcpFastOpen();
    }

    @Generated
    public boolean isTcpCork() {
        return this.webClientOptions.isTcpCork();
    }

    @Generated
    public boolean isTcpQuickAck() {
        return this.webClientOptions.isTcpQuickAck();
    }

    @Generated
    public int getTcpUserTimeout() {
        return this.webClientOptions.getTcpUserTimeout();
    }

    @Generated
    public Set<String> getEnabledSecureTransportProtocols() {
        return this.webClientOptions.getEnabledSecureTransportProtocols();
    }

    @Generated
    public long getSslHandshakeTimeout() {
        return this.webClientOptions.getSslHandshakeTimeout();
    }

    @Generated
    public TimeUnit getSslHandshakeTimeoutUnit() {
        return this.webClientOptions.getSslHandshakeTimeoutUnit();
    }

    @Generated
    public int getSendBufferSize() {
        return this.webClientOptions.getSendBufferSize();
    }

    @Generated
    public int getReceiveBufferSize() {
        return this.webClientOptions.getReceiveBufferSize();
    }

    @Generated
    public boolean isReuseAddress() {
        return this.webClientOptions.isReuseAddress();
    }

    @Generated
    public int getTrafficClass() {
        return this.webClientOptions.getTrafficClass();
    }

    @Generated
    public boolean getLogActivity() {
        return this.webClientOptions.getLogActivity();
    }

    @Generated
    public ByteBufFormat getActivityLogDataFormat() {
        return this.webClientOptions.getActivityLogDataFormat();
    }

    @Generated
    public boolean isReusePort() {
        return this.webClientOptions.isReusePort();
    }

    public static final class Instance
    extends CommonReq.Instance<Instance> {
        private final WebClient webClient;

        public <U extends CommonReq<U>> Instance(CommonReq<U> other, WebClient webClient) {
            super(other);
            this.webClient = webClient;
        }

        @Override
        public Instance copy() {
            return new Instance(this, this.webClient);
        }

        @SafeVarargs
        public final void get(Handler<AsyncResult<String>> ... handlers) {
            this.request(this::buildGetRequest, this::buildGetBody, handlers);
        }

        @SafeVarargs
        public final void post(Handler<AsyncResult<String>> ... handlers) {
            this.request(this::buildPostRequest, this::buildPostBody, handlers);
        }

        public Future<String> get() {
            return this.request(this::buildGetRequest, this::buildGetBody);
        }

        public Future<String> post() {
            return this.request(this::buildPostRequest, this::buildPostBody);
        }

        @SafeVarargs
        private void request(Supplier<HttpRequest<Buffer>> requestBuilder, Supplier<Buffer> bodySupplier, Handler<AsyncResult<String>> ... handlers) {
            requestBuilder.get().sendBuffer(bodySupplier.get(), this.handle(handlers));
        }

        private Future<String> request(Supplier<HttpRequest<Buffer>> requestBuilder, Supplier<Buffer> bodySupplier) {
            Promise promise = Promise.promise();
            requestBuilder.get().sendBuffer(bodySupplier.get(), this.handle(new Handler[]{promise}));
            return promise.future();
        }

        private HttpRequest<Buffer> buildGetRequest() {
            Map<String, Object> parameterMap = this.fetchParameterMap();
            String requestUrl = this.concatRequestUrl(parameterMap);
            MultiMap headersMap = this.fetchHeaderMap();
            String query = CommonConstant.URL_QUERY_FORMATTER.format(parameterMap, Mapp.newHashMap());
            return this.webClient.getAbs(Url.concatUrlQuery((String)requestUrl, (String)query)).putHeaders(headersMap);
        }

        private Buffer buildGetBody() {
            return null;
        }

        private HttpRequest<Buffer> buildPostRequest() {
            Map<String, Object> parameterMap = this.fetchParameterMap();
            String requestUrl = this.concatRequestUrl(parameterMap);
            MultiMap headersMap = this.fetchHeaderMap();
            return this.webClient.postAbs(requestUrl).putHeaders(headersMap);
        }

        private Buffer buildPostBody() {
            String content = (String)Condition.nullThen((Object)this.requestBody, () -> this.contentFormatter().format(this.fetchParameterMap(), Mapp.newHashMap()));
            String charset = Instance.parseCharset(this.contentFormatter().contentType());
            return Buffer.buffer((String)content, (String)charset);
        }

        private MultiMap fetchHeaderMap() {
            MultiMap headersMap = MultiMap.caseInsensitiveMultiMap();
            String acceptCharsetName = this.acceptCharset().name();
            headersMap.set("Accept-Charset", acceptCharsetName);
            String contentType = this.contentFormatter().contentType();
            headersMap.set("Content-Type", contentType);
            for (Pair<String, String> header : this.headers()) {
                Condition.checkNull((Object)((String)header.getValue()), () -> headersMap.remove((String)header.getKey()), xx -> headersMap.set((String)header.getKey(), (String)header.getValue()));
            }
            return headersMap;
        }

        @SafeVarargs
        private Handler<AsyncResult<HttpResponse<Buffer>>> handle(Handler<AsyncResult<String>> ... handlers) {
            return arResponse -> {
                Promise promise;
                block6: {
                    promise = Promise.promise();
                    if (arResponse.succeeded()) {
                        try {
                            HttpResponse response = (HttpResponse)arResponse.result();
                            int statusCode = response.statusCode();
                            String responseBody = response.bodyAsString(this.acceptCharset().name());
                            FallbackFunction<?> statusFallback = this.statusFallbackMapping().get((Object)HttpStatus.valueOf(statusCode));
                            FallbackFunction<?> statusSeriesFallback = this.statusSeriesFallbackMapping().get((Object)HttpStatus.Series.valueOf(statusCode));
                            if (Objects.nonNull(statusFallback)) {
                                promise.complete((Object)this.applyFallback(statusFallback, statusCode, responseBody));
                                break block6;
                            }
                            if (Objects.nonNull(statusSeriesFallback)) {
                                promise.complete((Object)this.applyFallback(statusSeriesFallback, statusCode, responseBody));
                                break block6;
                            }
                            promise.complete((Object)responseBody);
                        }
                        catch (Exception e) {
                            promise.fail((Throwable)e);
                        }
                    } else {
                        promise.fail(arResponse.cause());
                    }
                }
                this.iterateHandlers((Promise<String>)promise, handlers);
            };
        }

        private String applyFallback(FallbackFunction<?> function, int statusCode, String responseBody) {
            return Str.toStr(function.apply(new FallbackFunction.Response<String>(statusCode, responseBody){

                @Override
                public String responseBodyAsString() {
                    return (String)this.getResponseBody();
                }
            }));
        }

        @SafeVarargs
        private void iterateHandlers(Promise<String> promise, Handler<AsyncResult<String>> ... handlers) {
            Iterators.forArray((Object[])handlers).forEachRemaining(handler -> Condition.notNullThenRun((Object)handler, h -> h.handle((Object)promise.future())));
        }
    }
}

