/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient.elf;

import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.httpclient.logging.LoggingVxInterceptor;
import com.github.charlemaznable.httpclient.vxclient.elf.VertxScopeClientBuilder;
import com.github.charlemaznable.httpclient.vxclient.elf.VxWebClient;
import com.github.charlemaznable.httpclient.westcache.WestCacheConstant;
import com.github.charlemaznable.httpclient.westcache.WestCacheVxInterceptor;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.WebClientInternal;
import java.util.Iterator;
import java.util.ServiceLoader;
import lombok.Generated;

public final class VertxScopeClientElf {
    private static final VertxScopeClientBuilder instance;
    private static final LoadingCache<Vertx, WebClientInternal> scopeClientCache;

    public static WebClientInternal scopeClient(Vertx vertx) {
        return (WebClientInternal)LoadingCachee.get(scopeClientCache, (Object)vertx);
    }

    private static WebClientInternal buildScopeClient(Vertx vertx) {
        return instance.build(vertx);
    }

    private static VertxScopeClientBuilder findBuilder() {
        Iterator<VertxScopeClientBuilder> builders = ServiceLoader.load(VertxScopeClientBuilder.class).iterator();
        if (!builders.hasNext()) {
            return new DefaultVertxScopeClientBuilder();
        }
        VertxScopeClientBuilder result = builders.next();
        if (builders.hasNext()) {
            throw new IllegalStateException("Multiple VertxScopeClientBuilder Found");
        }
        return result;
    }

    @Generated
    private VertxScopeClientElf() {
    }

    static {
        scopeClientCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(VertxScopeClientElf::buildScopeClient));
        instance = VertxScopeClientElf.findBuilder();
    }

    public static class DefaultVertxScopeClientBuilder
    implements VertxScopeClientBuilder {
        @Override
        public WebClientInternal build(Vertx vertx) {
            VxWebClient client = new VxWebClient(vertx, new WebClientOptions());
            client.addInterceptor(new LoggingVxInterceptor());
            if (WestCacheConstant.HAS_WESTCACHE) {
                client.addInterceptor(new WestCacheVxInterceptor(vertx));
            }
            return client;
        }
    }
}

