/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient.elf;

import com.github.charlemaznable.core.lang.Listt;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientBase;
import io.vertx.ext.web.client.impl.WebClientInternal;
import io.vertx.uritemplate.UriTemplate;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.joor.Reflect;

public final class VxWebClient
implements WebClientInternal {
    private final HttpClient httpClient;
    private final WebClientOptions options;
    private final UnaryOperator<WebClientBase> buildOperation;
    private final List<Handler<HttpContext<?>>> interceptors;
    private final WebClientBase webClientBase;

    VxWebClient(Vertx vertx, WebClientOptions options) {
        this(vertx.createHttpClient((HttpClientOptions)options), options, UnaryOperator.identity(), null);
    }

    public VxWebClient(HttpClient httpClient, WebClientOptions options, UnaryOperator<WebClientBase> buildOperation, List<Handler<HttpContext<?>>> interceptors) {
        this.httpClient = httpClient;
        this.options = new WebClientOptions(options);
        this.buildOperation = buildOperation;
        this.interceptors = new CopyOnWriteArrayList();
        this.webClientBase = (WebClientBase)this.buildOperation.apply(new WebClientBase(this.httpClient, this.options));
        List newInterceptors = (List)Reflect.on((Object)this.webClientBase).get("interceptors");
        Listt.newArrayList(interceptors).stream().filter(Objects::nonNull).forEach(interceptor -> {
            if (newInterceptors.stream().noneMatch(i -> i.getClass() == interceptor.getClass())) {
                this.interceptors.add((Handler<HttpContext<?>>)interceptor);
                this.webClientBase.addInterceptor(interceptor);
            }
        });
    }

    public <T> HttpContext<T> createContext(Handler<AsyncResult<HttpResponse<T>>> handler) {
        return this.webClientBase.createContext(handler);
    }

    public WebClientInternal addInterceptor(Handler<HttpContext<?>> handler) {
        this.interceptors.add(handler);
        return this.webClientBase.addInterceptor(handler);
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public WebClientOptions getOptions() {
        return this.options;
    }

    @Generated
    public UnaryOperator<WebClientBase> getBuildOperation() {
        return this.buildOperation;
    }

    @Generated
    public List<Handler<HttpContext<?>>> getInterceptors() {
        return this.interceptors;
    }

    @Generated
    public WebClientBase getWebClientBase() {
        return this.webClientBase;
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, int port, String host, String requestURI) {
        return this.getWebClientBase().request(method, port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().request(method, port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, int arg2, String arg3, String arg4) {
        return this.getWebClientBase().request(arg0, arg1, arg2, arg3, arg4);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, int arg2, String arg3, UriTemplate arg4) {
        return this.getWebClientBase().request(arg0, arg1, arg2, arg3, arg4);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, String host, String requestURI) {
        return this.getWebClientBase().request(method, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, String host, UriTemplate requestURI) {
        return this.getWebClientBase().request(method, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, String arg2, String arg3) {
        return this.getWebClientBase().request(arg0, arg1, arg2, arg3);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, String arg2, UriTemplate arg3) {
        return this.getWebClientBase().request(arg0, arg1, arg2, arg3);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, String requestURI) {
        return this.getWebClientBase().request(method, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, UriTemplate requestURI) {
        return this.getWebClientBase().request(method, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, String arg2) {
        return this.getWebClientBase().request(arg0, arg1, arg2);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, UriTemplate arg2) {
        return this.getWebClientBase().request(arg0, arg1, arg2);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod method, RequestOptions options) {
        return this.getWebClientBase().request(method, options);
    }

    @Generated
    public HttpRequest<Buffer> request(HttpMethod arg0, SocketAddress arg1, RequestOptions arg2) {
        return this.getWebClientBase().request(arg0, arg1, arg2);
    }

    @Generated
    public HttpRequest<Buffer> requestAbs(HttpMethod method, String absoluteURI) {
        return this.getWebClientBase().requestAbs(method, absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> requestAbs(HttpMethod method, UriTemplate absoluteURI) {
        return this.getWebClientBase().requestAbs(method, absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> requestAbs(HttpMethod arg0, SocketAddress arg1, String arg2) {
        return this.getWebClientBase().requestAbs(arg0, arg1, arg2);
    }

    @Generated
    public HttpRequest<Buffer> requestAbs(HttpMethod arg0, SocketAddress arg1, UriTemplate arg2) {
        return this.getWebClientBase().requestAbs(arg0, arg1, arg2);
    }

    @Generated
    public HttpRequest<Buffer> get(String requestURI) {
        return this.getWebClientBase().get(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> get(UriTemplate requestURI) {
        return this.getWebClientBase().get(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> get(int port, String host, String requestURI) {
        return this.getWebClientBase().get(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> get(int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().get(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> get(String host, String requestURI) {
        return this.getWebClientBase().get(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> get(String host, UriTemplate requestURI) {
        return this.getWebClientBase().get(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> getAbs(String absoluteURI) {
        return this.getWebClientBase().getAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> getAbs(UriTemplate absoluteURI) {
        return this.getWebClientBase().getAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> post(String requestURI) {
        return this.getWebClientBase().post(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> post(UriTemplate requestURI) {
        return this.getWebClientBase().post(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> post(int port, String host, String requestURI) {
        return this.getWebClientBase().post(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> post(int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().post(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> post(String host, String requestURI) {
        return this.getWebClientBase().post(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> post(String host, UriTemplate requestURI) {
        return this.getWebClientBase().post(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> postAbs(String absoluteURI) {
        return this.getWebClientBase().postAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> postAbs(UriTemplate absoluteURI) {
        return this.getWebClientBase().postAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> put(String requestURI) {
        return this.getWebClientBase().put(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> put(UriTemplate requestURI) {
        return this.getWebClientBase().put(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> put(int port, String host, String requestURI) {
        return this.getWebClientBase().put(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> put(int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().put(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> put(String host, String requestURI) {
        return this.getWebClientBase().put(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> put(String host, UriTemplate requestURI) {
        return this.getWebClientBase().put(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> putAbs(String absoluteURI) {
        return this.getWebClientBase().putAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> putAbs(UriTemplate absoluteURI) {
        return this.getWebClientBase().putAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> delete(String requestURI) {
        return this.getWebClientBase().delete(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> delete(UriTemplate requestURI) {
        return this.getWebClientBase().delete(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> delete(int port, String host, String requestURI) {
        return this.getWebClientBase().delete(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> delete(int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().delete(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> delete(String host, String requestURI) {
        return this.getWebClientBase().delete(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> delete(String host, UriTemplate requestURI) {
        return this.getWebClientBase().delete(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> deleteAbs(String absoluteURI) {
        return this.getWebClientBase().deleteAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> deleteAbs(UriTemplate absoluteURI) {
        return this.getWebClientBase().deleteAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> patch(String requestURI) {
        return this.getWebClientBase().patch(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> patch(UriTemplate requestURI) {
        return this.getWebClientBase().patch(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> patch(int port, String host, String requestURI) {
        return this.getWebClientBase().patch(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> patch(int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().patch(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> patch(String host, String requestURI) {
        return this.getWebClientBase().patch(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> patch(String host, UriTemplate requestURI) {
        return this.getWebClientBase().patch(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> patchAbs(String absoluteURI) {
        return this.getWebClientBase().patchAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> patchAbs(UriTemplate absoluteURI) {
        return this.getWebClientBase().patchAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> head(String requestURI) {
        return this.getWebClientBase().head(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> head(UriTemplate requestURI) {
        return this.getWebClientBase().head(requestURI);
    }

    @Generated
    public HttpRequest<Buffer> head(int port, String host, String requestURI) {
        return this.getWebClientBase().head(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> head(int port, String host, UriTemplate requestURI) {
        return this.getWebClientBase().head(port, host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> head(String host, String requestURI) {
        return this.getWebClientBase().head(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> head(String host, UriTemplate requestURI) {
        return this.getWebClientBase().head(host, requestURI);
    }

    @Generated
    public HttpRequest<Buffer> headAbs(String absoluteURI) {
        return this.getWebClientBase().headAbs(absoluteURI);
    }

    @Generated
    public HttpRequest<Buffer> headAbs(UriTemplate absoluteURI) {
        return this.getWebClientBase().headAbs(absoluteURI);
    }

    @Generated
    public void close() {
        this.getWebClientBase().close();
    }
}

