/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient.elf;

import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.httpclient.vxclient.elf.VxWebClient;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientBase;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.joor.Reflect;

public final class VxWebClientBuilder {
    private HttpClient httpClient;
    private WebClientOptions options;
    private UnaryOperator<WebClientBase> buildOperation = UnaryOperator.identity();
    private List<Handler<HttpContext<?>>> interceptors = new CopyOnWriteArrayList();

    public VxWebClientBuilder(WebClientBase webClientBase) {
        this.httpClient = this.getClient(webClientBase);
        this.options = new WebClientOptions(this.getOptions(webClientBase));
        this.interceptors.addAll(Listt.newArrayList(this.getInterceptors(webClientBase)));
    }

    public VxWebClientBuilder(VxWebClient vxWebClient) {
        this.httpClient = vxWebClient.getHttpClient();
        this.options = new WebClientOptions(vxWebClient.getOptions());
        this.buildOperation = vxWebClient.getBuildOperation();
        this.interceptors.addAll(Listt.newArrayList(vxWebClient.getInterceptors()));
    }

    public VxWebClient build() {
        return new VxWebClient(this.httpClient, this.options, this.buildOperation, this.interceptors);
    }

    private HttpClient getClient(WebClientBase webClientBase) {
        return (HttpClient)Reflect.on((Object)webClientBase).get("client");
    }

    private WebClientOptions getOptions(WebClientBase webClientBase) {
        return (WebClientOptions)Reflect.on((Object)webClientBase).get("options");
    }

    private List<Handler<HttpContext<?>>> getInterceptors(WebClientBase webClientBase) {
        return (List)Reflect.on((Object)webClientBase).get("interceptors");
    }

    @Generated
    public VxWebClientBuilder() {
    }

    @Generated
    public HttpClient httpClient() {
        return this.httpClient;
    }

    @Generated
    public WebClientOptions options() {
        return this.options;
    }

    @Generated
    public UnaryOperator<WebClientBase> buildOperation() {
        return this.buildOperation;
    }

    @Generated
    public List<Handler<HttpContext<?>>> interceptors() {
        return this.interceptors;
    }

    @Generated
    public VxWebClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    @Generated
    public VxWebClientBuilder options(WebClientOptions options) {
        this.options = options;
        return this;
    }

    @Generated
    public VxWebClientBuilder buildOperation(UnaryOperator<WebClientBase> buildOperation) {
        this.buildOperation = buildOperation;
        return this;
    }

    @Generated
    public VxWebClientBuilder interceptors(List<Handler<HttpContext<?>>> interceptors) {
        this.interceptors = interceptors;
        return this;
    }
}

