/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient.internal;

import com.github.charlemaznable.core.lang.Factory;
import com.github.charlemaznable.httpclient.common.CommonElement;
import com.github.charlemaznable.httpclient.configurer.Configurer;
import com.github.charlemaznable.httpclient.vxclient.configurer.VertxWebClientBuilderConfigurer;
import com.github.charlemaznable.httpclient.vxclient.elf.VxWebClient;
import com.github.charlemaznable.httpclient.vxclient.elf.VxWebClientBuilder;
import com.github.charlemaznable.httpclient.vxclient.internal.VxBase;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.impl.WebClientBase;
import io.vertx.ext.web.client.impl.WebClientInternal;
import java.lang.reflect.AnnotatedElement;

final class VxElement
extends CommonElement<VxBase> {
    public VxElement(Vertx vertx, Factory factory) {
        super(new VxBase(vertx), factory);
    }

    @Override
    public void initialize(AnnotatedElement element, VxBase superBase) {
        super.initialize(element, superBase);
        ((VxBase)this.base()).client = this.buildClient(superBase.client);
    }

    private WebClientInternal buildClient(WebClientInternal defaultClient) {
        Configurer configurer = this.configurer();
        if (configurer instanceof VertxWebClientBuilderConfigurer) {
            VertxWebClientBuilderConfigurer builderConfigurer = (VertxWebClientBuilderConfigurer)configurer;
            if (defaultClient instanceof WebClientBase) {
                WebClientBase webClientBase = (WebClientBase)defaultClient;
                return builderConfigurer.configBuilder(new VxWebClientBuilder(webClientBase)).build();
            }
            if (defaultClient instanceof VxWebClient) {
                VxWebClient vxWebClient = (VxWebClient)defaultClient;
                return builderConfigurer.configBuilder(new VxWebClientBuilder(vxWebClient)).build();
            }
            throw new IllegalArgumentException("Unsupported WebClient Type: " + defaultClient.getClass());
        }
        return defaultClient;
    }
}

