/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.vxclient.internal;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.CommonExecute;
import com.github.charlemaznable.httpclient.common.CommonReq;
import com.github.charlemaznable.httpclient.vxclient.elf.HttpContextConfigElf;
import com.github.charlemaznable.httpclient.vxclient.internal.VxBase;
import com.github.charlemaznable.httpclient.vxclient.internal.VxExecuteRequest;
import com.github.charlemaznable.httpclient.vxclient.internal.VxMethod;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientInternal;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

final class VxExecute
extends CommonExecute<VxBase, VxMethod, HttpResponse<Buffer>, Buffer> {
    public VxExecute(VxMethod vxMethod) {
        super(new VxBase((VxBase)vxMethod.element().base()), vxMethod);
    }

    @Override
    protected boolean processParameterType(Object argument, Class<?> parameterType) {
        if (argument instanceof WebClientInternal) {
            WebClientInternal client;
            ((VxBase)this.base()).client = client = (WebClientInternal)argument;
            return true;
        }
        return super.processParameterType(argument, parameterType);
    }

    @Override
    public Object execute() {
        return this.adaptationFromFuture(this.decorateAsyncExecute(() -> {
            VxExecuteRequest request = this.buildRequest();
            Promise promise = Promise.promise();
            HttpContext context = ((VxBase)this.base()).client.createContext((Handler)promise);
            HttpContextConfigElf.configHttpContext(context, this);
            context.set(VxExecuteRequest.class.getName(), (Object)request);
            context.prepareRequest(request.bufferHttpRequest, null, (Object)request.buffer);
            return promise.future().map(this::processResponse).toCompletionStage();
        }));
    }

    private VxExecuteRequest buildRequest() {
        Condition.notNullThenRun((Object)((VxBase)this.base()).requestExtender(), extender -> extender.extend(((VxBase)this.base()).headers(), ((VxBase)this.base()).pathVars(), ((VxBase)this.base()).parameters(), ((VxBase)this.base()).contexts()));
        HeadersMultiMap httpHeaders = HeadersMultiMap.httpHeaders();
        String acceptCharsetName = ((VxBase)this.base()).acceptCharset().name();
        httpHeaders.set("Accept-Charset", acceptCharsetName);
        String contentType = ((VxBase)this.base()).contentFormatter().contentType();
        httpHeaders.set("Content-Type", contentType);
        for (Pair<String, String> header : ((VxBase)this.base()).headers()) {
            Condition.checkNull((Object)((String)header.getValue()), () -> httpHeaders.remove((String)header.getKey()), xx -> httpHeaders.set((String)header.getKey(), (String)header.getValue()));
        }
        CommonExecute.CommonExecuteParams executeParams = this.buildCommonExecuteParams();
        VxExecuteRequest request = new VxExecuteRequest();
        if (!CommonReq.permitsRequestBody(executeParams.requestMethod()).booleanValue()) {
            String query = CommonConstant.URL_QUERY_FORMATTER.format(executeParams.parameterMap(), executeParams.contextMap());
            request.requestUrl = Url.concatUrlQuery((String)executeParams.requestUrl(), (String)query);
            request.bufferHttpRequest = ((VxBase)this.base()).client.requestAbs(HttpMethod.valueOf((String)executeParams.requestMethod()), request.requestUrl);
        } else {
            String content = (String)Condition.nullThen((Object)this.requestBodyRaw(), () -> ((VxBase)this.base()).contentFormatter().format(executeParams.parameterMap(), executeParams.contextMap()));
            String contentTypeHeader = (String)Condition.nullThen((Object)httpHeaders.get("Content-Type"), CommonConstant.DEFAULT_CONTENT_FORMATTER::contentType);
            String charset = CommonReq.parseCharset(contentTypeHeader);
            request.requestUrl = executeParams.requestUrl();
            request.bufferHttpRequest = ((VxBase)this.base()).client.requestAbs(HttpMethod.valueOf((String)executeParams.requestMethod()), request.requestUrl);
            request.buffer = Buffer.buffer((String)content, (String)charset);
        }
        request.bufferHttpRequest.putHeaders((MultiMap)httpHeaders);
        return request;
    }

    @Override
    protected int getResponseCode(HttpResponse<Buffer> response) {
        return response.statusCode();
    }

    @Override
    protected Buffer getResponseBody(HttpResponse<Buffer> response) {
        return (Buffer)Condition.nullThen((Object)((Buffer)response.body()), Buffer::buffer);
    }

    @Override
    protected String getResponseBodyString(Buffer responseBody) {
        return responseBody.toString(((VxBase)this.base()).acceptCharset());
    }

    @Override
    protected Object customProcessReturnTypeValue(int statusCode, Buffer responseBody, Class<?> returnType) {
        if (Buffer.class == returnType) {
            return responseBody;
        }
        if (byte[].class == returnType) {
            return Condition.notNullThen((Object)responseBody, Buffer::getBytes);
        }
        if (JsonObject.class == returnType) {
            return Condition.notNullThen((Object)responseBody, (Function)BodyCodecImpl.JSON_OBJECT_DECODER);
        }
        if (JsonArray.class == returnType) {
            return Condition.notNullThen((Object)responseBody, (Function)BodyCodecImpl.JSON_ARRAY_DECODER);
        }
        return super.customProcessReturnTypeValue(statusCode, responseBody, returnType);
    }

    @Override
    protected Object adaptationFromFuture(CompletableFuture<Object> future) {
        if (((VxMethod)this.executeMethod()).returnCoreFuture) {
            return Future.fromCompletionStage(future);
        }
        return super.adaptationFromFuture(future);
    }
}

