/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.westcache;

import com.github.bingoohuang.westcache.base.WestCacheItem;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.httpclient.ohclient.internal.OhResponseBody;
import com.github.charlemaznable.httpclient.westcache.WestCacheConstant;
import com.github.charlemaznable.httpclient.westcache.WestCacheContext;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jooq.lambda.Sneaky;

public final class WestCacheOhInterceptor
implements Interceptor {
    private final Cache<WestCacheContext, Optional<CacheResponse>> localCache;
    private final Set<Integer> cachedStatusCodes = WestCacheConstant.buildDefaultStatusCodes();

    public WestCacheOhInterceptor() {
        this(10L, 60L);
    }

    public WestCacheOhInterceptor(long localMaximumSize, long localExpireSeconds) {
        this.localCache = CacheBuilder.newBuilder().maximumSize(localMaximumSize).expireAfterWrite(localExpireSeconds, TimeUnit.SECONDS).build();
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        WestCacheContext context = (WestCacheContext)request.tag(WestCacheContext.class);
        if (Objects.isNull(context)) {
            return chain.proceed(request);
        }
        NetworkResponse networkResponse = new NetworkResponse();
        Optional cachedOptional = (Optional)LoadingCachee.get(this.localCache, (Object)context, () -> {
            WestCacheItem cachedItem = context.cacheGet();
            if (Objects.nonNull(cachedItem) && cachedItem.getObject().isPresent()) {
                return Optional.of((CacheResponse)cachedItem.getObject().get());
            }
            Response response = chain.proceed(request);
            int code = response.code();
            if (!this.cachedStatusCodes.contains(code)) {
                networkResponse.setResponse(response);
                return Optional.empty();
            }
            CacheResponse cacheResponse = new CacheResponse();
            cacheResponse.setProtocol(response.protocol().toString());
            cacheResponse.setCode(response.code());
            cacheResponse.setMessage(response.message());
            cacheResponse.setHeaders(response.headers().toMultimap());
            OhResponseBody responseBody = (OhResponseBody)((Object)((Object)Condition.notNullThen((Object)response.body(), OhResponseBody::new)));
            if (Objects.nonNull(response.body())) {
                response.close();
            }
            CacheResponseBody cacheResponseBody = new CacheResponseBody();
            cacheResponseBody.setContentType(Str.toStr((Object)responseBody.contentType()));
            cacheResponseBody.setContentLength(responseBody.contentLength());
            cacheResponseBody.readFromResponseBody(responseBody);
            cacheResponse.setBody(cacheResponseBody);
            context.cachePut(cacheResponse);
            return Optional.of(cacheResponse);
        });
        if (cachedOptional.isEmpty()) {
            return (Response)Condition.nullThen((Object)networkResponse.getResponse(), (Supplier)Sneaky.supplier(() -> chain.proceed(request)));
        }
        CacheResponse cacheResponse = (CacheResponse)cachedOptional.get();
        return new Response.Builder().request(request).protocol(Protocol.get((String)cacheResponse.getProtocol())).code(cacheResponse.getCode()).message(cacheResponse.getMessage()).headers(cacheResponse.buildHeaders()).body(cacheResponse.getBody().buildResponseBody()).build();
    }

    @Generated
    public Set<Integer> getCachedStatusCodes() {
        return this.cachedStatusCodes;
    }

    private static final class NetworkResponse {
        private Response response;

        private NetworkResponse() {
        }

        @Generated
        public Response getResponse() {
            return this.response;
        }

        @Generated
        public void setResponse(Response response) {
            this.response = response;
        }
    }

    public static final class CacheResponse {
        private String protocol;
        private int code;
        private String message;
        private Map<String, List<String>> headers;
        private CacheResponseBody body;

        public Headers buildHeaders() {
            Headers.Builder headersBuilder = new Headers.Builder();
            for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
                for (String value : entry.getValue()) {
                    headersBuilder.add(entry.getKey(), value);
                }
            }
            return headersBuilder.build();
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public CacheResponseBody getBody() {
            return this.body;
        }

        @Generated
        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Generated
        public void setCode(int code) {
            this.code = code;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        @Generated
        public void setBody(CacheResponseBody body) {
            this.body = body;
        }
    }

    public static final class CacheResponseBody {
        private String contentType;
        private long contentLength;
        private byte[] content;

        public void readFromResponseBody(ResponseBody responseBody) {
            this.setContent(responseBody.bytes());
        }

        public ResponseBody buildResponseBody() {
            return new OhResponseBody((ResponseBody)new RealResponseBody(this.getContentType(), this.getContentLength(), Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(this.getContent())))));
        }

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        public long getContentLength() {
            return this.contentLength;
        }

        @Generated
        public byte[] getContent() {
            return this.content;
        }

        @Generated
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Generated
        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        @Generated
        public void setContent(byte[] content) {
            this.content = content;
        }
    }
}

