/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.westcache;

import com.github.bingoohuang.westcache.base.WestCacheItem;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.httpclient.westcache.WestCacheConstant;
import com.github.charlemaznable.httpclient.westcache.WestCacheContext;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class WestCacheVxInterceptor
implements Handler<HttpContext<?>> {
    private static final String IS_CACHE_DISPATCH = "cache.dispatch";
    private final Vertx vertx;
    private final LoadingCache<WestCacheContext, Optional<CacheResponse>> localCache;
    private final Map<WestCacheContext, WestCacheContext> lockMap = Maps.newConcurrentMap();
    private final Set<Integer> cachedStatusCodes = WestCacheConstant.buildDefaultStatusCodes();

    public WestCacheVxInterceptor(Vertx vertx) {
        this(vertx, 10L, 60L);
    }

    public WestCacheVxInterceptor(Vertx vertx, long localMaximumSize, long localExpireSeconds) {
        this.vertx = vertx;
        this.localCache = CacheBuilder.newBuilder().maximumSize(localMaximumSize).expireAfterWrite(localExpireSeconds, TimeUnit.SECONDS).build(CacheLoader.from(context -> {
            WestCacheItem cachedItem = context.cacheGet();
            if (Objects.nonNull(cachedItem) && cachedItem.getObject().isPresent()) {
                return Optional.of((CacheResponse)cachedItem.getObject().get());
            }
            return Optional.empty();
        }));
    }

    public void handle(HttpContext<?> httpContext) {
        WestCacheContext context = (WestCacheContext)httpContext.get(WestCacheContext.class.getName());
        if (Objects.isNull(context)) {
            httpContext.next();
            return;
        }
        switch (httpContext.phase()) {
            case CREATE_REQUEST: {
                this.handleCreateRequest(httpContext, context);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.handleDispatchResponse(httpContext, context);
                break;
            }
            case FAILURE: {
                this.handleFailure(httpContext, context);
                break;
            }
            default: {
                httpContext.next();
            }
        }
    }

    private void handleCreateRequest(HttpContext<Buffer> httpContext, WestCacheContext context) {
        this.checkCacheResponse(httpContext, context, () -> {
            if (Objects.isNull(this.lockMap.putIfAbsent(context, context))) {
                this.checkCacheResponse(httpContext, context, () -> ((HttpContext)httpContext).next());
            } else {
                httpContext.createRequest(httpContext.requestOptions());
            }
        });
    }

    private void checkCacheResponse(HttpContext<Buffer> httpContext, WestCacheContext context, Runnable runIfLocalCacheDoesNotExists) {
        this.vertx.executeBlocking(() -> (Optional)LoadingCachee.get(this.localCache, (Object)context)).onComplete(result -> {
            if (result.succeeded()) {
                if (((Optional)result.result()).isPresent()) {
                    this.dispatchCacheResponse(httpContext, (CacheResponse)((Optional)result.result()).get());
                } else {
                    runIfLocalCacheDoesNotExists.run();
                }
            } else {
                httpContext.next();
            }
        });
    }

    private void handleDispatchResponse(HttpContext<Buffer> httpContext, WestCacheContext context) {
        if (httpContext.get(IS_CACHE_DISPATCH) == Boolean.TRUE) {
            httpContext.next();
            return;
        }
        this.vertx.executeBlocking(() -> {
            HttpResponse response = httpContext.response();
            int statusCode = response.statusCode();
            if (!this.cachedStatusCodes.contains(statusCode)) {
                return null;
            }
            CacheResponse cacheResponse = new CacheResponse();
            cacheResponse.setVersion(response.version().name());
            cacheResponse.setStatusCode(statusCode);
            cacheResponse.setStatusMessage(response.statusMessage());
            cacheResponse.readFromResponseHeaders(response.headers());
            Buffer responseBody = (Buffer)Condition.nullThen((Object)((Buffer)response.body()), Buffer::buffer);
            CacheResponseBody cacheResponseBody = new CacheResponseBody();
            cacheResponseBody.readFromBuffer(responseBody);
            cacheResponse.setBody(cacheResponseBody);
            this.localCache.put((Object)context, Optional.of(cacheResponse));
            context.cachePut(cacheResponse);
            return null;
        }).onComplete(result -> this.lockMap.remove(context));
        httpContext.next();
    }

    private void dispatchCacheResponse(HttpContext<Buffer> httpContext, CacheResponse cacheResponse) {
        httpContext.set(IS_CACHE_DISPATCH, (Object)true);
        httpContext.dispatchResponse((HttpResponse)new HttpResponseImpl(HttpVersion.valueOf((String)cacheResponse.getVersion()), cacheResponse.getStatusCode(), cacheResponse.getStatusMessage(), cacheResponse.buildResponseHeaders(), MultiMap.caseInsensitiveMultiMap(), Collections.emptyList(), (Object)cacheResponse.getBody().buildBuffer(), Collections.emptyList()));
    }

    private void handleFailure(HttpContext<Buffer> httpContext, WestCacheContext context) {
        this.lockMap.remove(context);
        httpContext.next();
    }

    @Generated
    public Set<Integer> getCachedStatusCodes() {
        return this.cachedStatusCodes;
    }

    public static final class CacheResponse {
        private String version;
        private int statusCode;
        private String statusMessage;
        private Map<String, List<String>> responseHeaders;
        private CacheResponseBody body;

        public void readFromResponseHeaders(MultiMap responseHeaders) {
            HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
            responseHeaders.forEach((key, value) -> {
                ArrayList<String> values = (ArrayList<String>)headersMap.get(key);
                if (Objects.isNull(values)) {
                    values = new ArrayList<String>();
                    headersMap.put((String)key, (List<String>)values);
                }
                values.add((String)value);
            });
            this.setResponseHeaders(headersMap);
        }

        public MultiMap buildResponseHeaders() {
            HeadersMultiMap headersMultiMap = HeadersMultiMap.httpHeaders();
            for (Map.Entry<String, List<String>> entry : this.getResponseHeaders().entrySet()) {
                for (String value : entry.getValue()) {
                    headersMultiMap.add(entry.getKey(), value);
                }
            }
            return headersMultiMap;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public String getStatusMessage() {
            return this.statusMessage;
        }

        @Generated
        public Map<String, List<String>> getResponseHeaders() {
            return this.responseHeaders;
        }

        @Generated
        public CacheResponseBody getBody() {
            return this.body;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        @Generated
        public void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Generated
        public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
            this.responseHeaders = responseHeaders;
        }

        @Generated
        public void setBody(CacheResponseBody body) {
            this.body = body;
        }
    }

    public static final class CacheResponseBody {
        private byte[] content;

        public void readFromBuffer(Buffer responseBody) {
            this.setContent(responseBody.getBytes());
        }

        public Buffer buildBuffer() {
            return Buffer.buffer((byte[])this.getContent());
        }

        @Generated
        public byte[] getContent() {
            return this.content;
        }

        @Generated
        public void setContent(byte[] content) {
            this.content = content;
        }
    }
}

