/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.westcache;

import com.github.bingoohuang.westcache.base.WestCacheItem;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.httpclient.westcache.WestCacheConstant;
import com.github.charlemaznable.httpclient.westcache.WestCacheContext;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public final class WestCacheWfInterceptor
implements ExchangeFilterFunction {
    private final Cache<WestCacheContext, Optional<CacheResponse>> localCache;
    private final Map<WestCacheContext, ClientResponse> clientResponseMap = Maps.newConcurrentMap();
    private final Set<Integer> cachedStatusCodes = WestCacheConstant.buildDefaultStatusCodes();

    public WestCacheWfInterceptor() {
        this(10L, 60L);
    }

    public WestCacheWfInterceptor(long localMaximumSize, long localExpireSeconds) {
        this.localCache = CacheBuilder.newBuilder().maximumSize(localMaximumSize).expireAfterWrite(localExpireSeconds, TimeUnit.SECONDS).build();
    }

    @Nonnull
    public Mono<ClientResponse> filter(@Nonnull ClientRequest request, @Nonnull ExchangeFunction next) {
        Optional contextOptional = request.attribute(WestCacheContext.class.getName());
        if (contextOptional.isEmpty()) {
            return next.exchange(request);
        }
        WestCacheContext context = (WestCacheContext)contextOptional.get();
        return Mono.justOrEmpty((Optional)((Optional)LoadingCachee.get(this.localCache, (Object)context, () -> {
            WestCacheItem cachedItem = context.cacheGet();
            if (Objects.nonNull(cachedItem) && cachedItem.getObject().isPresent()) {
                return Optional.of((CacheResponse)cachedItem.getObject().get());
            }
            return next.exchange(request).flatMap(response -> {
                int code = response.statusCode().value();
                if (!this.cachedStatusCodes.contains(code)) {
                    this.clientResponseMap.put(context, (ClientResponse)response);
                    return Mono.empty();
                }
                return response.toEntity(String.class).map(entity -> {
                    CacheResponse cacheResponse = new CacheResponse();
                    cacheResponse.setCode(entity.getStatusCode().value());
                    cacheResponse.setHeaders((Map<String, List<String>>)entity.getHeaders());
                    cacheResponse.setBody((String)entity.getBody());
                    context.cachePut(cacheResponse);
                    return cacheResponse;
                });
            }).blockOptional();
        }))).map(cacheResponse -> ClientResponse.create((HttpStatusCode)HttpStatusCode.valueOf((int)cacheResponse.getCode())).headers(httpHeaders -> cacheResponse.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).addAll(arg_0, arg_1))).body(cacheResponse.getBody()).build()).switchIfEmpty(Mono.defer(() -> Mono.justOrEmpty((Object)this.clientResponseMap.remove(context)).switchIfEmpty(Mono.defer(() -> next.exchange(request)))));
    }

    @Generated
    public Set<Integer> getCachedStatusCodes() {
        return this.cachedStatusCodes;
    }

    public static final class CacheResponse {
        private int code;
        private Map<String, List<String>> headers;
        private String body;

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public void setCode(int code) {
            this.code = code;
        }

        @Generated
        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        @Generated
        public void setBody(String body) {
            this.body = body;
        }
    }
}

