/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.wfclient;

import com.github.charlemaznable.core.context.FactoryContext;
import com.github.charlemaznable.core.lang.BuddyEnhancer;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Factory;
import com.github.charlemaznable.core.lang.LoadingCachee;
import com.github.charlemaznable.core.lang.Reloadable;
import com.github.charlemaznable.core.spring.SpringFactory;
import com.github.charlemaznable.httpclient.resilience.common.ResilienceMeterBinder;
import com.github.charlemaznable.httpclient.wfclient.WfException;
import com.github.charlemaznable.httpclient.wfclient.enhancer.WfClientEnhancer;
import com.github.charlemaznable.httpclient.wfclient.internal.WfClass;
import com.github.charlemaznable.httpclient.wfclient.internal.WfDummy;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class WfFactory {
    private static final LoadingCache<Factory, WfLoader> wfLoaderCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(WfLoader::new));
    private static final CopyOnWriteArrayList<WfClientEnhancer> enhancers = StreamSupport.stream(ServiceLoader.load(WfClientEnhancer.class).spliterator(), false).sorted(Comparator.comparingInt(WfClientEnhancer::getOrder).reversed()).collect(Collectors.toCollection(CopyOnWriteArrayList::new));

    public static <T> T getClient(Class<T> wfClass) {
        return WfFactory.wfLoader(FactoryContext.get()).getClient(wfClass);
    }

    public static WfLoader springWfLoader() {
        return WfFactory.wfLoader((Factory)SpringFactory.springFactory());
    }

    public static WfLoader wfLoader(Factory factory) {
        return (WfLoader)LoadingCachee.get(wfLoaderCache, (Object)factory);
    }

    @Generated
    private WfFactory() {
    }

    public static class WfLoader {
        private final Factory factory;
        private final LoadingCache<Class<?>, Object> wfCache = LoadingCachee.simpleCache((CacheLoader)CacheLoader.from(this::loadClient));

        WfLoader(Factory factory) {
            this.factory = (Factory)Condition.checkNotNull((Object)factory);
        }

        public <T> T getClient(Class<T> wfClass) {
            return (T)LoadingCachee.get(this.wfCache, wfClass);
        }

        @Nonnull
        private <T> Object loadClient(@Nonnull Class<T> wfClass) {
            this.ensureClassIsAnInterface(wfClass);
            return this.wrapWithEnhancer(wfClass, BuddyEnhancer.create(WfDummy.class, (Object[])new Object[]{wfClass}, (Class[])new Class[]{wfClass, Reloadable.class, ResilienceMeterBinder.class}, invocation -> {
                if (invocation.getMethod().isDefault() || invocation.getMethod().getDeclaringClass().equals(WfDummy.class)) {
                    return 1;
                }
                return 0;
            }, (BuddyEnhancer.Delegate[])new BuddyEnhancer.Delegate[]{new WfClass(this.factory, wfClass), BuddyEnhancer.CALL_SUPER}));
        }

        private <T> void ensureClassIsAnInterface(Class<T> clazz) {
            if (clazz.isInterface()) {
                return;
            }
            throw new WfException(clazz + " is not An Interface");
        }

        private <T> Object wrapWithEnhancer(Class<T> wfClass, Object impl) {
            Object enhancedImpl = impl;
            for (WfClientEnhancer enhancer : enhancers) {
                if (!enhancer.isEnabled(wfClass)) continue;
                enhancedImpl = enhancer.build(wfClass, enhancedImpl);
            }
            return enhancedImpl;
        }
    }
}

